/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_data_source.ts.cpp
 *
 * @brief [LEVEL: beta] Implementation of the compliance test for
 * @ref diagnostics::unittest::Test_Data_Source
 *
 * $Id: test_data_source.ts.cpp,v 1.6 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/unittest/test_system/test_data_source.ts.hpp>

#include <diagnostics/unittest/test_system/test_data_source.hpp>

#include <diagnostics/unittest/test_system_exception.hpp>

#include <diagnostics/unittest.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;


Test_Data_Source_Compliance::Test_Data_Source_Compliance(Test_Data_Source * const source_init,
							 Test_Data_Source * const source)
    : m_source_init(source_init),
      m_source(source)
{
}


Test_Data_Source_Compliance::Test_Data_Source_Compliance(Self const & other)
    : m_source_init(other.m_source_init),
      m_source(other.m_source)
{
}

Test_Data_Source_Compliance & Test_Data_Source_Compliance::operator=(Self const & other)
{
    m_source_init=other.m_source_init;
    m_source=other.m_source;
    return *this;
}


void Test_Data_Source_Compliance::operator()(Test_Data & test_data) const
{
    ////////////////////////////////////////////////////////////////////////////////
    // uninitialized
    TEST_ASSERT(m_source->is_initialized()==false);

    TEST_THROWING_BLOCK_ENTER;
    m_source->exists_entry("x");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    TEST_THROWING_BLOCK_ENTER;
    m_source->get_entry("x");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);
    
    TEST_THROWING_BLOCK_ENTER;
    m_source->set_entry("x","y");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    ////////////////////////////////////////////////////////////////////////////////
    // initilized

    TEST_ASSERT(m_source_init->is_initialized()==true);

    TEST_ASSERT(m_source_init->exists_entry("x")==false);
    
    TEST_THROWING_BLOCK_ENTER;
    m_source_init->get_entry("x");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // set now
    m_source_init->set_entry("x","y");
    TEST_ASSERT(m_source_init->get_entry("x")=="y");
    TEST_THROWING_BLOCK_ENTER;
    m_source_init->get_entry("x1");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // set another one
    m_source_init->set_entry("x1","y1");
    TEST_ASSERT(m_source_init->get_entry("x")=="y");
    TEST_ASSERT(m_source_init->get_entry("x1")=="y1");
    TEST_THROWING_BLOCK_ENTER;
    m_source_init->get_entry("x2");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);

    // overwrite
    m_source_init->set_entry("x","Y");
    TEST_ASSERT(m_source_init->get_entry("x")=="Y");
    TEST_ASSERT(m_source_init->get_entry("x1")=="y1");
    TEST_THROWING_BLOCK_ENTER;
    m_source_init->get_entry("x2");
    TEST_THROWING_BLOCK_EXIT(Test_System_Exception);
}


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
