/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/frame/logging_config_exception.hpp
 *
 * @brief [LEVEL: beta] The @ref diagnostics::Logging_Config_Exception class
 *
 * $Id: logging_config_exception.hpp,v 1.6 2005/06/23 09:54:20 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @test none
 */

#ifndef DIAGNOSTICS__FRAME__LOGGING_CONFIG_EXCEPTION_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__FRAME__LOGGING_CONFIG_EXCEPTION_HPP__INCLUDE_GUARD

// used as base class
#include <diagnostics/frame/std_exception.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;

/**
 * @class Logging_Config_Exception
 *
 * @brief The Logging_Config_Exception is thrown by @ref
 * Logging_Config and concrete implementations of @ref Logger if a
 * configuration error occurs.
 *
 * @nosubgrouping
 */
class Logging_Config_Exception :
    public Std_Exception
{
    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Types
     * @{
     */
private:
    typedef Std_Exception Super;
    typedef Logging_Config_Exception Self;
    // @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Creation
     * @{
     */
public:
    /**
     * @throw never
     */
    explicit Logging_Config_Exception(::std::string const & what);
	
	/**
     * @throw never
     */ 
	Logging_Config_Exception(Self const & ohter);
	
    /**
     * @throw never
     */
    virtual ~Logging_Config_Exception() DIAGNOSTICS_EXCEPTIONS_THROW_DECL;
    // @}

	////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Disabled Creation
     * @{
     */
private:
	Self & operator=(Self const & other);
	// @}

    ////////////////////////////////////////////////////////////////////////////////
    /**
     * @name Accessors
     * @{
     */
public:
    /**
     * @throw never
     */
    virtual char const * name() const;
    // @}
};

DIAGNOSTICS_NAMESPACE_END;

#endif

// vim:ts=4:sw=4
