/* OperationRestore.c generated by valac 0.12.0, the Vala compiler
 * generated from OperationRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define DEJA_DUP_TYPE_OPERATION (deja_dup_operation_get_type ())
#define DEJA_DUP_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperation))
#define DEJA_DUP_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))
#define DEJA_DUP_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION))
#define DEJA_DUP_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION, DejaDupOperationClass))

typedef struct _DejaDupOperation DejaDupOperation;
typedef struct _DejaDupOperationClass DejaDupOperationClass;
typedef struct _DejaDupOperationPrivate DejaDupOperationPrivate;

#define DEJA_DUP_TYPE_DUPLICITY (deja_dup_duplicity_get_type ())
#define DEJA_DUP_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicity))
#define DEJA_DUP_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))
#define DEJA_DUP_IS_DUPLICITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_IS_DUPLICITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY))
#define DEJA_DUP_DUPLICITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY, DejaDupDuplicityClass))

typedef struct _DejaDupDuplicity DejaDupDuplicity;
typedef struct _DejaDupDuplicityClass DejaDupDuplicityClass;

#define DEJA_DUP_TYPE_OPERATION_RESTORE (deja_dup_operation_restore_get_type ())
#define DEJA_DUP_OPERATION_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestore))
#define DEJA_DUP_OPERATION_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestoreClass))
#define DEJA_DUP_IS_OPERATION_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE))
#define DEJA_DUP_IS_OPERATION_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_OPERATION_RESTORE))
#define DEJA_DUP_OPERATION_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestoreClass))

typedef struct _DejaDupOperationRestore DejaDupOperationRestore;
typedef struct _DejaDupOperationRestoreClass DejaDupOperationRestoreClass;
typedef struct _DejaDupOperationRestorePrivate DejaDupOperationRestorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupOperationRestoreStartData DejaDupOperationRestoreStartData;

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupOperationRestoreOperationFinishedData DejaDupOperationRestoreOperationFinishedData;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define DEJA_DUP_TYPE_RECURSIVE_OP (deja_dup_recursive_op_get_type ())
#define DEJA_DUP_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOp))
#define DEJA_DUP_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))
#define DEJA_DUP_IS_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_IS_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_RECURSIVE_OP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))

typedef struct _DejaDupRecursiveOp DejaDupRecursiveOp;
typedef struct _DejaDupRecursiveOpClass DejaDupRecursiveOpClass;

#define DEJA_DUP_TYPE_RECURSIVE_MOVE (deja_dup_recursive_move_get_type ())
#define DEJA_DUP_RECURSIVE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMove))
#define DEJA_DUP_RECURSIVE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMoveClass))
#define DEJA_DUP_IS_RECURSIVE_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE))
#define DEJA_DUP_IS_RECURSIVE_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_MOVE))
#define DEJA_DUP_RECURSIVE_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_MOVE, DejaDupRecursiveMoveClass))

typedef struct _DejaDupRecursiveMove DejaDupRecursiveMove;
typedef struct _DejaDupRecursiveMoveClass DejaDupRecursiveMoveClass;

#define DEJA_DUP_TYPE_RECURSIVE_DELETE (deja_dup_recursive_delete_get_type ())
#define DEJA_DUP_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDelete))
#define DEJA_DUP_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))
#define DEJA_DUP_IS_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_IS_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_RECURSIVE_DELETE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))

typedef struct _DejaDupRecursiveDelete DejaDupRecursiveDelete;
typedef struct _DejaDupRecursiveDeleteClass DejaDupRecursiveDeleteClass;

struct _DejaDupOperation {
	GObject parent_instance;
	DejaDupOperationPrivate * priv;
	DejaDupDuplicity* dup;
	gchar* passphrase;
};

struct _DejaDupOperationClass {
	GObjectClass parent_class;
	void (*start) (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*start_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	void (*connect_to_dup) (DejaDupOperation* self);
	void (*operation_finished) (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*operation_finished_finish) (DejaDupOperation* self, GAsyncResult* _res_);
	GList* (*make_argv) (DejaDupOperation* self, GError** error);
};

struct _DejaDupOperationRestore {
	DejaDupOperation parent_instance;
	DejaDupOperationRestorePrivate * priv;
};

struct _DejaDupOperationRestoreClass {
	DejaDupOperationClass parent_class;
};

struct _DejaDupOperationRestorePrivate {
	gchar* _dest;
	gchar* _time;
	gchar* source;
	GList* errors;
	GList* _restore_files;
};

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

struct _DejaDupOperationRestoreStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperationRestore* self;
	const gchar* _tmp0_;
	GList* _tmp1_;
};

struct _DejaDupOperationRestoreOperationFinishedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupOperationRestore* self;
	DejaDupDuplicity* dup;
	gboolean success;
	gboolean cancelled;
	gboolean _tmp0_;
	GError * e;
	GError * _inner_error_;
};


static gpointer deja_dup_operation_restore_parent_class = NULL;

GType deja_dup_operation_get_type (void) G_GNUC_CONST;
GType deja_dup_duplicity_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_restore_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_OPERATION_RESTORE, DejaDupOperationRestorePrivate))
enum  {
	DEJA_DUP_OPERATION_RESTORE_DUMMY_PROPERTY,
	DEJA_DUP_OPERATION_RESTORE_DEST,
	DEJA_DUP_OPERATION_RESTORE_TIME,
	DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
DejaDupOperationRestore* deja_dup_operation_restore_new (const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid);
DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid);
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
static void deja_dup_operation_restore_real_start_data_free (gpointer _data);
static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_operation_restore_real_start_co (DejaDupOperationRestoreStartData* data);
GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self);
void deja_dup_duplicity_set_restore_files (DejaDupDuplicity* self, GList* value);
void deja_dup_operation_start (DejaDupOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_start_finish (DejaDupOperation* self, GAsyncResult* _res_);
static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error);
GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_get_has_rename_arg (DejaDupDuplicityInfo* self);
const gchar* deja_dup_operation_restore_get_dest (DejaDupOperationRestore* self);
const gchar* deja_dup_operation_restore_get_time (DejaDupOperationRestore* self);
void deja_dup_duplicity_set_local (DejaDupDuplicity* self, GFile* value);
static void deja_dup_operation_restore_real_operation_finished_data_free (gpointer _data);
static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_operation_restore_real_operation_finished_co (DejaDupOperationRestoreOperationFinishedData* data);
static void deja_dup_operation_restore_fixup_home_dir (DejaDupOperationRestore* self);
static gboolean deja_dup_operation_restore_mv_source_to_dest (DejaDupOperationRestore* self);
static void deja_dup_operation_restore_cleanup_source (DejaDupOperationRestore* self);
void deja_dup_update_last_run_timestamp (GError** error);
void deja_dup_operation_operation_finished (DejaDupOperation* self, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_operation_operation_finished_finish (DejaDupOperation* self, GAsyncResult* _res_);
static void deja_dup_operation_restore_show_errors (DejaDupOperationRestore* self);
static void deja_dup_operation_restore_add_error (DejaDupOperationRestore* self, const gchar* relpath, const gchar* errstr);
GType deja_dup_recursive_op_get_type (void) G_GNUC_CONST;
static void deja_dup_operation_restore_mv_error (DejaDupOperationRestore* self, DejaDupRecursiveOp* move, GFile* src, GFile* dst, const gchar* errstr);
DejaDupRecursiveMove* deja_dup_recursive_move_new (GFile* source, GFile* dest);
DejaDupRecursiveMove* deja_dup_recursive_move_construct (GType object_type, GFile* source, GFile* dest);
GType deja_dup_recursive_move_get_type (void) G_GNUC_CONST;
static void _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error (DejaDupRecursiveOp* _sender, GFile* src, GFile* dst, const gchar* errstr, gpointer self);
void deja_dup_recursive_op_start (DejaDupRecursiveOp* self);
DejaDupRecursiveDelete* deja_dup_recursive_delete_new (GFile* source);
DejaDupRecursiveDelete* deja_dup_recursive_delete_construct (GType object_type, GFile* source);
GType deja_dup_recursive_delete_get_type (void) G_GNUC_CONST;
static void deja_dup_operation_restore_set_dest (DejaDupOperationRestore* self, const gchar* value);
static void deja_dup_operation_restore_set_time (DejaDupOperationRestore* self, const gchar* value);
static void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value);
static void deja_dup_operation_restore_finalize (GObject* obj);
static void _vala_deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


DejaDupOperationRestore* deja_dup_operation_restore_construct (GType object_type, const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid) {
	DejaDupOperationRestore * self = NULL;
	g_return_val_if_fail (dest_in != NULL, NULL);
	self = (DejaDupOperationRestore*) g_object_new (object_type, "xid", xid, "dest", dest_in, "time", time_in, "restore-files", files_in, "mode", DEJA_DUP_OPERATION_MODE_RESTORE, NULL);
	return self;
}


DejaDupOperationRestore* deja_dup_operation_restore_new (const gchar* dest_in, const gchar* time_in, GList* files_in, guint xid) {
	return deja_dup_operation_restore_construct (DEJA_DUP_TYPE_OPERATION_RESTORE, dest_in, time_in, files_in, xid);
}


static void deja_dup_operation_restore_real_start_data_free (gpointer _data) {
	DejaDupOperationRestoreStartData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupOperationRestoreStartData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_operation_restore_real_start (DejaDupOperation* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationRestore * self;
	DejaDupOperationRestoreStartData* _data_;
	self = (DejaDupOperationRestore*) base;
	_data_ = g_slice_new0 (DejaDupOperationRestoreStartData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_restore_real_start);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_restore_real_start_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_operation_restore_real_start_co (_data_);
}


static void deja_dup_operation_restore_real_start_finish (DejaDupOperation* base, GAsyncResult* _res_) {
	DejaDupOperationRestoreStartData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_operation_restore_real_start_co (DejaDupOperationRestoreStartData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = _ ("Restoring files…");
	g_signal_emit_by_name ((DejaDupOperation*) data->self, "action-desc-changed", data->_tmp0_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = deja_dup_operation_restore_get_restore_files (data->self);
	deja_dup_duplicity_set_restore_files (((DejaDupOperation*) data->self)->dup, data->_tmp1_);
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->start (DEJA_DUP_OPERATION (data->self), NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static GList* deja_dup_operation_restore_real_make_argv (DejaDupOperation* base, GError** error) {
	DejaDupOperationRestore * self;
	GList* result = NULL;
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GList* argv;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_;
	self = (DejaDupOperationRestore*) base;
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_has_rename_arg (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (self->priv->_dest);
		_g_free0 (self->priv->source);
		self->priv->source = _tmp4_;
	} else {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp5_ = g_get_tmp_dir ();
		_tmp6_ = g_build_filename (_tmp5_, "deja-dup-XXXXXX", NULL);
		_g_free0 (self->priv->source);
		self->priv->source = _tmp6_;
		_tmp7_ = mkdtemp (self->priv->source);
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->source);
		self->priv->source = _tmp8_;
	}
	argv = NULL;
	if (self->priv->_time != NULL) {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup_printf ("--restore-time=%s", self->priv->_time);
		argv = g_list_append (argv, _tmp9_);
	}
	_tmp10_ = g_file_new_for_path (self->priv->source);
	_tmp11_ = _tmp10_;
	deja_dup_duplicity_set_local (((DejaDupOperation*) self)->dup, _tmp11_);
	_g_object_unref0 (_tmp11_);
	result = argv;
	return result;
}


static void deja_dup_operation_restore_real_operation_finished_data_free (gpointer _data) {
	DejaDupOperationRestoreOperationFinishedData* data;
	data = _data;
	_g_object_unref0 (data->dup);
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupOperationRestoreOperationFinishedData, data);
}


static void deja_dup_operation_restore_real_operation_finished (DejaDupOperation* base, DejaDupDuplicity* dup, gboolean success, gboolean cancelled, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupOperationRestore * self;
	DejaDupOperationRestoreOperationFinishedData* _data_;
	self = (DejaDupOperationRestore*) base;
	_data_ = g_slice_new0 (DejaDupOperationRestoreOperationFinishedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_operation_restore_real_operation_finished);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_operation_restore_real_operation_finished_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->dup = _g_object_ref0 (dup);
	_data_->success = success;
	_data_->cancelled = cancelled;
	deja_dup_operation_restore_real_operation_finished_co (_data_);
}


static void deja_dup_operation_restore_real_operation_finished_finish (DejaDupOperation* base, GAsyncResult* _res_) {
	DejaDupOperationRestoreOperationFinishedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_operation_restore_real_operation_finished_co (DejaDupOperationRestoreOperationFinishedData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->success) {
		deja_dup_operation_restore_fixup_home_dir (data->self);
		data->_tmp0_ = deja_dup_operation_restore_mv_source_to_dest (data->self);
		if (!data->_tmp0_) {
			data->success = FALSE;
		} else {
			deja_dup_operation_restore_cleanup_source (data->self);
			deja_dup_update_last_run_timestamp (&data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				goto __catch40_g_error;
			}
			goto __finally40;
			__catch40_g_error:
			{
				data->e = data->_inner_error_;
				data->_inner_error_ = NULL;
				g_warning ("OperationRestore.vala:86: %s\n", data->e->message);
				_g_error_free0 (data->e);
			}
			__finally40:
			if (data->_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
				g_clear_error (&data->_inner_error_);
				return FALSE;
			}
		}
	} else {
		if (!data->cancelled) {
		} else {
			deja_dup_operation_restore_cleanup_source (data->self);
		}
	}
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_restore_parent_class)->operation_finished (DEJA_DUP_OPERATION (data->self), data->dup, data->success, data->cancelled, NULL, NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


/**
   * The idea here is to cover the following scenario:
   *   I backup my machine as user 'bob'
   *   I recover on another machine as user 'robert'
   * For the simple case (one home dir), we can note this and correct it.
   * We even cover the case of having backed up as root, and having a home dir
   * of /root.
   * 
   * This rejiggering is all done inside the source directory before we move it
   * to its destination.
   */
static void deja_dup_operation_restore_fixup_home_dir (DejaDupOperationRestore* self) {
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* ideal_home;
	gboolean _tmp6_;
	gchar* current_home;
	gchar* _tmp7_ = NULL;
	gchar* strd;
	GDir* d = NULL;
	GDir* _tmp8_ = NULL;
	GDir* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_has_rename_arg (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = g_get_home_dir ();
	_tmp5_ = g_build_filename (self->priv->source, _tmp4_, NULL);
	ideal_home = _tmp5_;
	_tmp6_ = g_file_test (ideal_home, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR);
	if (_tmp6_) {
		_g_free0 (ideal_home);
		return;
	}
	current_home = NULL;
	_tmp7_ = g_build_filename (self->priv->source, "home", NULL);
	strd = _tmp7_;
	_tmp8_ = g_dir_open (strd, (guint) 0, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch41_g_file_error;
		}
		_g_dir_close0 (d);
		_g_free0 (strd);
		_g_free0 (current_home);
		_g_free0 (ideal_home);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_dir_close0 (d);
	d = _tmp9_;
	goto __finally41;
	__catch41_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_dir_close0 (d);
		d = NULL;
		_g_error_free0 (e);
	}
	__finally41:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (d);
		_g_free0 (strd);
		_g_free0 (current_home);
		_g_free0 (ideal_home);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (d != NULL) {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* child;
		const gchar* _tmp12_ = NULL;
		const gchar* end;
		_tmp10_ = g_dir_read_name (d);
		_tmp11_ = g_strdup (_tmp10_);
		child = _tmp11_;
		_tmp12_ = g_dir_read_name (d);
		end = _tmp12_;
		if (end != NULL) {
			_g_free0 (child);
			_g_dir_close0 (d);
			_g_free0 (strd);
			_g_free0 (current_home);
			_g_free0 (ideal_home);
			return;
		}
		if (child != NULL) {
			gchar* _tmp13_ = NULL;
			gboolean _tmp14_;
			_tmp13_ = g_build_filename (strd, child, NULL);
			_g_free0 (current_home);
			current_home = _tmp13_;
			_tmp14_ = g_file_test (current_home, G_FILE_TEST_IS_DIR);
			if (!_tmp14_) {
				_g_free0 (current_home);
				current_home = NULL;
			}
		}
		_g_free0 (child);
	}
	if (current_home == NULL) {
		gchar* _tmp15_ = NULL;
		gboolean _tmp16_;
		_tmp15_ = g_build_filename (self->priv->source, "root", NULL);
		_g_free0 (current_home);
		current_home = _tmp15_;
		_tmp16_ = g_file_test (current_home, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR);
		if (!_tmp16_) {
			_g_free0 (current_home);
			current_home = NULL;
		}
	}
	if (current_home != NULL) {
		gchar* _tmp17_ = NULL;
		gchar* dirname;
		_tmp17_ = g_path_get_dirname (ideal_home);
		dirname = _tmp17_;
		g_mkdir_with_parents (dirname, 0755);
		g_rename (current_home, ideal_home);
		_g_free0 (dirname);
	}
	_g_dir_close0 (d);
	_g_free0 (strd);
	_g_free0 (current_home);
	_g_free0 (ideal_home);
}


static void deja_dup_operation_restore_show_errors (DejaDupOperationRestore* self) {
	guint _tmp0_;
	guint len;
	gchar* detail;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* error_text;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_length (self->priv->errors);
	len = _tmp0_;
	detail = NULL;
	if (len > 1) {
		gchar** _tmp1_ = NULL;
		gchar** error_array;
		gint error_array_length1;
		gint _error_array_size_;
		gint i;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp1_ = g_new0 (gchar*, (len + 1) + 1);
		error_array = _tmp1_;
		error_array_length1 = len + 1;
		_error_array_size_ = len + 1;
		i = 0;
		{
			GList* err_collection;
			GList* err_it;
			err_collection = self->priv->errors;
			for (err_it = err_collection; err_it != NULL; err_it = err_it->next) {
				gchar* _tmp2_;
				gchar* err;
				_tmp2_ = g_strdup ((const gchar*) err_it->data);
				err = _tmp2_;
				{
					gint _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
					_tmp4_ = g_strdup (err);
					_tmp5_ = _tmp4_;
					_g_free0 (error_array[_tmp3_]);
					error_array[_tmp3_] = _tmp5_;
					_g_free0 (err);
				}
			}
		}
		_tmp6_ = NULL;
		_g_free0 (error_array[i]);
		error_array[i] = _tmp6_;
		_tmp7_ = g_strjoinv ("\n\n", error_array);
		_g_free0 (detail);
		detail = _tmp7_;
		error_array = (_vala_array_free (error_array, error_array_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp8_ = _ ("Not all files could be restored. Any files that could not be restored " \
"may still be found in %s.");
	_tmp9_ = g_strdup_printf (_tmp8_, self->priv->source);
	error_text = _tmp9_;
	if (detail == NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = g_strconcat ("\n\n", (const gchar*) self->priv->errors->data, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (error_text, _tmp11_, NULL);
		_g_free0 (error_text);
		error_text = _tmp12_;
		_g_free0 (_tmp11_);
	}
	g_signal_emit_by_name ((DejaDupOperation*) self, "raise-error", error_text, detail);
	_g_free0 (error_text);
	_g_free0 (detail);
}


static void deja_dup_operation_restore_add_error (DejaDupOperationRestore* self, const gchar* relpath, const gchar* errstr) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (relpath != NULL);
	g_return_if_fail (errstr != NULL);
	_tmp0_ = _ ("Could not restore %s: %s");
	_tmp1_ = g_strdup_printf (_tmp0_, relpath, errstr);
	self->priv->errors = g_list_append (self->priv->errors, _tmp1_);
}


static void deja_dup_operation_restore_mv_error (DejaDupOperationRestore* self, DejaDupRecursiveOp* move, GFile* src, GFile* dst, const gchar* errstr) {
	GFile* _tmp0_ = NULL;
	GFile* dest_top;
	gchar* _tmp1_ = NULL;
	gchar* relative_dst;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (move != NULL);
	g_return_if_fail (src != NULL);
	g_return_if_fail (dst != NULL);
	g_return_if_fail (errstr != NULL);
	_tmp0_ = g_file_new_for_path (self->priv->_dest);
	dest_top = _tmp0_;
	_tmp1_ = g_file_get_relative_path (dest_top, dst);
	relative_dst = _tmp1_;
	if (relative_dst == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (relative_dst, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (self->priv->_dest);
		_g_free0 (relative_dst);
		relative_dst = _tmp3_;
	}
	deja_dup_operation_restore_add_error (self, relative_dst, errstr);
	_g_free0 (relative_dst);
	_g_object_unref0 (dest_top);
}


static void _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error (DejaDupRecursiveOp* _sender, GFile* src, GFile* dst, const gchar* errstr, gpointer self) {
	deja_dup_operation_restore_mv_error (self, _sender, src, dst, errstr);
}


static gboolean deja_dup_operation_restore_mv_source_to_dest (DejaDupOperationRestore* self) {
	gboolean result = FALSE;
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* destf;
	GFile* _tmp5_ = NULL;
	GFile* sourcef;
	GList* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_has_rename_arg (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	__g_list_free__g_free0_0 (self->priv->errors);
	self->priv->errors = NULL;
	_tmp4_ = g_file_new_for_path (self->priv->_dest);
	destf = _tmp4_;
	_tmp5_ = g_file_new_for_path (self->priv->source);
	sourcef = _tmp5_;
	_tmp6_ = deja_dup_operation_restore_get_restore_files (self);
	if (_tmp6_ == NULL) {
		DejaDupRecursiveMove* _tmp7_ = NULL;
		DejaDupRecursiveMove* move;
		_tmp7_ = deja_dup_recursive_move_new (sourcef, destf);
		move = _tmp7_;
		g_signal_connect_object ((DejaDupRecursiveOp*) move, "raise-error", (GCallback) _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error, self, 0);
		deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
		_g_object_unref0 (move);
	} else {
		GFile* _tmp8_ = NULL;
		GFile* root;
		GList* _tmp9_ = NULL;
		_tmp8_ = g_file_new_for_path ("/");
		root = _tmp8_;
		_tmp9_ = deja_dup_operation_restore_get_restore_files (self);
		{
			GList* f_collection;
			GList* f_it;
			f_collection = _tmp9_;
			for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
				GFile* _tmp10_;
				GFile* f;
				_tmp10_ = _g_object_ref0 ((GFile*) f_it->data);
				f = _tmp10_;
				{
					gchar* _tmp11_ = NULL;
					gchar* rel_file_path;
					GFile* _tmp12_ = NULL;
					GFile* full_source;
					GFile* _tmp13_ = NULL;
					GFile* full_dest;
					DejaDupRecursiveMove* _tmp14_ = NULL;
					DejaDupRecursiveMove* move;
					_tmp11_ = g_file_get_relative_path (root, f);
					rel_file_path = _tmp11_;
					_tmp12_ = g_file_resolve_relative_path (sourcef, rel_file_path);
					full_source = _tmp12_;
					_tmp13_ = g_file_resolve_relative_path (destf, rel_file_path);
					full_dest = _tmp13_;
					g_file_make_directory_with_parents (full_dest, NULL, &_inner_error_);
					if (_inner_error_ != NULL) {
						goto __catch42_g_error;
					}
					goto __finally42;
					__catch42_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_warning ("OperationRestore.vala:225: %s\n", e->message);
						_g_error_free0 (e);
					}
					__finally42:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (full_dest);
						_g_object_unref0 (full_source);
						_g_free0 (rel_file_path);
						_g_object_unref0 (f);
						_g_object_unref0 (root);
						_g_object_unref0 (sourcef);
						_g_object_unref0 (destf);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
					_tmp14_ = deja_dup_recursive_move_new (full_source, full_dest);
					move = _tmp14_;
					g_signal_connect_object ((DejaDupRecursiveOp*) move, "raise-error", (GCallback) _deja_dup_operation_restore_mv_error_deja_dup_recursive_op_raise_error, self, 0);
					deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
					_g_object_unref0 (move);
					_g_object_unref0 (full_dest);
					_g_object_unref0 (full_source);
					_g_free0 (rel_file_path);
					_g_object_unref0 (f);
				}
			}
		}
		_g_object_unref0 (root);
	}
	if (self->priv->errors != NULL) {
		deja_dup_operation_restore_show_errors (self);
		result = FALSE;
		_g_object_unref0 (sourcef);
		_g_object_unref0 (destf);
		return result;
	} else {
		result = TRUE;
		_g_object_unref0 (sourcef);
		_g_object_unref0 (destf);
		return result;
	}
	_g_object_unref0 (sourcef);
	_g_object_unref0 (destf);
}


static void deja_dup_operation_restore_cleanup_source (DejaDupOperationRestore* self) {
	DejaDupDuplicityInfo* _tmp0_ = NULL;
	DejaDupDuplicityInfo* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_ = NULL;
	GFile* sourcef;
	DejaDupRecursiveDelete* _tmp5_ = NULL;
	DejaDupRecursiveDelete* move;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_duplicity_info_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_duplicity_info_get_has_rename_arg (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		return;
	}
	_tmp4_ = g_file_new_for_path (self->priv->source);
	sourcef = _tmp4_;
	_tmp5_ = deja_dup_recursive_delete_new (sourcef);
	move = _tmp5_;
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) move);
	_g_object_unref0 (move);
	_g_object_unref0 (sourcef);
}


const gchar* deja_dup_operation_restore_get_dest (DejaDupOperationRestore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dest;
	return result;
}


static void deja_dup_operation_restore_set_dest (DejaDupOperationRestore* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dest);
	self->priv->_dest = _tmp0_;
	g_object_notify ((GObject *) self, "dest");
}


const gchar* deja_dup_operation_restore_get_time (DejaDupOperationRestore* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_time;
	return result;
}


static void deja_dup_operation_restore_set_time (DejaDupOperationRestore* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_time);
	self->priv->_time = _tmp0_;
	g_object_notify ((GObject *) self, "time");
}


GList* deja_dup_operation_restore_get_restore_files (DejaDupOperationRestore* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_restore_files;
	return result;
}


static void deja_dup_operation_restore_set_restore_files (DejaDupOperationRestore* self, GList* value) {
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp0_;
			GFile* f;
			_tmp0_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp0_;
			{
				g_object_unref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	_tmp1_ = g_list_copy (value);
	__g_list_free__g_object_unref0_0 (self->priv->_restore_files);
	self->priv->_restore_files = _tmp1_;
	{
		GList* f_collection;
		GList* f_it;
		f_collection = self->priv->_restore_files;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp2_;
			GFile* f;
			_tmp2_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp2_;
			{
				g_object_ref ((GObject*) f);
				_g_object_unref0 (f);
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static void deja_dup_operation_restore_class_init (DejaDupOperationRestoreClass * klass) {
	deja_dup_operation_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupOperationRestorePrivate));
	DEJA_DUP_OPERATION_CLASS (klass)->start = deja_dup_operation_restore_real_start;
	DEJA_DUP_OPERATION_CLASS (klass)->start_finish = deja_dup_operation_restore_real_start_finish;
	DEJA_DUP_OPERATION_CLASS (klass)->make_argv = deja_dup_operation_restore_real_make_argv;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished = deja_dup_operation_restore_real_operation_finished;
	DEJA_DUP_OPERATION_CLASS (klass)->operation_finished_finish = deja_dup_operation_restore_real_operation_finished_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_operation_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_operation_restore_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_DEST, g_param_spec_string ("dest", "dest", "dest", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_TIME, g_param_spec_string ("time", "time", "time", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void deja_dup_operation_restore_instance_init (DejaDupOperationRestore * self) {
	self->priv = DEJA_DUP_OPERATION_RESTORE_GET_PRIVATE (self);
}


static void deja_dup_operation_restore_finalize (GObject* obj) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (obj);
	_g_free0 (self->priv->_dest);
	_g_free0 (self->priv->_time);
	_g_free0 (self->priv->source);
	__g_list_free__g_free0_0 (self->priv->errors);
	__g_list_free__g_object_unref0_0 (self->priv->_restore_files);
	G_OBJECT_CLASS (deja_dup_operation_restore_parent_class)->finalize (obj);
}


GType deja_dup_operation_restore_get_type (void) {
	static volatile gsize deja_dup_operation_restore_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_operation_restore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationRestore), 0, (GInstanceInitFunc) deja_dup_operation_restore_instance_init, NULL };
		GType deja_dup_operation_restore_type_id;
		deja_dup_operation_restore_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationRestore", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_operation_restore_type_id__volatile, deja_dup_operation_restore_type_id);
	}
	return deja_dup_operation_restore_type_id__volatile;
}


static void _vala_deja_dup_operation_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_DEST:
		g_value_set_string (value, deja_dup_operation_restore_get_dest (self));
		break;
		case DEJA_DUP_OPERATION_RESTORE_TIME:
		g_value_set_string (value, deja_dup_operation_restore_get_time (self));
		break;
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, deja_dup_operation_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_operation_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupOperationRestore * self;
	self = DEJA_DUP_OPERATION_RESTORE (object);
	switch (property_id) {
		case DEJA_DUP_OPERATION_RESTORE_DEST:
		deja_dup_operation_restore_set_dest (self, g_value_get_string (value));
		break;
		case DEJA_DUP_OPERATION_RESTORE_TIME:
		deja_dup_operation_restore_set_time (self, g_value_get_string (value));
		break;
		case DEJA_DUP_OPERATION_RESTORE_RESTORE_FILES:
		deja_dup_operation_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



