/* BackendFile.c generated by valac 0.12.0, the Vala compiler
 * generated from BackendFile.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008–2010 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_OPERATION_TYPE_MODE (deja_dup_operation_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_FILE (deja_dup_backend_file_get_type ())
#define DEJA_DUP_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile))
#define DEJA_DUP_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))
#define DEJA_DUP_IS_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_IS_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_BACKEND_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))

typedef struct _DejaDupBackendFile DejaDupBackendFile;
typedef struct _DejaDupBackendFileClass DejaDupBackendFileClass;
typedef struct _DejaDupBackendFilePrivate DejaDupBackendFilePrivate;

#define DEJA_DUP_TYPE_SIMPLE_SETTINGS (deja_dup_simple_settings_get_type ())
#define DEJA_DUP_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettings))
#define DEJA_DUP_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))
#define DEJA_DUP_IS_SIMPLE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_IS_SIMPLE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_SIMPLE_SETTINGS))
#define DEJA_DUP_SIMPLE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_SIMPLE_SETTINGS, DejaDupSimpleSettingsClass))

typedef struct _DejaDupSimpleSettings DejaDupSimpleSettings;
typedef struct _DejaDupSimpleSettingsClass DejaDupSimpleSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define DEJA_DUP_TYPE_DUPLICITY_INFO (deja_dup_duplicity_info_get_type ())
#define DEJA_DUP_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfo))
#define DEJA_DUP_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))
#define DEJA_DUP_IS_DUPLICITY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_IS_DUPLICITY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INFO))
#define DEJA_DUP_DUPLICITY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INFO, DejaDupDuplicityInfoClass))

typedef struct _DejaDupDuplicityInfo DejaDupDuplicityInfo;
typedef struct _DejaDupDuplicityInfoClass DejaDupDuplicityInfoClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendFileCheckForVolumeInfoData DejaDupBackendFileCheckForVolumeInfoData;
typedef struct _DejaDupBackendFileSetVolumeInfoData DejaDupBackendFileSetVolumeInfoData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendFileGetEnvpData DejaDupBackendFileGetEnvpData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _DejaDupBackendFileDelayData DejaDupBackendFileDelayData;
typedef struct _DejaDupBackendFileMountFileData DejaDupBackendFileMountFileData;
typedef struct _DejaDupBackendFileMountRemoteData DejaDupBackendFileMountRemoteData;
typedef struct _DejaDupBackendFileMountVolumeData DejaDupBackendFileMountVolumeData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _DejaDupBackendFileWaitForVolumeData DejaDupBackendFileWaitForVolumeData;
typedef struct _DejaDupBackendFileGetSpaceData DejaDupBackendFileGetSpaceData;

typedef enum  {
	DEJA_DUP_OPERATION_MODE_INVALID,
	DEJA_DUP_OPERATION_MODE_BACKUP,
	DEJA_DUP_OPERATION_MODE_RESTORE,
	DEJA_DUP_OPERATION_MODE_STATUS,
	DEJA_DUP_OPERATION_MODE_LIST,
	DEJA_DUP_OPERATION_MODE_FILEHISTORY
} DejaDupOperationMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, GError** error);
	gchar* (*get_location_pretty) (DejaDupBackend* self, GError** error);
	gboolean (*is_ready) (DejaDupBackend* self, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupOperationMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendFile {
	DejaDupBackend parent_instance;
	DejaDupBackendFilePrivate * priv;
};

struct _DejaDupBackendFileClass {
	DejaDupBackendClass parent_class;
};

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
struct _DejaDupBackendFileCheckForVolumeInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* file;
	DejaDupSimpleSettings* _tmp0_;
	DejaDupSimpleSettings* settings;
	DejaDupSimpleSettings* _tmp1_;
	DejaDupSimpleSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GMount* mount;
	GMount* _tmp5_;
	GMount* _tmp6_;
	GError * e;
	GVolume* _tmp7_;
	GVolume* _tmp8_;
	GVolume* volume;
	gchar* relpath;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileSetVolumeInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GVolume* volume;
	gchar* relpath;
	DejaDupSimpleSettings* _tmp0_;
	DejaDupSimpleSettings* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* uuid;
	gboolean _tmp4_;
	DejaDupSimpleSettings* _tmp5_;
	DejaDupSimpleSettings* settings;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
};

struct _DejaDupBackendFileGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	GError * e;
	GList* _tmp0_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	DejaDupBackendFile * self;
	GMainLoop* loop;
	gpointer _async_data_;
};

struct _DejaDupBackendFileDelayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	guint secs;
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
};

struct _DejaDupBackendFileMountFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean success;
	DejaDupSimpleSettings* _tmp0_;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_;
	gchar* type;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_;
	GFile* file;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GError * err;
	gboolean _tmp8_;
	GError* _tmp9_;
	GFile* _tmp10_;
	GFile* gfile;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError * err2;
	GList* _tmp13_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileMountRemoteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	GFile* file;
	gboolean result;
	GMount* _tmp0_;
	GMount* mount;
	GError * e;
	GMountOperation* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileMountVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean result;
	DejaDupSimpleSettings* _tmp0_;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_;
	gchar* uuid;
	GVolume* _tmp2_;
	GVolume* vol;
	GMount* _tmp3_;
	GMount* _tmp4_;
	GMount* mount;
	GMountOperation* _tmp5_;
	gboolean _tmp6_;
	gboolean rv;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	DejaDupBackendFile * self;
	GMainLoop* loop;
};

struct _DejaDupBackendFileWaitForVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gchar* uuid;
	GVolume* result;
	GVolume* _tmp0_;
	GVolume* vol;
	Block2Data* _data2_;
	DejaDupSimpleSettings* _tmp1_;
	DejaDupSimpleSettings* settings;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GMainLoop* _tmp7_;
	GVolumeMonitor* _tmp8_;
	GVolumeMonitor* mon;
	GVolume* _tmp9_;
	GVolume* _tmp10_;
	GError * _inner_error_;
};

struct _DejaDupBackendFileGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendFile* self;
	gboolean free;
	guint64 result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* attr;
	GFile* _tmp2_;
	GFile* file;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* info;
	gboolean _tmp5_;
	guint64 _tmp6_;
	guint64 space;
	GError * e;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_file_parent_class = NULL;
extern guint64 deja_dup_backend_INFINITE_SPACE;

#define DEJA_DUP_FILE_ROOT "File"
#define DEJA_DUP_FILE_TYPE_KEY "type"
#define DEJA_DUP_FILE_PATH_KEY "path"
#define DEJA_DUP_FILE_RELPATH_KEY "relpath"
#define DEJA_DUP_FILE_UUID_KEY "uuid"
#define DEJA_DUP_FILE_NAME_KEY "name"
#define DEJA_DUP_FILE_SHORT_NAME_KEY "short-name"
#define DEJA_DUP_FILE_ICON_KEY "icon"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_operation_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_file_get_type (void) G_GNUC_CONST;
enum  {
	DEJA_DUP_BACKEND_FILE_DUMMY_PROPERTY
};
static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base);
DejaDupBackendFile* deja_dup_backend_file_new (void);
DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type);
static GFile* deja_dup_backend_file_get_file_from_settings (GError** error);
GType deja_dup_simple_settings_get_type (void) G_GNUC_CONST;
DejaDupSimpleSettings* deja_dup_get_settings (const gchar* subdir);
GVolume* deja_dup_backend_file_find_volume_by_uuid (const gchar* uuid);
static gchar* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error);
GType deja_dup_duplicity_info_get_type (void) G_GNUC_CONST;
DejaDupDuplicityInfo* deja_dup_duplicity_info_get_default (void);
gboolean deja_dup_duplicity_info_get_has_native_gio (DejaDupDuplicityInfo* self);
GQuark deja_dup_backup_error_quark (void);
static gchar* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error);
gchar* deja_dup_get_file_desc (GFile* file);
static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base);
static gboolean deja_dup_backend_file_real_is_ready (DejaDupBackend* base, gchar** when);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
gboolean deja_dup_network_get_connected (DejaDupNetwork* self);
static GIcon* deja_dup_backend_file_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv);
static void deja_dup_backend_file_check_for_volume_info_data_free (gpointer _data);
void deja_dup_backend_file_check_for_volume_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_file_check_for_volume_info_finish (GAsyncResult* _res_, GError** error);
static gboolean deja_dup_backend_file_check_for_volume_info_co (DejaDupBackendFileCheckForVolumeInfoData* data);
void deja_dup_simple_settings_set_string (DejaDupSimpleSettings* self, const gchar* k, const gchar* v);
#define DEJA_DUP_BACKEND_KEY "backend"
static void deja_dup_backend_file_check_for_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void deja_dup_backend_file_set_volume_info (GVolume* volume, const gchar* relpath, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_file_set_volume_info_finish (GAsyncResult* _res_);
static void deja_dup_backend_file_set_volume_info_data_free (gpointer _data);
static gboolean deja_dup_backend_file_set_volume_info_co (DejaDupBackendFileSetVolumeInfoData* data);
static void deja_dup_backend_file_update_volume_info (GVolume* volume);
static void deja_dup_backend_file_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_envp_co (DejaDupBackendFileGetEnvpData* data);
static void deja_dup_backend_file_mount_file (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_mount_file_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static gboolean deja_dup_backend_file_is_being_mounted_error (DejaDupBackendFile* self, GError* e);
static void deja_dup_backend_file_delay_data_free (gpointer _data);
static void deja_dup_backend_file_delay (DejaDupBackendFile* self, guint secs, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_file_delay_finish (DejaDupBackendFile* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_file_delay_co (DejaDupBackendFileDelayData* data);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean _lambda21_ (Block1Data* _data1_);
static gboolean __lambda21__gsource_func (gpointer self);
static void deja_dup_backend_file_mount_file_data_free (gpointer _data);
static gboolean deja_dup_backend_file_mount_file_co (DejaDupBackendFileMountFileData* data);
static void deja_dup_backend_file_mount_volume (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_file_mount_remote (DejaDupBackendFile* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_mount_remote_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_remote_data_free (gpointer _data);
static gboolean deja_dup_backend_file_mount_remote_co (DejaDupBackendFileMountRemoteData* data);
static void deja_dup_backend_file_mount_remote_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void deja_dup_backend_file_mount_volume_data_free (gpointer _data);
static gboolean deja_dup_backend_file_mount_volume_co (DejaDupBackendFileMountVolumeData* data);
static void deja_dup_backend_file_wait_for_volume (DejaDupBackendFile* self, const gchar* uuid, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GVolume* deja_dup_backend_file_wait_for_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error);
static void deja_dup_backend_file_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_backend_file_wait_for_volume_data_free (gpointer _data);
static gboolean deja_dup_backend_file_wait_for_volume_co (DejaDupBackendFileWaitForVolumeData* data);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda20_ (GVolumeMonitor* m, GVolume* v, Block2Data* _data2_);
static void __lambda20__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void deja_dup_backend_file_wait_for_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_file_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_space (DejaDupBackend* base, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* data);
static void deja_dup_backend_file_get_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean deja_dup_backend_file_real_space_can_be_infinite (DejaDupBackend* base);
DejaDupBackend* deja_dup_backend_construct (GType object_type);


static DejaDupBackend* deja_dup_backend_file_real_clone (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendFile* _tmp0_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_backend_file_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GFile* deja_dup_backend_file_get_file_from_settings (GError** error) {
	GFile* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* type;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp1_;
	if (g_strcmp0 (type, "volume") == 0) {
		GVariant* _tmp2_ = NULL;
		GVariant* path_val;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* path;
		gchar* _tmp5_ = NULL;
		gchar* uuid;
		GVolume* _tmp6_ = NULL;
		GVolume* vol;
		GMount* _tmp7_ = NULL;
		GMount* _tmp8_;
		GMount* mount;
		GFile* _tmp9_ = NULL;
		GFile* _tmp10_;
		GFile* root;
		_tmp2_ = g_settings_get_value ((GSettings*) settings, DEJA_DUP_FILE_RELPATH_KEY);
		path_val = _tmp2_;
		_tmp3_ = g_variant_get_bytestring (path_val);
		_tmp4_ = g_strdup (_tmp3_);
		path = _tmp4_;
		_tmp5_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_UUID_KEY);
		uuid = _tmp5_;
		_tmp6_ = deja_dup_backend_file_find_volume_by_uuid (uuid);
		vol = _tmp6_;
		if (vol == NULL) {
			result = NULL;
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_tmp7_ = g_volume_get_mount (vol);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		mount = _tmp8_;
		if (mount == NULL) {
			result = NULL;
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_tmp9_ = g_mount_get_root (mount);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		root = _tmp10_;
		if (path != NULL) {
			GFile* _tmp11_ = NULL;
			_tmp11_ = g_file_get_child (root, path);
			result = _tmp11_;
			_g_object_unref0 (root);
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		} else {
			result = root;
			_g_object_unref0 (mount);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_g_object_unref0 (root);
		_g_object_unref0 (mount);
		_g_object_unref0 (vol);
		_g_free0 (uuid);
		_g_free0 (path);
		_g_variant_unref0 (path_val);
	} else {
		gchar* _tmp12_ = NULL;
		gchar* path;
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_;
		_tmp12_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_PATH_KEY);
		path = _tmp12_;
		_tmp13_ = g_file_parse_name (path);
		_tmp14_ = _g_object_ref0 (_tmp13_);
		result = _tmp14_;
		_g_free0 (path);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (type);
	_g_object_unref0 (settings);
}


static gchar* deja_dup_backend_file_real_get_location (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* file;
	DejaDupDuplicityInfo* _tmp1_ = NULL;
	DejaDupDuplicityInfo* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_backend_file_get_file_from_settings (&_inner_error_);
	file = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = deja_dup_duplicity_info_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_duplicity_info_get_has_native_gio (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_file_get_uri (file);
		result = _tmp5_;
		_g_object_unref0 (file);
		return result;
	} else {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gboolean _tmp8_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp6_ = g_file_get_path (file);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ == NULL;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			const gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			_tmp9_ = _ ("GVFS FUSE is not installed");
			_tmp10_ = g_error_new_literal (DEJA_DUP_BACKUP_ERROR, DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, _tmp9_);
			_inner_error_ = _tmp10_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (file);
			return NULL;
		}
		_tmp11_ = g_file_get_path (file);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("file://", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		result = _tmp14_;
		_g_object_unref0 (file);
		return result;
	}
	_g_object_unref0 (file);
}


static gchar* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base, GError** error) {
	DejaDupBackendFile * self;
	gchar* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* type;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp1_;
	if (g_strcmp0 (type, "volume") == 0) {
		GVariant* _tmp2_ = NULL;
		GVariant* path_val;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* path;
		gchar* _tmp5_ = NULL;
		gchar* name;
		_tmp2_ = g_settings_get_value ((GSettings*) settings, DEJA_DUP_FILE_RELPATH_KEY);
		path_val = _tmp2_;
		_tmp3_ = g_variant_get_bytestring (path_val);
		_tmp4_ = g_filename_to_utf8 (_tmp3_, (gssize) (-1), NULL, NULL, &_inner_error_);
		path = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return NULL;
		}
		_tmp5_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_SHORT_NAME_KEY);
		name = _tmp5_;
		if (g_strcmp0 (path, "") == 0) {
			result = name;
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		} else {
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp6_ = _ ("%1$s on %2$s");
			_tmp7_ = g_strdup_printf (_tmp6_, path, name);
			result = _tmp7_;
			_g_free0 (name);
			_g_free0 (path);
			_g_variant_unref0 (path_val);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return result;
		}
		_g_free0 (name);
		_g_free0 (path);
		_g_variant_unref0 (path_val);
	} else {
		GFile* _tmp8_ = NULL;
		GFile* file;
		gchar* _tmp9_ = NULL;
		_tmp8_ = deja_dup_backend_file_get_file_from_settings (&_inner_error_);
		file = _tmp8_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (type);
			_g_object_unref0 (settings);
			return NULL;
		}
		_tmp9_ = deja_dup_get_file_desc (file);
		result = _tmp9_;
		_g_object_unref0 (file);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (type);
	_g_object_unref0 (settings);
}


static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* type;
	GFile* _tmp2_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp1_;
	if (g_strcmp0 (type, "volume") == 0) {
		result = TRUE;
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp2_ = deja_dup_backend_file_get_file_from_settings (&_inner_error_);
	file = _tmp2_;
	if (_inner_error_ != NULL) {
		_g_free0 (type);
		_g_object_unref0 (settings);
		goto __catch0_g_error;
	}
	if (file != NULL) {
		gboolean _tmp3_;
		_tmp3_ = g_file_is_native (file);
		result = _tmp3_;
		_g_object_unref0 (file);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	_g_object_unref0 (file);
	_g_free0 (type);
	_g_object_unref0 (settings);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("BackendFile.vala:112: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gboolean deja_dup_backend_file_real_is_ready (DejaDupBackend* base, gchar** when) {
	DejaDupBackendFile * self;
	gchar* _when = NULL;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* file;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_g_free0 (_when);
	_when = NULL;
	_tmp0_ = deja_dup_backend_file_get_file_from_settings (&_inner_error_);
	file = _tmp0_;
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	if (file == NULL) {
		DejaDupSimpleSettings* _tmp1_ = NULL;
		DejaDupSimpleSettings* settings;
		gchar* _tmp2_ = NULL;
		gchar* uuid;
		GVolume* _tmp3_ = NULL;
		GVolume* vol;
		_tmp1_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
		settings = _tmp1_;
		_tmp2_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_UUID_KEY);
		uuid = _tmp2_;
		_tmp3_ = deja_dup_backend_file_find_volume_by_uuid (uuid);
		vol = _tmp3_;
		if (vol != NULL) {
			result = TRUE;
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_object_unref0 (settings);
			_g_object_unref0 (file);
			if (when) {
				*when = _when;
			} else {
				_g_free0 (_when);
			}
			return result;
		} else {
			gchar* _tmp4_ = NULL;
			gchar* name;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp4_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_SHORT_NAME_KEY);
			name = _tmp4_;
			_tmp5_ = _ ("Backup will begin when %s becomes connected.");
			_tmp6_ = g_strdup_printf (_tmp5_, name);
			_g_free0 (_when);
			_when = _tmp6_;
			result = FALSE;
			_g_free0 (name);
			_g_object_unref0 (vol);
			_g_free0 (uuid);
			_g_object_unref0 (settings);
			_g_object_unref0 (file);
			if (when) {
				*when = _when;
			} else {
				_g_free0 (_when);
			}
			return result;
		}
		_g_object_unref0 (vol);
		_g_free0 (uuid);
		_g_object_unref0 (settings);
	} else {
		gboolean _tmp7_;
		_tmp7_ = g_file_is_native (file);
		if (_tmp7_) {
			result = TRUE;
			_g_object_unref0 (file);
			if (when) {
				*when = _when;
			} else {
				_g_free0 (_when);
			}
			return result;
		} else {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			DejaDupNetwork* _tmp10_ = NULL;
			DejaDupNetwork* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp8_ = _ ("Backup will begin when a network connection becomes available.");
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (_when);
			_when = _tmp9_;
			_tmp10_ = deja_dup_network_get ();
			_tmp11_ = _tmp10_;
			_tmp12_ = deja_dup_network_get_connected (_tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			result = _tmp13_;
			_g_object_unref0 (file);
			if (when) {
				*when = _when;
			} else {
				_g_free0 (_when);
			}
			return result;
		}
	}
	_g_object_unref0 (file);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("BackendFile.vala:142: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	if (when) {
		*when = _when;
	} else {
		_g_free0 (_when);
	}
	return result;
}


static GIcon* deja_dup_backend_file_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	GIcon* result = NULL;
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	gchar* _tmp1_ = NULL;
	gchar* type;
	gchar* icon_name = NULL;
	GIcon* _tmp8_ = NULL;
	GIcon* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_TYPE_KEY);
	type = _tmp1_;
	if (g_strcmp0 (type, "volume") == 0) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_settings_get_string ((GSettings*) settings, DEJA_DUP_FILE_ICON_KEY);
		_g_free0 (icon_name);
		icon_name = _tmp2_;
	} else {
		GFile* _tmp3_ = NULL;
		GFile* file;
		GFileInfo* _tmp4_ = NULL;
		GFileInfo* info;
		GIcon* _tmp5_ = NULL;
		GIcon* _tmp6_;
		_tmp3_ = deja_dup_backend_file_get_file_from_settings (&_inner_error_);
		file = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		_tmp4_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_ICON, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file);
			goto __catch2_g_error;
		}
		_tmp5_ = g_file_info_get_icon (info);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		result = _tmp6_;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (icon_name);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		goto __finally2;
		__catch2_g_error:
		{
			GError * e;
			gchar* _tmp7_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = g_strdup ("folder-remote");
			_g_free0 (icon_name);
			icon_name = _tmp7_;
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (icon_name);
			_g_free0 (type);
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = g_icon_new_for_string (icon_name, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	result = _tmp9_;
	_g_free0 (icon_name);
	_g_free0 (type);
	_g_object_unref0 (settings);
	return result;
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("BackendFile.vala:171: %s\n", e->message);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (icon_name);
		_g_free0 (type);
		_g_object_unref0 (settings);
		return result;
	}
	__finally3:
	_g_free0 (icon_name);
	_g_free0 (type);
	_g_object_unref0 (settings);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void deja_dup_backend_file_real_add_argv (DejaDupBackend* base, DejaDupOperationMode mode, GList** argv) {
	DejaDupBackendFile * self;
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DejaDupBackendFile*) base;
	if (mode == DEJA_DUP_OPERATION_MODE_BACKUP) {
		GFile* _tmp0_ = NULL;
		GFile* file;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = deja_dup_backend_file_get_file_from_settings (&_inner_error_);
		file = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		if (file != NULL) {
			gboolean _tmp2_;
			_tmp2_ = g_file_is_native (file);
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_ = NULL;
			_tmp3_ = g_file_get_path (file);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf ("--exclude=%s", _tmp4_);
			*argv = g_list_prepend (*argv, _tmp5_);
			_g_free0 (_tmp4_);
		}
		_g_object_unref0 (file);
		goto __finally4;
		__catch4_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("BackendFile.vala:186: %s\n", e->message);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (mode == DEJA_DUP_OPERATION_MODE_INVALID) {
		DejaDupDuplicityInfo* _tmp7_ = NULL;
		DejaDupDuplicityInfo* _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = deja_dup_duplicity_info_get_default ();
		_tmp8_ = _tmp7_;
		_tmp9_ = deja_dup_duplicity_info_get_has_native_gio (_tmp8_);
		_tmp6_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("--gio");
		*argv = g_list_prepend (*argv, _tmp10_);
	}
}


static void deja_dup_backend_file_check_for_volume_info_data_free (gpointer _data) {
	DejaDupBackendFileCheckForVolumeInfoData* data;
	data = _data;
	_g_object_unref0 (data->file);
	g_slice_free (DejaDupBackendFileCheckForVolumeInfoData, data);
}


void deja_dup_backend_file_check_for_volume_info (GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileCheckForVolumeInfoData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, deja_dup_backend_file_check_for_volume_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_check_for_volume_info_data_free);
	_data_->file = _g_object_ref0 (file);
	deja_dup_backend_file_check_for_volume_info_co (_data_);
}


void deja_dup_backend_file_check_for_volume_info_finish (GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileCheckForVolumeInfoData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_check_for_volume_info_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileCheckForVolumeInfoData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_check_for_volume_info_co (data);
}


static gboolean deja_dup_backend_file_check_for_volume_info_co (DejaDupBackendFileCheckForVolumeInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	data->settings = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = deja_dup_get_settings (NULL);
	data->_tmp2_ = data->_tmp1_;
	deja_dup_simple_settings_set_string (data->_tmp2_, DEJA_DUP_BACKEND_KEY, "file");
	_g_object_unref0 (data->_tmp2_);
	data->_tmp3_ = g_file_is_native (data->file);
	if (!data->_tmp3_) {
		deja_dup_simple_settings_set_string (data->settings, DEJA_DUP_FILE_TYPE_KEY, "normal");
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp4_ = g_file_query_exists (data->file, NULL);
	if (!data->_tmp4_) {
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->mount = NULL;
	data->_state_ = 1;
	g_file_find_enclosing_mount_async (data->file, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_check_for_volume_info_ready, data);
	return FALSE;
	_state_1:
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_file_find_enclosing_mount_finish (data->file, data->_res_, &data->_inner_error_);
	data->_tmp6_ = data->_tmp5_;
	if (data->_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_g_object_unref0 (data->mount);
	data->mount = data->_tmp6_;
	goto __finally5;
	__catch5_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->e);
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->mount == NULL) {
		deja_dup_simple_settings_set_string (data->settings, DEJA_DUP_FILE_TYPE_KEY, "normal");
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_mount_get_volume (data->mount);
	data->_tmp8_ = _g_object_ref0 (data->_tmp7_);
	data->volume = data->_tmp8_;
	if (data->volume == NULL) {
		_g_object_unref0 (data->volume);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->relpath = NULL;
	if (data->file != NULL) {
		data->_tmp9_ = NULL;
		data->_tmp9_ = g_mount_get_root (data->mount);
		data->_tmp10_ = NULL;
		data->_tmp10_ = g_file_get_relative_path (data->_tmp9_, data->file);
		_g_free0 (data->relpath);
		data->relpath = data->_tmp10_;
		if (data->relpath == NULL) {
			data->_tmp11_ = g_strdup ("");
			_g_free0 (data->relpath);
			data->relpath = data->_tmp11_;
		}
	}
	deja_dup_backend_file_set_volume_info (data->volume, data->relpath, NULL, NULL);
	_g_free0 (data->relpath);
	_g_object_unref0 (data->volume);
	_g_object_unref0 (data->mount);
	_g_object_unref0 (data->settings);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_set_volume_info_data_free (gpointer _data) {
	DejaDupBackendFileSetVolumeInfoData* data;
	data = _data;
	_g_object_unref0 (data->volume);
	_g_free0 (data->relpath);
	g_slice_free (DejaDupBackendFileSetVolumeInfoData, data);
}


void deja_dup_backend_file_set_volume_info (GVolume* volume, const gchar* relpath, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileSetVolumeInfoData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileSetVolumeInfoData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, deja_dup_backend_file_set_volume_info);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_set_volume_info_data_free);
	_data_->volume = _g_object_ref0 (volume);
	_data_->relpath = g_strdup (relpath);
	deja_dup_backend_file_set_volume_info_co (_data_);
}


void deja_dup_backend_file_set_volume_info_finish (GAsyncResult* _res_) {
	DejaDupBackendFileSetVolumeInfoData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean deja_dup_backend_file_set_volume_info_co (DejaDupBackendFileSetVolumeInfoData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_get_settings (NULL);
	data->_tmp1_ = data->_tmp0_;
	deja_dup_simple_settings_set_string (data->_tmp1_, DEJA_DUP_BACKEND_KEY, "file");
	_g_object_unref0 (data->_tmp1_);
	data->_tmp2_ = NULL;
	data->_tmp2_ = g_volume_get_identifier (data->volume, G_VOLUME_IDENTIFIER_KIND_UUID);
	data->_tmp3_ = g_strdup (data->_tmp2_);
	data->uuid = data->_tmp3_;
	if (data->uuid == NULL) {
		data->_tmp4_ = TRUE;
	} else {
		data->_tmp4_ = g_strcmp0 (data->uuid, "") == 0;
	}
	if (data->_tmp4_) {
		_g_free0 (data->uuid);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	data->settings = data->_tmp5_;
	g_settings_delay ((GSettings*) data->settings);
	deja_dup_simple_settings_set_string (data->settings, DEJA_DUP_FILE_TYPE_KEY, "volume");
	deja_dup_simple_settings_set_string (data->settings, DEJA_DUP_FILE_UUID_KEY, data->uuid);
	if (data->relpath != NULL) {
		data->_tmp6_ = NULL;
		data->_tmp6_ = g_variant_new_bytestring (data->relpath);
		data->_tmp7_ = g_variant_ref_sink (data->_tmp6_);
		g_settings_set_value ((GSettings*) data->settings, DEJA_DUP_FILE_RELPATH_KEY, data->_tmp7_);
		_g_variant_unref0 (data->_tmp7_);
	}
	g_settings_apply ((GSettings*) data->settings);
	deja_dup_backend_file_update_volume_info (data->volume);
	_g_object_unref0 (data->settings);
	_g_free0 (data->uuid);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_update_volume_info (GVolume* volume) {
	DejaDupSimpleSettings* _tmp0_ = NULL;
	DejaDupSimpleSettings* settings;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* short_name;
	GDrive* _tmp5_ = NULL;
	GDrive* _tmp6_;
	GDrive* drive;
	GIcon* _tmp11_ = NULL;
	GIcon* _tmp12_;
	GIcon* icon;
	gchar* icon_str;
	g_return_if_fail (volume != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	settings = _tmp0_;
	_tmp1_ = g_volume_get_name (volume);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	if (name == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = g_strcmp0 (name, "") == 0;
	}
	if (_tmp3_) {
		_g_free0 (name);
		_g_object_unref0 (settings);
		return;
	}
	_tmp4_ = g_strdup (name);
	short_name = _tmp4_;
	_tmp5_ = g_volume_get_drive (volume);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	drive = _tmp6_;
	if (drive != NULL) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* drive_name;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = g_drive_get_name (drive);
		_tmp8_ = g_strdup (_tmp7_);
		drive_name = _tmp8_;
		if (drive_name != NULL) {
			_tmp9_ = g_strcmp0 (drive_name, "") != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gchar* _tmp10_ = NULL;
			_tmp10_ = g_strdup_printf ("%s: %s", drive_name, name);
			_g_free0 (name);
			name = _tmp10_;
		}
		_g_free0 (drive_name);
	}
	_tmp11_ = g_volume_get_icon (volume);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	icon = _tmp12_;
	icon_str = NULL;
	if (icon != NULL) {
		gchar* _tmp13_ = NULL;
		_tmp13_ = g_icon_to_string (icon);
		_g_free0 (icon_str);
		icon_str = _tmp13_;
	}
	g_settings_delay ((GSettings*) settings);
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_FILE_NAME_KEY, name);
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_FILE_SHORT_NAME_KEY, short_name);
	deja_dup_simple_settings_set_string (settings, DEJA_DUP_FILE_ICON_KEY, icon_str);
	g_settings_apply ((GSettings*) settings);
	_g_free0 (icon_str);
	_g_object_unref0 (icon);
	_g_object_unref0 (drive);
	_g_free0 (short_name);
	_g_free0 (name);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_file_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendFileGetEnvpData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileGetEnvpData, data);
}


static void deja_dup_backend_file_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileGetEnvpData* _data_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_get_envp_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_backend_file_real_get_envp_co (_data_);
}


static void deja_dup_backend_file_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileGetEnvpData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_real_get_envp_co (data);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gboolean deja_dup_backend_file_real_get_envp_co (DejaDupBackendFileGetEnvpData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_object_ref ((GObject*) data->self);
	data->_state_ = 1;
	deja_dup_backend_file_mount_file (data->self, deja_dup_backend_file_get_envp_ready, data);
	return FALSE;
	_state_1:
	deja_dup_backend_file_mount_file_finish (data->self, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	goto __finally6;
	__catch6_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp0_ = NULL;
		g_signal_emit_by_name ((DejaDupBackend*) data->self, "envp-ready", FALSE, data->_tmp0_, data->e->message);
		__g_list_free__g_free0_0 (data->_tmp0_);
		_g_error_free0 (data->e);
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	g_object_unref ((GObject*) data->self);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean deja_dup_backend_file_is_being_mounted_error (DejaDupBackendFile* self, GError* e) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_str_has_prefix (e->message, "DBus error org.gtk.Private.RemoteVolumeMonitor.Failed:");
	result = _tmp0_;
	return result;
}


static void deja_dup_backend_file_delay_data_free (gpointer _data) {
	DejaDupBackendFileDelayData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileDelayData, data);
}


static void deja_dup_backend_file_delay (DejaDupBackendFile* self, guint secs, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileDelayData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileDelayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_delay);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_delay_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->secs = secs;
	deja_dup_backend_file_delay_co (_data_);
}


static void deja_dup_backend_file_delay_finish (DejaDupBackendFile* self, GAsyncResult* _res_) {
	DejaDupBackendFileDelayData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _lambda21_ (Block1Data* _data1_) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	self = _data1_->self;
	g_main_loop_quit (_data1_->loop);
	result = FALSE;
	return result;
}


static gboolean __lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda21_ (self);
	return result;
}


static gboolean deja_dup_backend_file_delay_co (DejaDupBackendFileDelayData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_data1_ = g_slice_new0 (Block1Data);
	data->_data1_->_ref_count_ = 1;
	data->_data1_->self = g_object_ref (data->self);
	data->_data1_->_async_data_ = data;
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_main_loop_new (NULL, FALSE);
	data->_data1_->loop = data->_tmp0_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, data->secs, __lambda21__gsource_func, block1_data_ref (data->_data1_), block1_data_unref);
	g_main_loop_run (data->_data1_->loop);
	block1_data_unref (data->_data1_);
	data->_data1_ = NULL;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_mount_file_data_free (gpointer _data) {
	DejaDupBackendFileMountFileData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileMountFileData, data);
}


static void deja_dup_backend_file_mount_file (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountFileData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_file_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_backend_file_mount_file_co (_data_);
}


static void deja_dup_backend_file_mount_file_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	DejaDupBackendFileMountFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_file_mount_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountFileData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_mount_file_co (data);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean deja_dup_backend_file_mount_file_co (DejaDupBackendFileMountFileData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->success = TRUE;
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	data->settings = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_settings_get_string ((GSettings*) data->settings, DEJA_DUP_FILE_TYPE_KEY);
	data->type = data->_tmp1_;
	if (g_strcmp0 (data->type, "volume") == 0) {
		data->_state_ = 1;
		deja_dup_backend_file_mount_volume (data->self, deja_dup_backend_file_mount_file_ready, data);
		return FALSE;
		_state_1:
		data->_tmp2_ = deja_dup_backend_file_mount_volume_finish (data->self, data->_res_, &data->_inner_error_);
		data->_tmp3_ = data->_tmp2_;
		if (data->_inner_error_ != NULL) {
			if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_FAILED)) {
				goto __catch7_g_io_error_failed;
			}
			goto __finally7;
		}
		data->success = data->_tmp3_;
	} else {
		if (g_strcmp0 (data->type, "normal") == 0) {
			data->_tmp4_ = NULL;
			data->_tmp4_ = deja_dup_backend_file_get_file_from_settings (&data->_inner_error_);
			data->file = data->_tmp4_;
			if (data->_inner_error_ != NULL) {
				if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_FAILED)) {
					goto __catch7_g_io_error_failed;
				}
				goto __finally7;
			}
			data->_tmp5_ = g_file_is_native (data->file);
			if (!data->_tmp5_) {
				data->_state_ = 2;
				deja_dup_backend_file_mount_remote (data->self, data->file, deja_dup_backend_file_mount_file_ready, data);
				return FALSE;
				_state_2:
				data->_tmp6_ = deja_dup_backend_file_mount_remote_finish (data->self, data->_res_, &data->_inner_error_);
				data->_tmp7_ = data->_tmp6_;
				if (data->_inner_error_ != NULL) {
					_g_object_unref0 (data->file);
					if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_FAILED)) {
						goto __catch7_g_io_error_failed;
					}
					goto __finally7;
				}
				data->success = data->_tmp7_;
			}
			_g_object_unref0 (data->file);
		}
	}
	goto __finally7;
	__catch7_g_io_error_failed:
	{
		data->err = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp8_ = deja_dup_backend_file_is_being_mounted_error (data->self, data->err);
		if (data->_tmp8_) {
			data->_state_ = 3;
			deja_dup_backend_file_delay (data->self, (guint) 1, deja_dup_backend_file_mount_file_ready, data);
			return FALSE;
			_state_3:
			deja_dup_backend_file_delay_finish (data->self, data->_res_);
			data->_state_ = 4;
			deja_dup_backend_file_mount_file (data->self, deja_dup_backend_file_mount_file_ready, data);
			return FALSE;
			_state_4:
			deja_dup_backend_file_mount_file_finish (data->self, data->_res_, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				_g_error_free0 (data->err);
				goto __finally7;
			}
			_g_error_free0 (data->err);
			_g_free0 (data->type);
			_g_object_unref0 (data->settings);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			data->_tmp9_ = _g_error_copy0 (data->err);
			data->_inner_error_ = data->_tmp9_;
			_g_error_free0 (data->err);
			goto __finally7;
		}
		_g_error_free0 (data->err);
	}
	__finally7:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->type);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp10_ = NULL;
	data->_tmp10_ = deja_dup_backend_file_get_file_from_settings (&data->_inner_error_);
	data->gfile = data->_tmp10_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->type);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (g_strcmp0 (data->type, "volume") != 0) {
		data->_tmp12_ = g_strcmp0 (data->type, "normal") != 0;
	} else {
		data->_tmp12_ = FALSE;
	}
	if (data->_tmp12_) {
		data->_tmp11_ = data->success;
	} else {
		data->_tmp11_ = FALSE;
	}
	if (data->_tmp11_) {
		data->_state_ = 5;
		deja_dup_backend_file_check_for_volume_info (data->gfile, deja_dup_backend_file_mount_file_ready, data);
		return FALSE;
		_state_5:
		deja_dup_backend_file_check_for_volume_info_finish (data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->gfile);
			_g_free0 (data->type);
			_g_object_unref0 (data->settings);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	g_file_make_directory_with_parents (data->gfile, NULL, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		if (g_error_matches (data->_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			goto __catch8_g_io_error_exists;
		}
		goto __finally8;
	}
	goto __finally8;
	__catch8_g_io_error_exists:
	{
		data->err2 = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->err2);
	}
	__finally8:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->gfile);
		_g_free0 (data->type);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp13_ = NULL;
	g_signal_emit_by_name ((DejaDupBackend*) data->self, "envp-ready", data->success, data->_tmp13_, NULL);
	__g_list_free__g_free0_0 (data->_tmp13_);
	_g_object_unref0 (data->gfile);
	_g_free0 (data->type);
	_g_object_unref0 (data->settings);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_mount_remote_data_free (gpointer _data) {
	DejaDupBackendFileMountRemoteData* data;
	data = _data;
	_g_object_unref0 (data->file);
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileMountRemoteData, data);
}


static void deja_dup_backend_file_mount_remote (DejaDupBackendFile* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountRemoteData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountRemoteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_remote);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_remote_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->file = _g_object_ref0 (file);
	deja_dup_backend_file_mount_remote_co (_data_);
}


static gboolean deja_dup_backend_file_mount_remote_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DejaDupBackendFileMountRemoteData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_mount_remote_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountRemoteData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_mount_remote_co (data);
}


static gboolean deja_dup_backend_file_mount_remote_co (DejaDupBackendFileMountRemoteData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_state_ = 1;
	g_file_find_enclosing_mount_async (data->file, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_mount_remote_ready, data);
	return FALSE;
	_state_1:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_file_find_enclosing_mount_finish (data->file, data->_res_, &data->_inner_error_);
	data->mount = data->_tmp0_;
	if (data->_inner_error_ != NULL) {
		goto __catch9_g_error;
	}
	if (data->mount != NULL) {
		data->result = TRUE;
		_g_object_unref0 (data->mount);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->mount);
	goto __finally9;
	__catch9_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		_g_error_free0 (data->e);
	}
	__finally9:
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp1_ = NULL;
	data->_tmp1_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) data->self);
	data->_state_ = 2;
	g_file_mount_enclosing_volume (data->file, G_MOUNT_MOUNT_NONE, data->_tmp1_, NULL, deja_dup_backend_file_mount_remote_ready, data);
	return FALSE;
	_state_2:
	data->_tmp2_ = g_file_mount_enclosing_volume_finish (data->file, data->_res_, &data->_inner_error_);
	data->_tmp3_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->_tmp3_;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_mount_volume_data_free (gpointer _data) {
	DejaDupBackendFileMountVolumeData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileMountVolumeData, data);
}


static void deja_dup_backend_file_mount_volume (DejaDupBackendFile* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileMountVolumeData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_mount_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_mount_volume_data_free);
	_data_->self = _g_object_ref0 (self);
	deja_dup_backend_file_mount_volume_co (_data_);
}


static gboolean deja_dup_backend_file_mount_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	gboolean result;
	DejaDupBackendFileMountVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return FALSE;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileMountVolumeData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_mount_volume_co (data);
}


static gboolean deja_dup_backend_file_mount_volume_co (DejaDupBackendFileMountVolumeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
	data->settings = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_settings_get_string ((GSettings*) data->settings, DEJA_DUP_FILE_UUID_KEY);
	data->uuid = data->_tmp1_;
	data->_state_ = 1;
	deja_dup_backend_file_wait_for_volume (data->self, data->uuid, deja_dup_backend_file_mount_volume_ready, data);
	return FALSE;
	_state_1:
	data->_tmp2_ = NULL;
	data->_tmp2_ = deja_dup_backend_file_wait_for_volume_finish (data->self, data->_res_, &data->_inner_error_);
	data->vol = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_volume_get_mount (data->vol);
	data->_tmp4_ = _g_object_ref0 (data->_tmp3_);
	data->mount = data->_tmp4_;
	if (data->mount != NULL) {
		deja_dup_backend_file_update_volume_info (data->vol);
		data->result = TRUE;
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->vol);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp5_ = NULL;
	data->_tmp5_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) data->self);
	data->_state_ = 2;
	g_volume_mount (data->vol, G_MOUNT_MOUNT_NONE, data->_tmp5_, NULL, deja_dup_backend_file_mount_volume_ready, data);
	return FALSE;
	_state_2:
	data->_tmp6_ = g_volume_mount_finish (data->vol, data->_res_, &data->_inner_error_);
	data->rv = data->_tmp6_;
	if (data->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		_g_object_unref0 (data->mount);
		_g_object_unref0 (data->vol);
		_g_free0 (data->uuid);
		_g_object_unref0 (data->settings);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	if (data->rv) {
		deja_dup_backend_file_update_volume_info (data->vol);
	}
	data->result = data->rv;
	_g_object_unref0 (data->mount);
	_g_object_unref0 (data->vol);
	_g_free0 (data->uuid);
	_g_object_unref0 (data->settings);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->mount);
	_g_object_unref0 (data->vol);
	_g_free0 (data->uuid);
	_g_object_unref0 (data->settings);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GVolume* deja_dup_backend_file_find_volume_by_uuid (const gchar* uuid) {
	GVolume* result = NULL;
	GVolumeMonitor* _tmp0_ = NULL;
	GVolumeMonitor* mon;
	GList* _tmp1_ = NULL;
	GList* vols;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = g_volume_monitor_get ();
	mon = _tmp0_;
	g_object_ref ((GObject*) mon);
	_tmp1_ = g_volume_monitor_get_volumes (mon);
	vols = _tmp1_;
	{
		GList* v_collection;
		GList* v_it;
		v_collection = vols;
		for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
			GVolume* _tmp2_;
			GVolume* v;
			_tmp2_ = _g_object_ref0 ((GVolume*) v_it->data);
			v = _tmp2_;
			{
				const gchar* _tmp3_ = NULL;
				_tmp3_ = g_volume_get_identifier (v, G_VOLUME_IDENTIFIER_KIND_UUID);
				if (g_strcmp0 (_tmp3_, uuid) == 0) {
					result = v;
					__g_list_free__g_object_unref0_0 (vols);
					_g_object_unref0 (mon);
					return result;
				}
				_g_object_unref0 (v);
			}
		}
	}
	result = NULL;
	__g_list_free__g_object_unref0_0 (vols);
	_g_object_unref0 (mon);
	return result;
}


static void deja_dup_backend_file_wait_for_volume_data_free (gpointer _data) {
	DejaDupBackendFileWaitForVolumeData* data;
	data = _data;
	_g_free0 (data->uuid);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileWaitForVolumeData, data);
}


static void deja_dup_backend_file_wait_for_volume (DejaDupBackendFile* self, const gchar* uuid, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFileWaitForVolumeData* _data_;
	_data_ = g_slice_new0 (DejaDupBackendFileWaitForVolumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_wait_for_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_wait_for_volume_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uuid = g_strdup (uuid);
	deja_dup_backend_file_wait_for_volume_co (_data_);
}


static GVolume* deja_dup_backend_file_wait_for_volume_finish (DejaDupBackendFile* self, GAsyncResult* _res_, GError** error) {
	GVolume* result;
	DejaDupBackendFileWaitForVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_main_loop_unref0 (_data2_->loop);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda20_ (GVolumeMonitor* m, GVolume* v, Block2Data* _data2_) {
	DejaDupBackendFile * self;
	self = _data2_->self;
	g_return_if_fail (m != NULL);
	g_return_if_fail (v != NULL);
	g_main_loop_quit (_data2_->loop);
}


static void __lambda20__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	_lambda20_ (_sender, volume, self);
}


static void deja_dup_backend_file_wait_for_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileWaitForVolumeData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_wait_for_volume_co (data);
}


static gboolean deja_dup_backend_file_wait_for_volume_co (DejaDupBackendFileWaitForVolumeData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = deja_dup_backend_file_find_volume_by_uuid (data->uuid);
	data->vol = data->_tmp0_;
	if (data->vol == NULL) {
		data->_data2_ = g_slice_new0 (Block2Data);
		data->_data2_->_ref_count_ = 1;
		data->_data2_->self = g_object_ref (data->self);
		data->_tmp1_ = NULL;
		data->_tmp1_ = deja_dup_get_settings (DEJA_DUP_FILE_ROOT);
		data->settings = data->_tmp1_;
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_settings_get_string ((GSettings*) data->settings, DEJA_DUP_FILE_NAME_KEY);
		data->name = data->_tmp2_;
		data->_tmp3_ = NULL;
		data->_tmp3_ = _ ("Backup location not available");
		data->_tmp4_ = NULL;
		data->_tmp4_ = _ ("Waiting for ‘%s’ to become connected…");
		data->_tmp5_ = NULL;
		data->_tmp5_ = g_strdup_printf (data->_tmp4_, data->name);
		data->_tmp6_ = data->_tmp5_;
		g_signal_emit_by_name ((DejaDupBackend*) data->self, "pause-op", data->_tmp3_, data->_tmp6_);
		_g_free0 (data->_tmp6_);
		data->_tmp7_ = NULL;
		data->_tmp7_ = g_main_loop_new (NULL, FALSE);
		data->_data2_->loop = data->_tmp7_;
		data->_tmp8_ = NULL;
		data->_tmp8_ = g_volume_monitor_get ();
		data->mon = data->_tmp8_;
		g_object_ref ((GObject*) data->mon);
		g_signal_connect_data (data->mon, "volume-added", (GCallback) __lambda20__g_volume_monitor_volume_added, block2_data_ref (data->_data2_), (GClosureNotify) block2_data_unref, 0);
		g_main_loop_run (data->_data2_->loop);
		data->_state_ = 1;
		deja_dup_backend_file_wait_for_volume (data->self, data->uuid, deja_dup_backend_file_wait_for_volume_ready, data);
		return FALSE;
		_state_1:
		data->_tmp9_ = NULL;
		data->_tmp9_ = deja_dup_backend_file_wait_for_volume_finish (data->self, data->_res_, &data->_inner_error_);
		data->_tmp10_ = data->_tmp9_;
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			_g_object_unref0 (data->mon);
			_g_free0 (data->name);
			_g_object_unref0 (data->settings);
			block2_data_unref (data->_data2_);
			data->_data2_ = NULL;
			_g_object_unref0 (data->vol);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		data->result = data->_tmp10_;
		_g_object_unref0 (data->mon);
		_g_free0 (data->name);
		_g_object_unref0 (data->settings);
		block2_data_unref (data->_data2_);
		data->_data2_ = NULL;
		_g_object_unref0 (data->vol);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->result = data->vol;
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_object_unref0 (data->vol);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void deja_dup_backend_file_real_get_space_data_free (gpointer _data) {
	DejaDupBackendFileGetSpaceData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (DejaDupBackendFileGetSpaceData, data);
}


static void deja_dup_backend_file_real_get_space (DejaDupBackend* base, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendFile * self;
	DejaDupBackendFileGetSpaceData* _data_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetSpaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_file_real_get_space);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_file_real_get_space_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->free = free;
	deja_dup_backend_file_real_get_space_co (_data_);
}


static guint64 deja_dup_backend_file_real_get_space_finish (DejaDupBackend* base, GAsyncResult* _res_) {
	guint64 result;
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void deja_dup_backend_file_get_space_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendFileGetSpaceData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	deja_dup_backend_file_real_get_space_co (data);
}


static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (data->free) {
		data->_tmp0_ = G_FILE_ATTRIBUTE_FILESYSTEM_FREE;
	} else {
		data->_tmp0_ = G_FILE_ATTRIBUTE_FILESYSTEM_SIZE;
	}
	data->_tmp1_ = g_strdup (data->_tmp0_);
	data->attr = data->_tmp1_;
	data->_tmp2_ = NULL;
	data->_tmp2_ = deja_dup_backend_file_get_file_from_settings (&data->_inner_error_);
	data->file = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	data->_state_ = 1;
	g_file_query_filesystem_info_async (data->file, data->attr, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_get_space_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = g_file_query_filesystem_info_finish (data->file, data->_res_, &data->_inner_error_);
	data->_tmp4_ = _g_object_ref0 (data->_tmp3_);
	data->info = data->_tmp4_;
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->file);
		goto __catch10_g_error;
	}
	data->_tmp5_ = g_file_info_has_attribute (data->info, data->attr);
	if (!data->_tmp5_) {
		data->result = deja_dup_backend_INFINITE_SPACE;
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
		_g_free0 (data->attr);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp6_ = g_file_info_get_attribute_uint64 (data->info, data->attr);
	data->space = data->_tmp6_;
	if (data->space == deja_dup_backend_INFINITE_SPACE) {
		data->result = data->space - 1;
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
		_g_free0 (data->attr);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		data->result = data->space;
		_g_object_unref0 (data->info);
		_g_object_unref0 (data->file);
		_g_free0 (data->attr);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	_g_object_unref0 (data->info);
	_g_object_unref0 (data->file);
	goto __finally10;
	__catch10_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("BackendFile.vala:440: %s\n", data->e->message);
		data->result = deja_dup_backend_INFINITE_SPACE;
		_g_error_free0 (data->e);
		_g_free0 (data->attr);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	__finally10:
	_g_free0 (data->attr);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
	g_clear_error (&data->_inner_error_);
	return FALSE;
	_g_free0 (data->attr);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gboolean deja_dup_backend_file_real_space_can_be_infinite (DejaDupBackend* base) {
	DejaDupBackendFile * self;
	gboolean result = FALSE;
	self = (DejaDupBackendFile*) base;
	result = FALSE;
	return result;
}


DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type) {
	DejaDupBackendFile * self = NULL;
	self = (DejaDupBackendFile*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendFile* deja_dup_backend_file_new (void) {
	return deja_dup_backend_file_construct (DEJA_DUP_TYPE_BACKEND_FILE);
}


static void deja_dup_backend_file_class_init (DejaDupBackendFileClass * klass) {
	deja_dup_backend_file_parent_class = g_type_class_peek_parent (klass);
	DEJA_DUP_BACKEND_CLASS (klass)->clone = deja_dup_backend_file_real_clone;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location = deja_dup_backend_file_real_get_location;
	DEJA_DUP_BACKEND_CLASS (klass)->get_location_pretty = deja_dup_backend_file_real_get_location_pretty;
	DEJA_DUP_BACKEND_CLASS (klass)->is_native = deja_dup_backend_file_real_is_native;
	DEJA_DUP_BACKEND_CLASS (klass)->is_ready = deja_dup_backend_file_real_is_ready;
	DEJA_DUP_BACKEND_CLASS (klass)->get_icon = deja_dup_backend_file_real_get_icon;
	DEJA_DUP_BACKEND_CLASS (klass)->add_argv = deja_dup_backend_file_real_add_argv;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp = deja_dup_backend_file_real_get_envp;
	DEJA_DUP_BACKEND_CLASS (klass)->get_envp_finish = deja_dup_backend_file_real_get_envp_finish;
	DEJA_DUP_BACKEND_CLASS (klass)->get_space = deja_dup_backend_file_real_get_space;
	DEJA_DUP_BACKEND_CLASS (klass)->get_space_finish = deja_dup_backend_file_real_get_space_finish;
	DEJA_DUP_BACKEND_CLASS (klass)->space_can_be_infinite = deja_dup_backend_file_real_space_can_be_infinite;
}


static void deja_dup_backend_file_instance_init (DejaDupBackendFile * self) {
}


GType deja_dup_backend_file_get_type (void) {
	static volatile gsize deja_dup_backend_file_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendFile), 0, (GInstanceInitFunc) deja_dup_backend_file_instance_init, NULL };
		GType deja_dup_backend_file_type_id;
		deja_dup_backend_file_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendFile", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_file_type_id__volatile, deja_dup_backend_file_type_id);
	}
	return deja_dup_backend_file_type_id__volatile;
}



