/*+
 * A minigui for VoIP/CTI telephony
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

extern "C"
{
#include <signal.h>
}


#include <QtCore/QCoreApplication>
#include <QtCore/QDebug>

#include <QtDBus/QDBusConnection>

#include <Decibel/Types>
#include <Decibel/DBusNames>
#include "log.h"
#include "decibelchannelhandler.h"

namespace
{
    static void signal_handler(int signal)
    {
        if (signal == SIGTERM || signal == SIGINT)
        {
            QCoreApplication * const qapp(QCoreApplication::instance());
            if (0 != qapp) { qapp->quit(); }
            return;
        }
    }
}


int main(int argc, char ** argv)
{
    // Make Decibel types known: Otherwise we get DBus errors about unexpected
    // reply types.
    Decibel::registerTypes();

    QCoreApplication app(argc, argv);

    // install signal handler:
    if (signal(SIGTERM, signal_handler) == SIG_ERR)
    { qWarning() << QObject::tr("Failed to setup handler for SIGTERM!"); }
    if (signal(SIGINT, signal_handler) == SIG_ERR)
    { qWarning() << QObject::tr("Failed to setup handler for SIGINT!"); }

    Log log;
    DecibelChannelHandler channel_handler(&log);

    // register Channel Handler on D-BUS:
    QDBusConnection::sessionBus().registerService(Decibel::log_service);
    QDBusConnection::sessionBus().registerObject("/ChannelHandler",
                                                 &channel_handler);
    QDBusConnection::sessionBus().registerObject(Decibel::log_path,
                                                 &log);

    return app.exec();
}

