<?php
/*
 * $Id: class.dbWorkOrderType.inc.php,v 1.1.2.1 2003/04/19 23:43:23 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');

class dbWorkOrderType extends dclDB
{
	var $wo_type_id;
	var $type_name;
	var $active;

	function dbWorkOrderType()
	{
		// Table Fields
		$this->fieldArray = array('wo_type_id', 'type_name', 'active');

		// Foriegn keys
		$this->foreignKeys = array('workorders' => 'wo_type_id');

		$this->cache = array();
		$this->cacheEnabled = true;

		$this->dclDB();
	}

	function Add()
	{
		$idSQL = $this->GetNewIDSQLForTable('dcl_wo_type');
		$query = 'INSERT INTO dcl_wo_type (';
		if ($idSQL != '')
			$query .= 'wo_type_id,';
		$query .= 'type_name, active)';
		$query .= ' VALUES (';
		if ($idSQL != '')
			$query .= $idSQL . ',';

		$query .= "'" . $this->DBAddSlashes($this->type_name) . "', 'Y')";

		if ($this->Insert($query) == -1)
		{
			echo '<BR>' . sprintf(STR_DB_PRODUCTINSERTERR, $query) . '<BR>';
		}
	}

	function Edit()
	{
		$query = 'UPDATE dcl_wo_type SET ';
		$query .= "type_name='" . $this->DBAddSlashes($this->type_name) . "',";
		$query .= " active='" . $this->active . "'";
		$query .= ' WHERE wo_type_id=' . $this->wo_type_id;

		$this->Execute($query);
	}

	function Delete()
	{
		$query = 'DELETE FROM dcl_wo_type WHERE wo_type_id=' . $this->wo_type_id;
		return $this->Execute($query);
	}

	function SetActive($active)
	{
		$isActive = 'N';
		if ($active)
			$isActive = 'Y';

		$query = 'UPDATE dcl_wo_type SET ';
		$query .= "active='$isActive'";
		$query .= ' WHERE wo_type_id=' . $this->wo_type_id;

		return $this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res)
			return -1;

		if (count($this->Record) > 0)
		{
			$this->wo_type_id = $this->f('wo_type_id');
			$this->type_name = trim($this->f('type_name'));
			$this->active = $this->f('active');

			if ($this->cacheEnabled)
				$this->CacheRow($this->wo_type_id);
		}
		else
			$this->Clear();
	}

	function Load($id)
	{
		$this->Clear();

		if ($this->cacheEnabled && $this->LoadCache($id) != -1)
			return 0;

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT * FROM dcl_wo_type WHERE wo_type_id = $id";
		if (!$this->Query($sql))
			return -1;

		$this->next_record();
		return $this->GetRow();
	}

	function Clear()
	{
		$this->wo_type_id = 0;
		$this->type_name = '';
		$this->active = '';
	}
}
?>
