/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * bookmark.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bookmark.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __BOOKMARK_H__
#define __BOOKMARK_H__

/**************************************************************/
/* colorize entry of favorite clist existing in running clist */
/**************************************************************/
void colorize_favorite(GtkTreeModel *fav_gtm, int fav_addr_col, GtkTreeModel *other_gtm, int other_addr_col);

/********************************************************************/
/* this function reloads the bookmark into the 'hub_favorite_clist' */
/********************************************************************/
void reload_bookmark(void);

/******************************************/
/* add/update a new entry to the bookmark */
/*****************************************************************************/
/* if id_to_use==-1, the function uses a free id, else, the given id is used */
/*****************************************************************************/
void add_entry_to_bookmark(int id_to_use,char *name,char *description, char *address, char *profilename, char *flags, int no_reload);

/************************************/
/* delete a entry from the bookmark */
/************************************/
void delete_entry_from_bookmark_by_id(unsigned int bm_id, int no_reload);

/*********************************************/
/* toggle a flag of an entry of the bookmark */
/*********************************************/
void toggle_entry_flag_from_bookmark_by_id(int my_id, char *flag_to_toggle, int no_reload);

/***********************************************/
/* set the profile of an entry of the bookmark */
/***********************************************/
void set_entry_profile_from_bookmark_by_id(int my_id, char *profile_to_use, int no_reload);

/******************************************************************************************************/
/* Convert bookmarks from the old bookmark format (in /Bookmark/Content) into the new bookmark format */
/******************************************************************************************************/
void convert_old_bookmark_to_new_bookmark_format(void);

/*********************************************************/
/* search if the searched_flag is inside the flag_string */
/*********************************************************/
/* output: 1=yes, 0=no */
/***********************/
int flag_is_set(char *flag_string,char *searched_flag);

/****************************************************/ 
/* build modele and view for the hub favorite clist */ 
/****************************************************/ 
void bmav4_hub_favorite_clist(void);

#endif
