Imports System
Imports System.IO
Imports Db4objects.Db4o

' Copyright (C) 2004 - 2006 db4objects Inc. http://www.db4o.com 
Namespace Db4objects.Db4odoc.Binding

    Public Class CustomerForm
        Inherits System.Windows.Forms.Form
        Private _container As IObjectContainer = Nothing
        Private _customers As ArrayList = New ArrayList()

        Public Sub New()
            InitializeComponent()
            OpenDataFile()
            SetUpDataBindings()
        End Sub

        Private Sub OpenDataFile()
            Dim dataFile As String = Path.Combine(Application.UserAppDataPath, "data.yap")
            _container = Db4oFactory.OpenFile(dataFile)
        End Sub

        Private Sub SetUpDataBindings()
            Dim os As ObjectSet = _container.Get(GetType(Customer))
            If 0 = os.Size() Then
                ' Generate some initial data
                _customers.Add(New Customer("John Cleese", "55-98763333"))
                _customers.Add(New Customer("Herman Hesse", "32-33335555"))
                _customers.Add(New Customer("Douglas Adams", "42-42424242"))
            Else
                While os.HasNext()
                    _customers.Add(os.Next())
                End While
            End If
            _cmbCustomers.DisplayMember = "Name"
            _cmbCustomers.DataSource = _customers
            _txtPhoneNumber.DataBindings.Add("Text", _customers, "PhoneNumber")
        End Sub

        Private Sub PersistChanges()
            Dim customer As Customer
            For Each customer In _customers
                _container.Set(customer)
            Next
        End Sub

        Friend WithEvents _labelName As System.Windows.Forms.Label
        Friend WithEvents _labelPhone As System.Windows.Forms.Label
        Friend WithEvents _cmbCustomers As System.Windows.Forms.ComboBox
        Friend WithEvents _txtPhoneNumber As System.Windows.Forms.TextBox

        Private Sub InitializeComponent()
            Me._labelName = New System.Windows.Forms.Label
            Me._labelPhone = New System.Windows.Forms.Label
            Me._cmbCustomers = New System.Windows.Forms.ComboBox
            Me._txtPhoneNumber = New System.Windows.Forms.TextBox
            Me.SuspendLayout()
            '
            '_labelName
            '
            Me._labelName.AutoSize = True
            Me._labelName.Location = New System.Drawing.Point(12, 9)
            Me._labelName.Name = "_labelName"
            Me._labelName.Size = New System.Drawing.Size(51, 13)
            Me._labelName.TabIndex = 0
            Me._labelName.Text = "Customer"
            '
            '_labelPhone
            '
            Me._labelPhone.AutoSize = True
            Me._labelPhone.Location = New System.Drawing.Point(12, 40)
            Me._labelPhone.Name = "_labelPhone"
            Me._labelPhone.Size = New System.Drawing.Size(45, 13)
            Me._labelPhone.TabIndex = 1
            Me._labelPhone.Text = "Phone#"
            '
            '_cmbCustomers
            '
            Me._cmbCustomers.FormattingEnabled = True
            Me._cmbCustomers.Location = New System.Drawing.Point(103, 6)
            Me._cmbCustomers.Name = "_cmbCustomers"
            Me._cmbCustomers.Size = New System.Drawing.Size(177, 21)
            Me._cmbCustomers.TabIndex = 2
            '
            '_txtPhoneNumber
            '
            Me._txtPhoneNumber.Location = New System.Drawing.Point(103, 37)
            Me._txtPhoneNumber.Name = "_txtPhoneNumber"
            Me._txtPhoneNumber.Size = New System.Drawing.Size(177, 20)
            Me._txtPhoneNumber.TabIndex = 3
            '
            'CustomerForm
            '
            Me.AutoScaleDimensions = New System.Drawing.SizeF(6.0!, 13.0!)
            Me.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font
            Me.ClientSize = New System.Drawing.Size(292, 66)
            Me.Controls.Add(Me._txtPhoneNumber)
            Me.Controls.Add(Me._cmbCustomers)
            Me.Controls.Add(Me._labelPhone)
            Me.Controls.Add(Me._labelName)
            Me.Name = "CustomerForm"
            Me.Text = "Db4o Data Binding"
            Me.ResumeLayout(False)
            Me.PerformLayout()

        End Sub

        Private Sub CustomerForm_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
            PersistChanges()
            _container.Close()
            MyBase.OnClosing(e)
        End Sub
    End Class
End Namespace
