/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Types;

namespace Db4objects.Db4o.Types
{
	/// <summary>marks objects as second class objects.</summary>
	/// <remarks>
	/// marks objects as second class objects.
	/// <br /><br />Currently this interface is for internal use only
	/// to help discard com.db4o.config.Entry objects in the
	/// Defragment process.
	/// <br /><br />For future versions this interface is planned to
	/// mark objects that:<br />
	/// - are not to be held in the reference mechanism<br />
	/// - should always be activated with their parent objects<br />
	/// - should always be deleted with their parent objects<br />
	/// - should always be deleted if they are not referenced any
	/// longer.<br />
	/// </remarks>
	public interface ISecondClass : IDb4oType
	{
	}
}
