/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Ext;

namespace Db4objects.Db4o.Internal
{
	/// <exclude></exclude>
	public class SystemData
	{
		private int _classCollectionID;

		private int _converterVersion;

		private int _freespaceAddress;

		private int _freespaceID;

		private byte _freespaceSystem;

		private Db4oDatabase _identity;

		private long _lastTimeStampID;

		private byte _stringEncoding;

		private int _uuidIndexId;

		public virtual int ClassCollectionID()
		{
			return _classCollectionID;
		}

		public virtual void ClassCollectionID(int id)
		{
			_classCollectionID = id;
		}

		public virtual int ConverterVersion()
		{
			return _converterVersion;
		}

		public virtual void ConverterVersion(int version)
		{
			_converterVersion = version;
		}

		public virtual int FreespaceAddress()
		{
			return _freespaceAddress;
		}

		public virtual void FreespaceAddress(int address)
		{
			_freespaceAddress = address;
		}

		public virtual int FreespaceID()
		{
			return _freespaceID;
		}

		public virtual void FreespaceID(int id)
		{
			_freespaceID = id;
		}

		public virtual byte FreespaceSystem()
		{
			return _freespaceSystem;
		}

		public virtual void FreespaceSystem(byte freespaceSystemtype)
		{
			_freespaceSystem = freespaceSystemtype;
		}

		public virtual Db4oDatabase Identity()
		{
			return _identity;
		}

		public virtual void Identity(Db4oDatabase identityObject)
		{
			_identity = identityObject;
		}

		public virtual long LastTimeStampID()
		{
			return _lastTimeStampID;
		}

		public virtual void LastTimeStampID(long id)
		{
			_lastTimeStampID = id;
		}

		public virtual byte StringEncoding()
		{
			return _stringEncoding;
		}

		public virtual void StringEncoding(byte encodingByte)
		{
			_stringEncoding = encodingByte;
		}

		public virtual int UuidIndexId()
		{
			return _uuidIndexId;
		}

		public virtual void UuidIndexId(int id)
		{
			_uuidIndexId = id;
		}
	}
}
