/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Events
{
	/// <exclude></exclude>
	public class EventRegistryImpl : Db4objects.Db4o.Internal.Callbacks.ICallbacks, Db4objects.Db4o.Events.IEventRegistry
	{
		protected Db4objects.Db4o.Events.QueryEventHandler _queryStarted;

		protected Db4objects.Db4o.Events.QueryEventHandler _queryFinished;

		protected Db4objects.Db4o.Events.CancellableObjectEventHandler _creating;

		protected Db4objects.Db4o.Events.CancellableObjectEventHandler _activating;

		protected Db4objects.Db4o.Events.CancellableObjectEventHandler _updating;

		protected Db4objects.Db4o.Events.CancellableObjectEventHandler _deleting;

		protected Db4objects.Db4o.Events.CancellableObjectEventHandler _deactivating;

		protected Db4objects.Db4o.Events.ObjectEventHandler _created;

		protected Db4objects.Db4o.Events.ObjectEventHandler _activated;

		protected Db4objects.Db4o.Events.ObjectEventHandler _updated;

		protected Db4objects.Db4o.Events.ObjectEventHandler _deleted;

		protected Db4objects.Db4o.Events.ObjectEventHandler _deactivated;

		protected Db4objects.Db4o.Events.ClassEventHandler _classRegistered;

		public virtual void OnQueryFinished(Db4objects.Db4o.Query.IQuery query)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerQueryEvent(_queryFinished, query
				);
		}

		public virtual void OnQueryStarted(Db4objects.Db4o.Query.IQuery query)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerQueryEvent(_queryStarted, query
				);
		}

		public virtual bool ObjectCanNew(object obj)
		{
			return Db4objects.Db4o.Internal.Events.EventPlatform.TriggerCancellableObjectEventArgs
				(_creating, obj);
		}

		public virtual bool ObjectCanActivate(object obj)
		{
			return Db4objects.Db4o.Internal.Events.EventPlatform.TriggerCancellableObjectEventArgs
				(_activating, obj);
		}

		public virtual bool ObjectCanUpdate(object obj)
		{
			return Db4objects.Db4o.Internal.Events.EventPlatform.TriggerCancellableObjectEventArgs
				(_updating, obj);
		}

		public virtual bool ObjectCanDelete(object obj)
		{
			return Db4objects.Db4o.Internal.Events.EventPlatform.TriggerCancellableObjectEventArgs
				(_deleting, obj);
		}

		public virtual bool ObjectCanDeactivate(object obj)
		{
			return Db4objects.Db4o.Internal.Events.EventPlatform.TriggerCancellableObjectEventArgs
				(_deactivating, obj);
		}

		public virtual void ObjectOnActivate(object obj)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerObjectEvent(_activated, obj);
		}

		public virtual void ObjectOnNew(object obj)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerObjectEvent(_created, obj);
		}

		public virtual void ObjectOnUpdate(object obj)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerObjectEvent(_updated, obj);
		}

		public virtual void ObjectOnDelete(object obj)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerObjectEvent(_deleted, obj);
		}

		public virtual void ClassOnRegistered(Db4objects.Db4o.Internal.ClassMetadata clazz
			)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerClassEvent(_classRegistered, 
				clazz);
		}

		public virtual void ObjectOnDeactivate(object obj)
		{
			Db4objects.Db4o.Internal.Events.EventPlatform.TriggerObjectEvent(_deactivated, obj
				);
		}

		public virtual event Db4objects.Db4o.Events.QueryEventHandler QueryFinished
		{
			add
			{
				_queryFinished = (Db4objects.Db4o.Events.QueryEventHandler)System.Delegate.Combine
					(_queryFinished, value);
			}
			remove
			{
				_queryFinished = (Db4objects.Db4o.Events.QueryEventHandler)System.Delegate.Remove
					(_queryFinished, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.QueryEventHandler QueryStarted
		{
			add
			{
				_queryStarted = (Db4objects.Db4o.Events.QueryEventHandler)System.Delegate.Combine
					(_queryStarted, value);
			}
			remove
			{
				_queryStarted = (Db4objects.Db4o.Events.QueryEventHandler)System.Delegate.Remove(
					_queryStarted, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.CancellableObjectEventHandler Creating
		{
			add
			{
				_creating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Combine
					(_creating, value);
			}
			remove
			{
				_creating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Remove
					(_creating, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.CancellableObjectEventHandler Activating
		{
			add
			{
				_activating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Combine
					(_activating, value);
			}
			remove
			{
				_activating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Remove
					(_activating, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.CancellableObjectEventHandler Updating
		{
			add
			{
				_updating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Combine
					(_updating, value);
			}
			remove
			{
				_updating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Remove
					(_updating, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.CancellableObjectEventHandler Deleting
		{
			add
			{
				_deleting = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Combine
					(_deleting, value);
			}
			remove
			{
				_deleting = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Remove
					(_deleting, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.CancellableObjectEventHandler Deactivating
		{
			add
			{
				_deactivating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Combine
					(_deactivating, value);
			}
			remove
			{
				_deactivating = (Db4objects.Db4o.Events.CancellableObjectEventHandler)System.Delegate.Remove
					(_deactivating, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.ObjectEventHandler Created
		{
			add
			{
				_created = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Combine(_created
					, value);
			}
			remove
			{
				_created = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Remove(_created
					, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.ClassEventHandler ClassRegistered
		{
			add
			{
				_classRegistered = (Db4objects.Db4o.Events.ClassEventHandler)System.Delegate.Combine
					(_classRegistered, value);
			}
			remove
			{
				_classRegistered = (Db4objects.Db4o.Events.ClassEventHandler)System.Delegate.Remove
					(_classRegistered, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.ObjectEventHandler Activated
		{
			add
			{
				_activated = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Combine(_activated
					, value);
			}
			remove
			{
				_activated = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Remove(_activated
					, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.ObjectEventHandler Updated
		{
			add
			{
				_updated = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Combine(_updated
					, value);
			}
			remove
			{
				_updated = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Remove(_updated
					, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.ObjectEventHandler Deleted
		{
			add
			{
				_deleted = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Combine(_deleted
					, value);
			}
			remove
			{
				_deleted = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Remove(_deleted
					, value);
			}
		}

		public virtual event Db4objects.Db4o.Events.ObjectEventHandler Deactivated
		{
			add
			{
				_deactivated = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Combine
					(_deactivated, value);
			}
			remove
			{
				_deactivated = (Db4objects.Db4o.Events.ObjectEventHandler)System.Delegate.Remove(
					_deactivated, value);
			}
		}
	}
}
