/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
using System.IO;
using System.Diagnostics;

namespace Db4oAdmin.Tests
{
	public class ShellUtilities
	{
		public static void CopyFileToFolder(string fname, string path)
		{
			File.Copy(fname, Path.Combine(path, Path.GetFileName(fname)), true);
		}

		public class ProcessOutput
		{
			public int ExitCode;
			public string StdOut;
			public string StdErr;
			
			public override string ToString()
			{
				return StdOut + StdErr;
			}
		}

		public static ProcessOutput shell(string fname, params string[] args)
		{
			Process p = StartProcess(fname, args);
			ProcessOutput output = new ProcessOutput();
			output.StdOut = p.StandardOutput.ReadToEnd();
            output.StdErr = p.StandardError.ReadToEnd();
			p.WaitForExit();
			output.ExitCode = p.ExitCode;
			return output;
		}

		public static Process StartProcess(string filename, params string[] args)
		{
			Process p = new Process();
			p.StartInfo.CreateNoWindow = true;
			p.StartInfo.UseShellExecute = false;
			p.StartInfo.RedirectStandardOutput = true;
			p.StartInfo.RedirectStandardInput = true;
			p.StartInfo.RedirectStandardError = true;
			p.StartInfo.FileName = filename;
			p.StartInfo.Arguments = string.Join(" ", quote(args));
			p.Start();
			return p;
		}

		private static string[] quote(string[] args)
		{
			for (int i = 0; i < args.Length; ++i)
			{
				args[i] = string.Format("\"{0}\"", args[i]);
			}
			return args;
		}
	}
}
