/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "kcombotable.h"
#include "ktableedit.h"
#include "kcompletiontable.h"

#include <kdebug.h>
#include <klineedit.h>
#include <kdeversion.h>

KComboTable::KComboTable( QWidget *parent, const char *name )
        : KComboBox( true, parent, name ),
        m_tableEdit( new KTableEdit( this ) ),
        m_tableBox( new KCompletionTable( m_tableEdit ) ),
        m_completionTable( new KCompletionTable( m_tableEdit ) )
{
    setListBox( m_tableBox );
    setLineEdit( m_tableEdit );

#if KDE_IS_VERSION(3,4,0)
    setHandleSignals( false );
    m_tableEdit->setCompletionBox( m_completionTable );

    connect( m_completionTable, SIGNAL( selected( const QString& ) ),
             m_tableEdit, SLOT( setTextFromCombo( const QString& ) ) );
    connect( m_completionTable, SIGNAL( userCancelled( const QString& ) ),
             m_tableEdit, SLOT( userCancelled( const QString& ) ) );

    connect( m_completionTable, SIGNAL( activated( const QString& ) ),
             m_tableEdit, SIGNAL( completionBoxActivated( const QString& ) ) );
    setHandleSignals( true );
#endif

    setInsertionPolicy( NoInsertion );
    setCompletionMode( KGlobalSettings::CompletionPopupAuto );
    connect( this, SIGNAL( completion( const QString& ) ),
             SLOT( slotMakeCompletion( const QString& ) ) );
}

KComboTable::~KComboTable()
{}

void KComboTable::clearAll()
{
    if ( !m_tableBox || !m_completionTable )
        return;

    clear();
    completionObject()->clear();
    m_tableBox->clear();
    m_completionTable->clear();
    m_tableBox->clearWidths();
    m_completionTable->clearWidths();
}

QValueList<int> KComboTable::columnWidths() const
{
    return m_completionTable->columnWidths();
}

void KComboTable::setColumnWidths( QValueList<int> &colWidths )
{
    m_tableBox->setColumnWidths( colWidths );
    m_completionTable->setColumnWidths( colWidths );
}

void KComboTable::insertRow( QStringList &list, bool calculateWidths )
{
    if ( !m_tableBox || !m_completionTable )
        return;

    insertItem( list.join("|") );
    completionObject() ->addItem( list.join("|") );

    if ( calculateWidths )
    {
        m_tableBox->calculateWidths( list );
        m_completionTable->calculateWidths( list );
    }
}

void KComboTable::slotMakeCompletion( const QString &txt )
{
    completionObject() ->makeCompletion( txt );
}

#include "kcombotable.moc"
