/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef FIELDEDITORDIALOGIMPL_H
#define FIELDEDITORDIALOGIMPL_H

#include <fieldeditordialog.h>

class DataField;
class DataTable;

class FieldEditorDialog : public FieldEditorDialogBase
{
    Q_OBJECT
public:
    FieldEditorDialog( DataField *dataField, DataTable *parentTable,
                          bool configure, QWidget *parent = 0,
                          const char *name = 0 );

    virtual ~FieldEditorDialog();

    void accept();

protected slots:
    void calculatedToggled( bool toggle );
    void fieldNameChanged( const QString &name );
    void fieldLabelChanged( const QString &label );
    void fieldEquationChanged( const QString &equation );

private:
    void setup();

private:
    DataField *m_dataField;
    DataTable *m_parentTable;
    bool m_configure;
};

#endif
