/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "fieldeditordialogimpl.h"

#include "datafield.h"
#include "datatable.h"

#include <qcheckbox.h>
#include <qlineedit.h>

#include <qlabel.h>
#include <qgroupbox.h>
#include <qlayout.h>

#include <kiconloader.h>

FieldEditorDialog::FieldEditorDialog( DataField *dataField,
        DataTable *parentTable,
        bool configure,
        QWidget *parent,
        const char *name )
        : FieldEditorDialogBase( parent, name ),
        m_dataField( dataField ),
        m_parentTable( parentTable ),
        m_configure( configure )
{
    setMinimumSize( 800, 600 );
    setCaption( i18n("Field Editor Dialog") );

    wizard1->setPixmap( UserIcon( "wizard_table_4" ) );

    setup();
}

FieldEditorDialog::~FieldEditorDialog()
{}

void FieldEditorDialog::calculatedToggled( bool toggled )
{
    m_dataField->setCalculated( toggled );

    if ( toggled )
    {
        editEquation->setEnabled( true );
        editEquation->setText( m_dataField->equation() );
    }
    else
    {
        editEquation->setEnabled( false );
        editEquation->setText( QString::null );
    }
}

void FieldEditorDialog::fieldNameChanged( const QString &name )
{
    m_dataField->setName( name );
}

void FieldEditorDialog::fieldLabelChanged( const QString &label )
{
    m_dataField->setLabel( label );
}

void FieldEditorDialog::fieldEquationChanged( const QString &equation )
{
    m_dataField->setEquation( equation );
}

void FieldEditorDialog::setup()
{
    editName->setEnabled( m_dataField->isVirtual() );
    editName->setText( m_dataField->name() );

    editLabel->setEnabled( true );
    editLabel->setText( m_dataField->label() );

    checkBoxCalculated->setEnabled( !m_dataField->isVirtual() );
    checkBoxCalculated->setChecked( m_dataField->calculated() );
}

void FieldEditorDialog::accept()
{
    if ( !m_dataField->isVirtual() )
        m_parentTable->initializeFields();
    m_parentTable->initializeEditorFields();

    FieldEditorDialogBase::accept();
}

#include "fieldeditordialogimpl.moc"
