/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATATABLEINTERFACE_H
#define DATATABLEINTERFACE_H

#include <qvaluelist.h>

class DataTableObserver;

class Watched
{
public:
    void addObserver( DataTableObserver *observer );
    void removeObserver( DataTableObserver *observer );

protected:
    virtual ~Watched();

private:
    QValueList<DataTableObserver *> m_observers;
};

class DataTableInterface : public Watched
{
public:
    virtual QString name() const = 0;
};

class DataTableObserver
{
public:
    virtual ~DataTableObserver();

    void clearWatched()
    {
        m_dataTable = 0;
    }

protected:
    DataTableObserver( DataTableInterface *dataTable );
    const DataTableInterface *dataTable() const;

private:
    DataTableInterface *m_dataTable;
};

#endif
