/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <config.h>

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kstatusbar.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kkeydialog.h>

#include <kaction.h>
#include <kiconloader.h>

#include "datakiosk.h"
#include "statuslabel.h"
#include "actioncollection.h"
#include "datatablesplitter.h"

using namespace ActionCollection;

DataKiosk::DataKiosk( QWidget *parent, const char *name )
        : KParts::MainWindow( parent, name ),
        m_shuttingDown( false )
{
    // Expect segfaults if you change this order.

    setXMLFile( "datakioskui.rc" );

    m_partManager = new KParts::PartManager( this );
    connect( m_partManager, SIGNAL( activePartChanged( KParts::Part * ) ),
             this, SLOT( createGUI( KParts::Part * ) ) );

    setIcon( UserIcon( "table" ) );
    readSettings();

    setupActions();
    setupLayout();
    setupGUI( ToolBar | Save | Create );
    readConfig();
    processArgs();
}

DataKiosk::~DataKiosk()
{}

KActionCollection *DataKiosk::actionCollection() const
{
    return ActionCollection::actions();
}

void DataKiosk::setupLayout()
{
    setMinimumSize( 640, 480 );
    m_splitter = new DataTableSplitter( this, "dataTableSplitter" );
    setCentralWidget( m_splitter );

    m_statusLabel = new StatusLabel( m_splitter->dataTable(), statusBar() );
    statusBar() ->addWidget( m_statusLabel, 1 );
    m_splitter->setFocus();
}

void DataKiosk::setupActions()
{
    ActionCollection::actions() ->setWidget( this );

    KStdAction::quit( this, SLOT( slotQuit() ), actions() );

    KStdAction::keyBindings( this, SLOT( slotEditKeys() ), actions() );
}

void DataKiosk::processArgs()
{
    KCmdLineArgs * args = KCmdLineArgs::parsedArgs();
    QStringList files;

    for ( int i = 0; i < args->count(); i++ )
        files.append( args->arg( i ) );
}

void DataKiosk::keyPressEvent( QKeyEvent *e )
{
    if ( e->key() >= Qt::Key_Back && e->key() <= Qt::Key_MediaLast )
        e->accept();
    KMainWindow::keyPressEvent( e );
}

void DataKiosk::readSettings()
{}

void DataKiosk::readConfig()
{}

void DataKiosk::saveConfig()
{
    KGlobal::config() ->sync();
}

bool DataKiosk::queryExit()
{
    hide();
    saveConfig();
    delete m_splitter;
    return true;
}

bool DataKiosk::queryClose()
{
    return true;
}

void DataKiosk::showEvent( QShowEvent */*ev*/ )
{
    emit showing();
}

void DataKiosk::hideEvent( QHideEvent */*ev*/ )
{
    emit hiding();
}

void DataKiosk::windowActivationChange( bool /*oldActive*/ )
{
    if( isActiveWindow() )
        emit raising();
    else
        emit lowering();
}

void DataKiosk::slotQuit()
{
    m_shuttingDown = true;
    kapp->quit();
}

void DataKiosk::slotEditKeys()
{
    KKeyDialog::configure( actions(), this );
}

#include "datakiosk.moc"
