/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef FORMLAYOUT_H
#define FORMLAYOUT_H

#include <qlayout.h>
#include <qptrlist.h>

class QRect;

class FormLayoutIterator : public QGLayoutIterator
{
public:
    FormLayoutIterator( QPtrList<QLayoutItem> *l )
            : idx( 0 ), m_itemList( l )
    {}

    QLayoutItem *current()
    {
        return idx < int( m_itemList->count() ) ? m_itemList->at( idx ) : 0;
    }

    QLayoutItem *next()
    {
        idx++;
        return current();
    }

    QLayoutItem *takeCurrent()
    {
        return m_itemList->take( idx );
    }

private:
    int idx;
    QPtrList<QLayoutItem> *m_itemList;
};

class FormLayout : public QLayout
{
    Q_OBJECT
public:
    FormLayout( QWidget *parent, int margin = 0, int spacing = -1 );
    FormLayout( QLayout *parent, int spacing );
    FormLayout( int spacing );
    ~FormLayout();

    virtual void addItem( QLayoutItem *item );
    virtual QSizePolicy::ExpandData expanding() const;
    virtual bool hasHeightForWidth() const;
    virtual int heightForWidth( int ) const;
    virtual QSize minimumSize() const;
    virtual QSize sizeHint() const;
    virtual QLayoutIterator iterator();
    virtual bool isEmpty() const;

public slots:
    void slotCalculateItemSize();

protected:
    virtual void setGeometry( const QRect &rect );

private:
    int doLayout( const QRect &rect, bool testOnly ) const;

    QPtrList<QLayoutItem> m_itemList;
    int m_itemWidth;
    int m_itemHeight;
    int m_width;
};

#endif
