/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "formlayout.h"

#include "datatableeditorfactory.h"

#include <kdebug.h>

FormLayout::FormLayout( QWidget *parent, int margin, int spacing )
        : QLayout( parent, margin, spacing ),
        m_itemWidth( 100 ),
        m_itemHeight( 50 ),
        m_width( 0 )
{
}

FormLayout::FormLayout( QLayout *parent, int spacing )
        : QLayout( parent, spacing ),
        m_itemWidth( 100 ),
        m_itemHeight( 50 ),
        m_width( 0 )
{
}

FormLayout::FormLayout( int spacing )
        : QLayout( spacing ),
        m_itemWidth( 100 ),
        m_itemHeight( 50 ),
        m_width( 0 )
{
}

FormLayout::~FormLayout()
{
    deleteAllItems();
}

void FormLayout::addItem( QLayoutItem *item )
{
    if ( item->minimumSize().height() > m_itemHeight )
        m_itemHeight = item->minimumSize().height();

    m_itemList.append( item );
}

QLayoutIterator FormLayout::iterator()
{
    return QLayoutIterator( new FormLayoutIterator( &m_itemList ) );
}

bool FormLayout::isEmpty() const
{
    return m_itemList.isEmpty();
}

QSizePolicy::ExpandData FormLayout::expanding() const
{
    return QSizePolicy::NoDirection;
}

bool FormLayout::hasHeightForWidth() const
{
    return false;
}

int FormLayout::heightForWidth( int width ) const
{
    int height = doLayout( QRect( 0, 0, width, 0 ), true );
    return height;
}

void FormLayout::setGeometry( const QRect &rect )
{
    QLayout::setGeometry( rect );
    slotCalculateItemSize();
    doLayout( rect, false );
}

QSize FormLayout::sizeHint() const
{
    return minimumSize();
}

QSize FormLayout::minimumSize() const
{
    return QSize( m_itemWidth, doLayout( QRect( 0, 0, m_width, 0 ), true ) );
}

void FormLayout::slotCalculateItemSize()
{
    QPtrListIterator<QLayoutItem> it( m_itemList );
    if ( it.count() == 0 )
        return;

    QLayoutItem *item;
    while ( ( item = it.current() ) != 0 )
    {
        ++it;
        if ( ::qt_cast<DataEditorBase*>( item->widget() ) )
        {
            QSize s = ( ( DataEditorBase* ) item->widget() )->getRecommendedSize();
            if ( s.width() > m_itemWidth )
                m_itemWidth = s.width();
        }
    }
    m_width = mainWidget()->width();
}

int FormLayout::doLayout( const QRect &rect, bool testOnly ) const
{
    int x = rect.x();
    int y = rect.y();
    int lineHeight = 0;

    QPtrListIterator<QLayoutItem> it( m_itemList );
    if ( it.count() == 0 )
        return 0;

    QLayoutItem *item;
    while ( ( item = it.current() ) != 0 )
    {
        ++it;
        int nextX = x + m_itemWidth + spacing();
        if ( nextX - spacing() > rect.right() && lineHeight > 0 )
        {
            x = rect.x();
            y = y + lineHeight + spacing();
            nextX = x + m_itemWidth + spacing();
            lineHeight = 0;
        }

        if ( !testOnly )
            item ->setGeometry( QRect( QPoint( x, y ), QSize( m_itemWidth, m_itemHeight ) ) );

        x = nextX;
        lineHeight = QMAX( lineHeight, m_itemHeight );
    }
    return y + lineHeight - rect.y();
}

#include "formlayout.moc"
