/***************************************************************************
 *   Copyright (C) 2005 by Adam Treat                                      *
 *   treat@kde.org                                                         *
 *                                                                         *
 *   Copyright (C) 2004 by Scott Wheeler                                   *
 *   wheeler@kde.org                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATAKIOSK_H
#define DATAKIOSK_H

#include <kapplication.h>
#include <kparts/mainwindow.h>
#include <kparts/partmanager.h>

#include <kmainwindow.h>
#include "statuslabel.h"
#include "datatablesplitter.h"

class QTimer;
class QListViewItem;
class StatusLabel;
class DataManager;
class DataTableSplitter;

class DataKiosk /*: public KMainWindow*/ : public KParts::MainWindow
{
    Q_OBJECT

public:
    DataKiosk( QWidget* parent = 0, const char *name = "datakiosk" );
    virtual ~DataKiosk();
    virtual KActionCollection *actionCollection() const;

    void setStatusLeft( const QString &text )
    {
        m_statusLabel->setLeft( text );
    };
    void setStatusRight( const QString &text )
    {
        m_statusLabel->setRight( text );
    };
    void setStatusFarRight( const QString &text )
    {
        m_statusLabel->setFarRight( text );
    };

    KParts::PartManager *partManager() const
    {
        return m_partManager;
    };

signals:
    void showing();
    void hiding();
    void raising();
    void lowering();

protected:
    virtual void showEvent( QShowEvent *ev );
    virtual void hideEvent( QHideEvent *ev );
    virtual void windowActivationChange( bool oldActive );

private slots:
    void slotQuit();
    void slotEditKeys();

private:
    void setupLayout();
    void setupActions();
    void processArgs();

    void keyPressEvent( QKeyEvent * );

    void readSettings();
    void readConfig();
    void saveConfig();

    virtual bool queryExit();
    virtual bool queryClose();

private:
    DataTableSplitter *m_splitter;
    StatusLabel *m_statusLabel;

    KParts::PartManager *m_partManager;

    bool m_shuttingDown;
};

#endif
