/***************************************************************************
*   Copyright (C) 2005 by Adam Treat                                      *
*   treat@kde.org                                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef DATACLIP_H
#define DATACLIP_H

#include <qframe.h>

class QGrid;
class QLabel;
class QPixmap;
class QPainter;
class QCheckBox;
class QPushButton;

class PlainButton : public QFrame
{
    Q_OBJECT
public:
    PlainButton( const QPixmap &icon, int frameStyle, QWidget *parent );

    virtual ~PlainButton();

signals:
    void clicked();

protected:
    virtual void mousePressEvent( QMouseEvent *ev );
    virtual void mouseReleaseEvent( QMouseEvent *ev );

private:
    QLabel *m_label;
    int m_frameStyle;
    QColor m_background;
};

class CopyItem : public PlainButton
{
    Q_OBJECT
public:
    CopyItem( QWidget *parent, const QString &text );

    virtual ~CopyItem();

public:
    QString text() const;

public slots:
    void setText( const QString &text );
    void paste();

private:
    QString m_text;
};

class DataClip : public QFrame
{
    Q_OBJECT
public:
    DataClip( QWidget *parent );

    virtual ~DataClip();

private slots:
    void appendCopy();
    void clear();

private:
    QGrid *m_grid;
    QValueList<CopyItem *> m_copies;
};

class TitleBar : public QFrame
{
    Q_OBJECT
public:
    TitleBar( QWidget *parent, DataClip *clip );

    virtual ~TitleBar();

protected:
    virtual void mousePressEvent( QMouseEvent *ev );
    virtual void mouseMoveEvent( QMouseEvent * ev );

private slots:
    void close();

private:
    int m_x;
    int m_y;
    DataClip *m_clip;
    QCheckBox *m_close;
};

#endif
