#!/usr/bin/perl -ws
#
# Upload script that will move testing results to the server submission
# area (usually /ftp/incoming). This one cgi can service multiple Dashboards
# if they share a submission area. The TriggerDart.cgi script is customized 
# on a project by project basis to move testing results from the server 
# submission area to that project's test summarization area.
#
# Installation:
#    Place this script in your cgi-bin area.
#    Change the name of the script to match what is indicated by the
#         "DROP_LOCATION" indicated in your project's DartConfig.cmake file.
#    Change the variable "incoming_directory" to indicate the subsmission
#        staging area.
#
###

use CGI;
$form = CGI::new();
print $form->header();

$done = 0;
$incoming_directory = "/ftp/incoming";

# Process Form
my $FileData, $FileName;
if( scalar($form->param("FileName")) ) {
  $FileName = $form->param("FileName");
}
if(scalar($form->param("FileData"))) {
  $FileData = $form->param("FileData");
}

# Verify file specified
if ( !length($FileData) || !length("FileName") ) {
  print "Please send file.<BR>\n";
  print "FileName has to contain file name<BR>\n";
  print "FileData has to contain file content<BR>\n";
  #?print form
  exit;
}
print "Received file:  $FileName<BR>\n";

# Check if valid file name
$FileName =~ s/[\/\\|:%%]/_/g;
if($FileName =~ /^.+___.+___[0-9]{8}-[0-9]{4}-(Experimental|Nightly|Continuous)___XML___(Update|Configure|Build|Test|Coverage|Purify)\.xml$/) {
  print "Correct file name<BR>\n";
} else {
  print "Can only upload files with format:<BR>\n";
  print "<site>___<BuildType>___<TAG>-<TestType>___XML___<File>.xml<BR>\n";
  exit;
}

# write to a file on disk
if( length($FileData) ) {
  open OUT, ">$incoming_directory/$FileName" or die "Cannot create file: $incoming_directory/$FileName";
  print OUT $FileData;
  close OUT;
  print "Thank you for the file<BR>\n";
  $done = 1;
}

if( !$done ) {
  print "Problem submitting data<BR>\n";
}
