/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;

public class SimpleTraceListener
implements TraceListener {
    private int indent = 0;
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    public void open() {
        System.err.println("<trace>");
    }

    public void close() {
        System.err.println("</trace>");
    }

    public void enter(InstructionInfo instructionInfo) {
        int n;
        String string = instructionInfo.getSystemId();
        if (string == null) {
            string = "";
        }
        while ((n = string.indexOf(47)) >= 0 && n < string.length() - 6) {
            string = string.substring(n + 1);
        }
        String string2 = instructionInfo.getInstructionName();
        String string3 = (String)instructionInfo.getProperty("instruction-namespace");
        String string4 = (String)instructionInfo.getProperty("mode");
        String string5 = (String)instructionInfo.getProperty("value");
        String string6 = (String)instructionInfo.getProperty("name");
        System.err.println(SimpleTraceListener.spaces(this.indent) + "<Instruction element=\"" + string2 + (string6 != null ? "\" name=\"" + string6 : "") + (string5 != null ? "\" value=\"" + string5 : "") + (string3 != null && !string3.equals("http://www.w3.org/1999/XSL/Transform") ? "\" inst-namespace=\"" + string3 : "") + "\" line=\"" + instructionInfo.getLineNumber() + "\" file=\"" + string + (string4 != null ? "\" mode=\"" + string4 : "") + "\">");
        ++this.indent;
    }

    public void leave(InstructionInfo instructionInfo) {
        --this.indent;
        System.err.println(SimpleTraceListener.spaces(this.indent) + "</Instruction> <!-- " + instructionInfo.getInstructionName() + " -->");
    }

    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            System.err.println(SimpleTraceListener.spaces(this.indent) + "<Source node=\"" + Navigator.getPath(nodeInfo) + "\" line=\"" + nodeInfo.getLineNumber() + "\">");
        }
        ++this.indent;
    }

    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            System.err.println(SimpleTraceListener.spaces(this.indent) + "</Source><!-- " + Navigator.getPath(nodeInfo) + " -->");
        }
    }

    private static String spaces(int n) {
        if (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }
}

