/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Validation;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.SaxonCollation;
import net.sf.saxon.style.SaxonImportQuery;
import net.sf.saxon.style.SaxonScript;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.style.XSLImportSchema;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.xpath.XPathException;

public class XSLStyleSheet
extends StyleElement {
    private NamePool targetNamePool;
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStyleSheet importer = null;
    private PreparedStyleSheet stylesheet;
    private List topLevel;
    private Mode stripperRules = null;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private HashMap collationTable;
    private String defaultCollationName = null;
    private HashMap characterMapIndex;
    private HashMap templateIndex = new HashMap();
    private HashSet schemaIndex = new HashSet();
    private HashMap xqueryFunctionIndex;
    private int numberOfAliases = 0;
    private ArrayList namespaceAliasList = new ArrayList(5);
    private short[] aliasSCodes;
    private int[] aliasNCodes;
    private int numberOfVariables = 0;
    private HashMap variableMap = new HashMap();
    private int largestStackFrame = 0;
    private HashMap stylesheetModules = new HashMap();
    private int defaultValidation = 4;

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.stylesheet = preparedStyleSheet;
        this.targetNamePool = preparedStyleSheet.getTargetNamePool();
        this.ruleManager = new RuleManager();
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStyleSheet();
        }
        return this.stylesheet;
    }

    public NamePool getTargetNamePool() {
        return this.targetNamePool;
    }

    protected int putModuleNumber(String string) {
        Integer n = (Integer)this.stylesheetModules.get(string);
        if (n == null) {
            n = new Integer(this.stylesheetModules.size());
            this.stylesheetModules.put(string, n);
        }
        return n;
    }

    protected int getModuleNumber(String string) {
        Integer n = (Integer)this.stylesheetModules.get(string);
        return n;
    }

    private String[] getModuleArray() {
        String[] stringArray = new String[this.stylesheetModules.size()];
        Iterator iterator = this.stylesheetModules.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = this.getModuleNumber(string);
            stringArray[n] = string;
        }
        return stringArray;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    protected Mode getStripperRules() {
        if (this.stripperRules == null) {
            this.stripperRules = new Mode();
        }
        return this.stripperRules;
    }

    public boolean stripsWhitespace() {
        int n = 0;
        while (n < this.topLevel.size()) {
            NodeInfo nodeInfo = (NodeInfo)this.topLevel.get(n);
            if (nodeInfo.getFingerprint() == 179) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager(this.getConfiguration());
        }
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setCollation(String string, Comparator comparator, boolean bl) {
        if (this.collationTable == null) {
            this.collationTable = new HashMap();
        }
        this.collationTable.put(string, comparator);
        if (bl) {
            this.defaultCollationName = string;
        }
    }

    protected Comparator findCollation(String string) {
        Comparator comparator = null;
        if (string == null) {
            string = this.defaultCollationName;
        }
        if (this.collationTable != null) {
            comparator = (Comparator)this.collationTable.get(string);
        }
        if (comparator != null) {
            return comparator;
        }
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n = list.size() - 1;
        while (n >= 0) {
            if (list.get(n) instanceof SaxonCollation) {
                SaxonCollation saxonCollation = (SaxonCollation)list.get(n);
                if (string == null && saxonCollation.isDefaultCollation()) {
                    this.defaultCollationName = saxonCollation.getCollationName();
                    return saxonCollation.getCollator();
                }
                if (saxonCollation.getCollationName().equals(string)) {
                    return saxonCollation.getCollator();
                }
            }
            --n;
        }
        if (string == null) {
            return null;
        }
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        this.findCollation(null);
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public XSLCharacterMap getCharacterMap(int n) {
        int n2 = this.topLevel.size() - 1;
        while (n2 >= 0) {
            XSLCharacterMap xSLCharacterMap;
            if (this.topLevel.get(n2) instanceof XSLCharacterMap && (xSLCharacterMap = (XSLCharacterMap)this.topLevel.get(n2)).getCharacterMapFingerprint() == n) {
                return xSLCharacterMap;
            }
            --n2;
        }
        return null;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int n) {
        this.minImportPrecedence = n;
    }

    public void setImporter(XSLStyleSheet xSLStyleSheet) {
        this.importer = xSLStyleSheet;
    }

    public XSLStyleSheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public List getTopLevel() {
        return this.topLevel;
    }

    public int allocateSlotNumber() {
        return this.numberOfVariables++;
    }

    public void allocateLocalSlots(int n) {
        if (n > this.largestStackFrame) {
            this.largestStackFrame = n;
        }
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string = this.getNamePool().getClarkName(n2);
            if (string == "version") {
                this.processVersionAttribute(string);
            } else if (string != "id" && string != "extension-element-prefixes" && string != "exclude-result-prefixes") {
                if (string == "default-validation") {
                    this.defaultValidation = Validation.getCode(attributeCollection.getValue(n));
                    if (this.defaultValidation == -1) {
                        this.compileError("Invalid value for default-validation attribute. Permitted values are (strict, lax, preserve, strip)");
                    }
                } else {
                    this.checkUnknownAttribute(n2);
                }
            }
            ++n;
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
    }

    public int getDefaultValidation() {
        return this.defaultValidation;
    }

    protected int getNamespaceAlias(short s) {
        int n = 0;
        while (n < this.numberOfAliases) {
            if (s == this.aliasSCodes[n]) {
                return this.aliasNCodes[n];
            }
            ++n;
        }
        return s;
    }

    protected boolean isAliasResultNamespace(short s) {
        int n = 0;
        while (n < this.numberOfAliases) {
            if (s == (this.aliasNCodes[n] & 0xFFFF)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void validate() throws TransformerConfigurationException {
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (!(this.getParentNode() instanceof DocumentInfo)) {
            this.compileError(this.getDisplayName() + " must be the outermost element");
        }
    }

    public void preprocess() throws TransformerConfigurationException {
        this.spliceIncludes();
        this.buildIndexes();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.get(n);
            if (e instanceof StyleElement) {
                ((StyleElement)e).fixupReferences();
            }
            ++n;
        }
        this.validate();
        int n2 = 0;
        while (n2 < this.topLevel.size()) {
            Object e = this.topLevel.get(n2);
            if (e instanceof StyleElement) {
                ((StyleElement)e).validateSubtree();
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void spliceIncludes() throws TransformerConfigurationException {
        var1_1 = false;
        this.topLevel = new ArrayList<E>();
        this.minImportPrecedence = this.precedence;
        var2_2 /* !! */  = this;
        var3_3 = this.iterateAxis((byte)3);
        while ((var4_4 = (NodeInfo)var3_3.next()) != null) {
            block11: {
                if (var4_4.getNodeKind() == 3) {
                    if (Navigator.isWhite(var4_4.getStringValue())) continue;
                    var2_2 /* !! */ .compileError("No character data is allowed between top-level elements");
                    continue;
                }
                if (var4_4 instanceof DataElement) {
                    var1_1 = true;
                    continue;
                }
                var2_2 /* !! */  = (StyleElement)var4_4;
                if (!(var4_4 instanceof XSLGeneralIncorporate)) break block11;
                var5_5 = (XSLGeneralIncorporate)var4_4;
                var5_5.processAttributes();
                if (var5_5.isImport()) {
                    if (var1_1) {
                        var5_5.compileError("xsl:import elements must come first");
                    }
                } else {
                    var1_1 = true;
                }
                if ((var6_6 = var5_5.getIncludedStyleSheet(this, this.precedence)) == null) {
                    return;
                }
                if (var5_5.isImport()) {
                    this.precedence = var6_6.getPrecedence() + 1;
                } else {
                    this.precedence = var6_6.getPrecedence();
                    var6_6.setMinImportPrecedence(this.minImportPrecedence);
                    var6_6.setWasIncluded();
                }
                var7_7 = var6_6.topLevel;
                var8_8 = 0;
                while (var8_8 < var7_7.size()) {
                    block12: {
                        var9_9 = (StyleElement)var7_7.get(var8_8);
                        var10_10 = this.topLevel.size() - 1;
                        if (var10_10 >= 0 && var9_9.getPrecedence() < ((StyleElement)this.topLevel.get(var10_10)).getPrecedence()) ** GOTO lbl41
                        this.topLevel.add(var9_9);
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            --var10_10;
lbl41:
                            // 2 sources

                            ** while (var10_10 >= 0 && var9_9.getPrecedence() < ((StyleElement)this.topLevel.get((int)var10_10)).getPrecedence())
                        }
lbl42:
                        // 1 sources

                        this.topLevel.add(var10_10 + 1, var9_9);
                    }
                    ++var8_8;
                }
                continue;
            }
            var1_1 = true;
            this.topLevel.add(var4_4);
        }
    }

    private void buildIndexes() throws TransformerConfigurationException {
        int n = this.topLevel.size() - 1;
        while (n >= 0) {
            Object e = this.topLevel.get(n);
            if (e instanceof XSLTemplate) {
                this.indexNamedTemplate((XSLTemplate)e);
            } else if (e instanceof XSLVariableDeclaration) {
                this.indexVariableDeclaration((XSLVariableDeclaration)e);
            } else if (e instanceof XSLNamespaceAlias) {
                this.namespaceAliasList.add(e);
                ++this.numberOfAliases;
            } else if (e instanceof XSLImportSchema) {
                ((XSLImportSchema)e).readSchema();
            } else if (e instanceof SaxonImportQuery) {
                ((SaxonImportQuery)e).importModule();
            }
            --n;
        }
    }

    private void indexVariableDeclaration(XSLVariableDeclaration xSLVariableDeclaration) throws TransformerConfigurationException {
        int n = xSLVariableDeclaration.getVariableFingerprint();
        if (n != -1) {
            Integer n2 = new Integer(n);
            XSLVariableDeclaration xSLVariableDeclaration2 = (XSLVariableDeclaration)this.variableMap.get(n2);
            if (xSLVariableDeclaration2 == null) {
                this.variableMap.put(n2, xSLVariableDeclaration);
            } else {
                int n3;
                int n4 = xSLVariableDeclaration.getPrecedence();
                if (n4 == (n3 = xSLVariableDeclaration2.getPrecedence())) {
                    xSLVariableDeclaration.compileError("Duplicate global variable declaration (see line " + xSLVariableDeclaration2.getLineNumber() + " of " + xSLVariableDeclaration2.getSystemId() + ")");
                } else if (n4 < n3) {
                    xSLVariableDeclaration.setRedundant();
                } else {
                    xSLVariableDeclaration2.setRedundant();
                    this.variableMap.put(n2, xSLVariableDeclaration);
                }
            }
        }
    }

    private void indexNamedTemplate(XSLTemplate xSLTemplate) throws TransformerConfigurationException {
        int n = xSLTemplate.getTemplateFingerprint();
        if (n != -1) {
            Integer n2 = new Integer(n);
            XSLTemplate xSLTemplate2 = (XSLTemplate)this.templateIndex.get(n2);
            if (xSLTemplate2 == null) {
                this.templateIndex.put(n2, xSLTemplate);
            } else {
                int n3;
                int n4 = xSLTemplate.getPrecedence();
                if (n4 == (n3 = xSLTemplate2.getPrecedence())) {
                    xSLTemplate.compileError("Duplicate named template (see line " + xSLTemplate2.getLineNumber() + " of " + xSLTemplate2.getSystemId() + ")");
                } else if (n4 >= n3) {
                    this.templateIndex.put(n2, xSLTemplate);
                }
            }
        }
    }

    private void collectNamespaceAliases() throws TransformerConfigurationException {
        this.aliasSCodes = new short[this.numberOfAliases];
        this.aliasNCodes = new int[this.numberOfAliases];
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.numberOfAliases) {
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)this.namespaceAliasList.get(n3);
            short s = xSLNamespaceAlias.getStylesheetURICode();
            int n4 = xSLNamespaceAlias.getResultNamespaceCode();
            int n5 = xSLNamespaceAlias.getPrecedence();
            if (n2 != n5) {
                n2 = n5;
                n = n3;
            }
            int n6 = n;
            while (n6 < n3) {
                if (s == this.aliasSCodes[n6] && (n4 & 0xFFFF) != (this.aliasNCodes[n6] & 0xFFFF)) {
                    xSLNamespaceAlias.compileError("Inconsistent namespace aliases");
                }
                ++n6;
            }
            this.aliasSCodes[n3] = s;
            this.aliasNCodes[n3] = n4;
            ++n3;
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.prepareAttributes();
        if (this.topLevel == null) {
            return;
        }
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.get(n);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).processAllAttributes();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    ((StyleElement)e).compileError(transformerConfigurationException);
                }
            }
            ++n;
        }
    }

    public XSLVariableDeclaration getGlobalVariable(int n) {
        return (XSLVariableDeclaration)this.variableMap.get(new Integer(n));
    }

    public Properties gatherOutputProperties(int n) throws TransformerConfigurationException {
        boolean bl = n == -1;
        Properties properties = new Properties();
        int n2 = 0;
        while (n2 < this.topLevel.size()) {
            XSLOutput xSLOutput;
            Object e = this.topLevel.get(n2);
            if (e instanceof XSLOutput && (xSLOutput = (XSLOutput)e).getOutputFingerprint() == n) {
                bl = true;
                xSLOutput.gatherOutputProperties(properties);
            }
            ++n2;
        }
        if (!bl) {
            throw new TransformerConfigurationException("Requested output format has not been defined");
        }
        return properties;
    }

    public Class getExternalJavaClass(String string) {
        if (!this.getPreparedStyleSheet().getConfiguration().isAllowExternalFunctions()) {
            return null;
        }
        int n = this.topLevel.size() - 1;
        while (n >= 0) {
            SaxonScript saxonScript;
            Class clazz;
            Object e = this.topLevel.get(n);
            if (e instanceof SaxonScript && (clazz = (saxonScript = (SaxonScript)e).getJavaClass(string)) != null) {
                return clazz;
            }
            --n;
        }
        return null;
    }

    protected void declareXQueryFunction(XQueryFunction xQueryFunction) {
        if (this.xqueryFunctionIndex == null) {
            this.xqueryFunctionIndex = new HashMap();
        }
        this.xqueryFunctionIndex.put(new Integer(xQueryFunction.getFunctionFingerprint()), xQueryFunction);
    }

    protected XQueryFunction bindXQueryFunction(int n) {
        if (this.xqueryFunctionIndex == null) {
            return null;
        }
        return (XQueryFunction)this.xqueryFunctionIndex.get(new Integer(n));
    }

    protected boolean isImportedSchema(String string) {
        return this.schemaIndex.contains(string);
    }

    protected void addImportedSchema(String string) {
        this.schemaIndex.add(string);
    }

    public Executable compileStyleSheet() throws TransformerConfigurationException {
        Executable executable = new Executable();
        try {
            StyleElement styleElement;
            Object object;
            Serializable serializable;
            Object object2;
            if (this.xqueryFunctionIndex != null) {
                Iterator iterator = this.xqueryFunctionIndex.values().iterator();
                while (iterator.hasNext()) {
                    object2 = (XQueryFunction)iterator.next();
                    try {
                        ((XQueryFunction)object2).fixupReferences();
                    }
                    catch (XPathException xPathException) {
                        this.compileError(xPathException);
                    }
                }
            }
            int n = 0;
            while (n < this.topLevel.size()) {
                object2 = (NodeInfo)this.topLevel.get(n);
                if (object2 instanceof StyleElement && (serializable = ((StyleElement)(object = (StyleElement)object2)).compile(executable)) != null) {
                    serializable.setSourceLocation(this.putModuleNumber(((ElementImpl)object).getSystemId()), ((StyleElement)object).getLineNumber());
                }
                ++n;
            }
            if (this.decimalFormatManager != null) {
                this.decimalFormatManager.fixupDefaultDefault();
            }
            executable.setModuleArray(this.getModuleArray());
            executable.setRuleManager(this.ruleManager);
            executable.setKeyManager(this.keyManager);
            executable.setStripperRules(this.stripperRules);
            executable.setStripsWhitespace(this.stripsWhitespace());
            executable.setDecimalFormatManager(this.decimalFormatManager);
            executable.setDefaultCollationName(this.defaultCollationName);
            executable.setCollationTable(this.collationTable);
            executable.setDefaultOutputProperties(this.gatherOutputProperties(-1));
            executable.setSlotSpace(this.numberOfVariables, this.largestStackFrame);
            object2 = new HashMap<Instruction, Template>(this.templateIndex.size());
            object = this.templateIndex.keySet().iterator();
            while (object.hasNext()) {
                serializable = (Integer)object.next();
                styleElement = (XSLTemplate)this.templateIndex.get(serializable);
                ((HashMap)object2).put(serializable, ((XSLTemplate)styleElement).getCompiledTemplate());
            }
            executable.setNamedTemplateTable((HashMap)object2);
            int n2 = 0;
            while (n2 < this.topLevel.size()) {
                if (this.topLevel.get(n2) instanceof XSLCharacterMap && !((XSLCharacterMap)(styleElement = (XSLCharacterMap)this.topLevel.get(n2))).isRedundant()) {
                    int n3 = ((XSLCharacterMap)styleElement).getCharacterMapFingerprint();
                    HashMap hashMap = new HashMap();
                    ((XSLCharacterMap)styleElement).assemble(hashMap);
                    if (this.characterMapIndex == null) {
                        this.characterMapIndex = new HashMap();
                    }
                    this.characterMapIndex.put(new Integer(n3), hashMap);
                }
                ++n2;
            }
            executable.setCharacterMapIndex(this.characterMapIndex);
            return executable;
        }
        catch (RuntimeException runtimeException) {
            if (this.getPreparedStyleSheet().getErrorCount() > 0) {
                return executable;
            }
            throw runtimeException;
        }
    }

    public Instruction compile(Executable executable) {
        return null;
    }
}

