/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SequenceInstruction;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;

public final class XSLSequence
extends StyleElement {
    private Expression select;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        if (this.select != null) {
            return this.select.getItemType();
        }
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "select") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (this.select != null && this.hasChildNodes()) {
            this.compileError("If xsl:sequence has a select attribute, it must not have child instructions");
        }
        this.select = this.typeCheck("select", this.select);
    }

    public void markTailCalls() {
        StyleElement styleElement = this.getLastChildInstruction();
        if (styleElement != null) {
            styleElement.markTailCalls();
        } else if (this.select != null) {
            ExpressionTool.markTailFunctionCalls(this.select);
        }
    }

    public Instruction compile(Executable executable) throws TransformerConfigurationException {
        SequenceInstruction sequenceInstruction = new SequenceInstruction(this.select, null);
        this.compileChildren(executable, sequenceInstruction);
        return sequenceInstruction;
    }
}

