/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceChecker;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Sequence
extends ExprInstruction {
    private Expression select;
    private SequenceType requiredType;

    public Sequence(Expression select, SequenceType requiredType) {
        this.select = select;
        this.requiredType = requiredType;
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression simplify() throws XPathException {
        if (this.select != null) {
            this.select = this.select.simplify();
        }
        return super.simplify();
    }

    public Expression analyze(StaticContext env) throws XPathException {
        if (this.select != null) {
            this.select = this.select.analyze(env);
            if (this.requiredType != null) {
                RoleLocator role = new RoleLocator(4, "sequence/select", 0);
                this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, role);
            }
        }
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                if (!(this.children[c] instanceof ExprInstruction)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                this.children[c] = (ExprInstruction)((ExprInstruction)this.children[c]).analyze(env);
                ++c;
            }
        }
        return this;
    }

    public void getXPathExpressions(List list) {
        if (this.select != null) {
            list.add(this.select);
            return;
        }
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                if (!(this.children[c] instanceof ExprInstruction)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ((ExprInstruction)this.children[c]).getXPathExpressions(list);
                ++c;
            }
        }
    }

    public void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(offer);
        }
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                if (this.children[c] instanceof ExprInstruction) {
                    Expression p = ((ExprInstruction)this.children[c]).promote(offer);
                    this.children[c] = p instanceof Instruction ? (Instruction)((Object)p) : new Sequence(p, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ++c;
            }
        }
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails details) {
        details.setInstructionName("sequence");
    }

    public TailCall processLeavingTail(XPathContext context) throws TransformerException {
        Controller controller = context.getController();
        SequenceReceiver out = controller.getReceiver();
        if (this.select != null) {
            Item it;
            SequenceIterator iter = this.select.iterate(context);
            while ((it = iter.next()) != null) {
                this.appendItem(it, context, out);
            }
            return null;
        }
        if (this.requiredType == null) {
            TailCall tc = null;
            if (this.children != null) {
                tc = this.processChildrenLeavingTail(context);
            }
            return tc;
        }
        SequenceChecker checker = new SequenceChecker();
        checker.setRequiredType(this.requiredType);
        checker.setUnderlyingReceiver(out);
        controller.setReceiver(checker);
        if (this.select != null) {
            Item it;
            SequenceIterator iter = this.select.iterate(context);
            while ((it = iter.next()) != null) {
                this.appendItem(it, context, checker);
            }
        }
        if (this.children != null) {
            this.processChildren(context);
        }
        checker.finalCheck();
        controller.setReceiver(out);
        return null;
    }

    private void appendItem(Item it, XPathContext context, SequenceReceiver out) throws TransformerException {
        block0: while (it instanceof ObjectValue && ((ObjectValue)it).getObject() instanceof UserFunctionCall.FunctionCallPackage) {
            Value v = ((UserFunctionCall.FunctionCallPackage)((ObjectValue)it).getObject()).call();
            SequenceIterator fv = v.iterate(context);
            Item fvit;
            while ((fvit = fv.next()) != null) {
                if (fvit instanceof ObjectValue && ((ObjectValue)it).getObject() instanceof UserFunctionCall.FunctionCallPackage) {
                    it = fvit;
                    continue block0;
                }
                out.append(fvit);
            }
            return;
        }
        out.append(it);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        if (this.children != null) {
            throw new IllegalStateException("Cannot process xsl:sequence with children as an expression");
        }
        return this.select.iterate(context);
    }

    public void display(int level, NamePool pool) {
        System.err.println(ExpressionTool.indent(level) + "sequence");
        if (this.select != null) {
            this.select.display(level + 1, pool);
        }
        if (this.children != null) {
            int c = 0;
            while (c < this.children.length) {
                if (this.children[c] instanceof Expression) {
                    ((Expression)((Object)this.children[c])).display(level + 1, pool);
                } else {
                    System.err.println(ExpressionTool.indent(level + 1) + this.children[c].getInstructionName());
                }
                ++c;
            }
        }
    }
}

