/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Err;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;

public final class FixedAttribute
extends SimpleNodeConstructor {
    private int nameCode;
    private SimpleType schemaType;
    private int annotation;
    private int options;
    private int validationAction;

    public FixedAttribute(int n, int n2, SimpleType simpleType, int n3) {
        this.nameCode = n;
        this.schemaType = simpleType;
        this.annotation = n3;
        this.validationAction = n2;
        this.options = 0;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public String getInstructionName() {
        return "attribute";
    }

    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 512;
    }

    public void typeCheck(StaticContext staticContext) throws XPathException {
    }

    protected int evaluateNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    /*
     * Unable to fully structure code
     */
    public TailCall processLeavingTail(XPathContext var1_1) throws TransformerException {
        var2_2 = var1_1.getController();
        var3_3 = var2_2.getReceiver();
        var4_4 = this.options;
        var5_5 = this.annotation;
        var6_6 = this.expandChildren(var1_1).toString();
        if (this.schemaType != null) {
            try {
                this.schemaType.validateContent(var6_6, DummyNamespaceResolver.getInstance());
                if (!this.schemaType.isNamespaceSensitive()) ** GOTO lbl18
                this.options |= 512;
            }
            catch (ValidationException var7_7) {
                throw new ValidationException("Attribute value " + Err.wrap(var6_6, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + var7_7.getMessage());
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            var7_8 = var2_2.getConfiguration().validateAttribute(this.nameCode, var6_6, this.validationAction);
            var5_5 = (int)(var7_8 & -1L);
            var4_4 |= (int)(var7_8 >> 32);
        }
lbl18:
        // 5 sources

        try {
            var3_3.attribute(this.nameCode, var5_5, var6_6, var4_4);
        }
        catch (NoOpenStartTagException var7_9) {
            Instruction.recoverableError(this, "Cannot write an attribute node when no element start tag is open", var2_2);
        }
        catch (TransformerException var8_10) {
            throw Instruction.dynamicError(this, var8_10, var1_1.getController());
        }
        return null;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "attribute ");
        System.err.println(ExpressionTool.indent(n + 1) + "name " + (namePool == null ? this.nameCode + "" : namePool.getDisplayName(this.nameCode)));
        super.display(n + 1, namePool);
    }
}

