/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.Err;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Minimax
extends CollatingFunction {
    public static final int MIN = 2;
    public static final int MAX = 3;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        SequenceIterator sequenceIterator;
        AtomicValue atomicValue2;
        Serializable serializable = this.getAtomicComparer(1, xPathContext);
        if (this.operation == 3) {
            serializable = new DescendingComparer((Comparator)((Object)serializable));
        }
        if ((atomicValue2 = (AtomicValue)(sequenceIterator = this.argument[0].iterate(xPathContext)).next()) == null) {
            return null;
        }
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            AtomicValue atomicValue3 = atomicValue;
            if (atomicValue instanceof UntypedAtomicValue) {
                try {
                    atomicValue3 = new DoubleValue(Value.stringToNumber(atomicValue.getStringValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XPathException.Dynamic("Failure converting " + Err.wrap(atomicValue.getStringValue()) + " to a number");
                }
            }
            if (atomicValue3 instanceof NumericValue && ((NumericValue)atomicValue3).isNaN()) {
                return atomicValue3;
            }
            try {
                if (serializable.compare(atomicValue3, atomicValue2) >= 0) continue;
                atomicValue2 = atomicValue;
            }
            catch (ClassCastException classCastException) {
                this.typeError("Cannot compare " + atomicValue2.getItemType() + " with " + atomicValue.getItemType());
                return null;
            }
        }
        return atomicValue2;
    }
}

