/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Emitter;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerProxy
extends Emitter
implements Locator {
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    protected Locator locator = this;
    private int depth = 0;
    private boolean requireWellFormed = false;
    private boolean undeclareNamespaces = false;
    private Stack elementStack = new Stack();
    private AttributesImpl pendingAttributes = new AttributesImpl();
    private int pendingElement = -1;

    public void setUnderlyingContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)contentHandler);
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setOutputProperties(Properties properties) throws TransformerException {
        String string = properties.getProperty("{http://saxon.sf.net/}require-well-formed");
        if (string != null) {
            this.requireWellFormed = string.equals("yes");
        }
        if ((string = properties.getProperty("{http://saxon.sf.net/}undeclare-namespaces")) != null) {
            this.undeclareNamespaces = string.equals("yes");
        }
        super.setOutputProperties(properties);
    }

    public boolean isRequireWellFormed() {
        return this.requireWellFormed;
    }

    public void setRequireWellFormed(boolean bl) {
        this.requireWellFormed = bl;
    }

    public boolean isUndeclareNamespaces() {
        return this.undeclareNamespaces;
    }

    public void setUndeclareNamespaces(boolean bl) {
        this.undeclareNamespaces = bl;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws TransformerException {
        if (this.handler == null) {
            throw new TransformerException("ContentHandlerProxy.startDocument(): no underlying handler provided");
        }
        try {
            this.handler.setDocumentLocator(this.locator);
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        this.depth = 0;
    }

    public void endDocument() throws TransformerException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        ++this.depth;
        if (this.depth <= 0 && this.requireWellFormed) {
            this.notifyNotWellFormed();
        }
        this.pendingElement = n;
    }

    public void namespace(int n, int n2) throws TransformerException {
        String string = this.namePool.getPrefixFromNamespaceCode(n);
        String string2 = this.namePool.getURIFromNamespaceCode(n);
        if (!this.undeclareNamespaces && "".equals(string2) && !"".equals(string)) {
            return;
        }
        try {
            this.handler.startPrefixMapping(string, string2);
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void attribute(int n, int n2, CharSequence charSequence, int n3) throws TransformerException {
        String string = this.namePool.getURI(n);
        String string2 = this.namePool.getLocalName(n);
        String string3 = this.namePool.getDisplayName(n);
        int n4 = this.pendingAttributes.getIndex(string, string2);
        String string4 = this.getTypeName(n2 & 0xFFFFF);
        if (n4 < 0) {
            this.pendingAttributes.addAttribute(string, string2, string3, string4, charSequence.toString());
        } else {
            this.pendingAttributes.setAttribute(n4, string, string2, string3, string4, charSequence.toString());
        }
    }

    private String getTypeName(int n) {
        switch (n) {
            case 560: {
                return "ID";
            }
            case 561: {
                return "IDREF";
            }
            case 562: {
                return "IDREFS";
            }
            case 563: {
                return "ENTITY";
            }
            case 564: {
                return "ENTITIES";
            }
            case 556: {
                return "NMTOKEN";
            }
            case 557: {
                return "NMTOKENS";
            }
        }
        return "CDATA";
    }

    public void startContent() throws TransformerException {
        try {
            if (this.depth > 0 || !this.requireWellFormed) {
                String string = this.namePool.getURI(this.pendingElement);
                String string2 = this.namePool.getLocalName(this.pendingElement);
                String string3 = this.namePool.getDisplayName(this.pendingElement);
                this.handler.startElement(string, string2, string3, this.pendingAttributes);
                this.elementStack.push(string);
                this.elementStack.push(string2);
                this.elementStack.push(string3);
                this.pendingAttributes.clear();
                this.pendingElement = -1;
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception instanceof TransformerException) {
                throw (TransformerException)exception;
            }
            throw new TransformerException(sAXException);
        }
    }

    public void endElement() throws TransformerException {
        if (this.depth > 0) {
            try {
                String string = (String)this.elementStack.pop();
                String string2 = (String)this.elementStack.pop();
                String string3 = (String)this.elementStack.pop();
                this.handler.endElement(string3, string2, string);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(sAXException);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        boolean bl;
        boolean bl2 = bl = (n & 1) != 0;
        if (bl) {
            this.setEscaping(false);
        }
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                boolean bl3;
                String string = charSequence.toString();
                boolean bl4 = bl3 = string.trim().length() == 0;
                if (!bl3) {
                    this.notifyNotWellFormed();
                }
            } else {
                this.handler.characters(charSequence.toString().toCharArray(), 0, charSequence.length());
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
        if (bl) {
            this.setEscaping(true);
        }
    }

    protected void notifyNotWellFormed() throws TransformerException {
        throw new TransformerException("The result tree cannot be supplied to the ContentHandler because it is not well-formed XML");
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        try {
            this.handler.processingInstruction(string, charSequence.toString());
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(charSequence.toString().toCharArray(), 0, charSequence.length());
            }
        }
        catch (SAXException sAXException) {
            throw new TransformerException(sAXException);
        }
    }

    private void setEscaping(boolean bl) {
        try {
            this.handler.processingInstruction(bl ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException sAXException) {}
    }

    public String getPublicId() {
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }
}

