/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Loader;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.SimpleTraceListener;
import net.sf.saxon.trace.TimedTraceListener;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.UntypedAtomicValue;
import org.xml.sax.InputSource;

public class Transform {
    protected TransformerFactoryImpl factory = new TransformerFactoryImpl();
    protected Configuration config;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;

    public static void main(String[] stringArray) throws Exception {
        new Transform().doMain(stringArray, "java net.sf.saxon.Transform");
    }

    protected void setFactoryConfiguration() {
        this.factory.setConfiguration(new Configuration());
    }

    protected void doMain(String[] stringArray, String string) {
        block77: {
            String string2 = null;
            String string3 = null;
            File file = null;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string4 = null;
            String string5 = null;
            String string6 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            this.setFactoryConfiguration();
            this.config = this.factory.getConfiguration();
            boolean bl4 = this.config.isSchemaAware();
            try {
                Object object;
                Object object2;
                Source source;
                Object object3;
                int n = 0;
                while (true) {
                    Object object4;
                    if (n >= stringArray.length) {
                        this.badUsage(string, "No source file name");
                    }
                    if (stringArray[n].charAt(0) != '-') break;
                    if (stringArray[n].equals("-a")) {
                        bl = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-c")) {
                        bl3 = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ds")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(0));
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-dt")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/treeModel", new Integer(1));
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-im")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No initial mode after -im");
                        }
                        string5 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-it")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No initial template after -it");
                        }
                        string6 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-l")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", new Boolean(true));
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-u")) {
                        this.useURLs = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-v")) {
                        this.factory.setAttribute("http://saxon.sf.net/feature/validation", new Boolean(true));
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-val")) {
                        if (bl4) {
                            this.factory.setAttribute("http://saxon.sf.net/feature/schema-validation", new Boolean(true));
                        } else {
                            Transform.quit("The -val option requires a schema-aware processor", 2);
                        }
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-t")) {
                        System.err.println(this.config.getProductTitle());
                        System.err.println("Java version " + System.getProperty("java.version"));
                        this.factory.setAttribute("http://saxon.sf.net/feature/timing", new Boolean(true));
                        Loader.setTracing(true);
                        this.showTime = true;
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-3")) {
                        ++n;
                        this.repeat = 3;
                        continue;
                    }
                    if (stringArray[n].equals("-9")) {
                        ++n;
                        this.repeat = 9;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No output file name");
                        }
                        string4 = stringArray[n++];
                        continue;
                    }
                    if (stringArray[n].equals("-x")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No source parser class");
                        }
                        object4 = stringArray[n++];
                        this.factory.setAttribute("http://saxon.sf.net/feature/sourceParserClass", object4);
                        continue;
                    }
                    if (stringArray[n].equals("-y")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No style parser class");
                        }
                        object4 = stringArray[n++];
                        this.factory.setAttribute("http://saxon.sf.net/feature/styleParserClass", object4);
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No URIResolver class");
                        }
                        object4 = stringArray[n++];
                        this.factory.setURIResolver(Transform.makeURIResolver((String)object4));
                        continue;
                    }
                    if (stringArray[n].equals("-T")) {
                        ++n;
                        object4 = new SimpleTraceListener();
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", object4);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-TP")) {
                        ++n;
                        object4 = new TimedTraceListener();
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", object4);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-TJ")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/trace-external-functions", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-TL")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No TraceListener class");
                        }
                        object4 = Transform.makeTraceListener(stringArray[n++]);
                        this.factory.setAttribute("http://saxon.sf.net/feature/traceListener", object4);
                        this.factory.setAttribute("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
                        continue;
                    }
                    if (stringArray[n].equals("-w0")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(0));
                        continue;
                    }
                    if (stringArray[n].equals("-w1")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(1));
                        continue;
                    }
                    if (stringArray[n].equals("-w2")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/recoveryPolicy", new Integer(2));
                        continue;
                    }
                    if (stringArray[n].equals("-m")) {
                        if (stringArray.length < ++n + 2) {
                            this.badUsage(string, "No message Emitter class");
                        }
                        this.factory.setAttribute("http://saxon.sf.net/feature/messageEmitterClass", stringArray[n++]);
                        continue;
                    }
                    if (stringArray[n].equals("-noext")) {
                        ++n;
                        this.factory.setAttribute("http://saxon.sf.net/feature/allow-external-functions", new Boolean(false));
                        continue;
                    }
                    if (stringArray[n].equals("-?")) {
                        this.badUsage(string, "");
                        continue;
                    }
                    if (stringArray[n].equals("-")) break;
                    this.badUsage(string, "Unknown option " + stringArray[n]);
                }
                if (string6 != null && bl) {
                    this.badUsage(string, "-it and -a options cannot be used together");
                }
                if (string6 == null) {
                    if (stringArray.length < n + 1) {
                        this.badUsage(string, "No source file name");
                    }
                    string2 = stringArray[n++];
                }
                if (!bl) {
                    if (stringArray.length < n + 1) {
                        this.badUsage(string, "No stylesheet file name");
                    }
                    string3 = stringArray[n++];
                }
                int n2 = n;
                while (n2 < stringArray.length) {
                    object3 = stringArray[n2];
                    int n3 = ((String)object3).indexOf("=");
                    if (n3 < 1 || n3 >= ((String)object3).length() - 1) {
                        this.badUsage(string, "Bad param=value pair on command line");
                    }
                    arrayList.add(object3);
                    ++n2;
                }
                this.config.displayLicenseMessage();
                object3 = null;
                if (string6 == null) {
                    object3 = Transform.loadDocuments(string2, this.useURLs, this.config);
                    boolean bl5 = bl2 = (object3 = this.preprocess((List)object3)).size() > 1;
                    if (bl2) {
                        if (string4 == null) {
                            Transform.quit("To process a directory, -o must be specified", 2);
                        } else if (string4.equals(string2)) {
                            Transform.quit("Output directory must be different from input", 2);
                        } else {
                            file = new File(string4);
                            if (!file.isDirectory()) {
                                Transform.quit("Input is a directory, but output is not", 2);
                            }
                        }
                    }
                }
                if (string4 != null && !bl2 && (file = new File(string4)).isDirectory()) {
                    Transform.quit("Output is a directory, but input is not", 2);
                }
                if (bl) {
                    if (bl2) {
                        this.processDirectoryAssoc((List)object3, file, arrayList, string5);
                    } else {
                        this.processFileAssoc((Source)object3.get(0), null, file, arrayList, string5);
                    }
                    break block77;
                }
                long l = new Date().getTime();
                if (this.useURLs || string3.startsWith("http:") || string3.startsWith("file:")) {
                    source = this.factory.getURIResolver().resolve(string3, null);
                    if (source == null) {
                        source = new StandardURIResolver().resolve(string3, null);
                    }
                } else if (string3.equals("-")) {
                    source = new SAXSource(this.config.getStyleParser(), new InputSource(System.in));
                } else {
                    object2 = new File(string3);
                    if (!((File)object2).exists()) {
                        Transform.quit("Stylesheet file " + object2 + " does not exist", 2);
                    }
                    object = new InputSource(((File)object2).toURI().toString());
                    source = new SAXSource(this.config.getStyleParser(), (InputSource)object);
                }
                if (source == null) {
                    Transform.quit("URIResolver for stylesheet file must return a Source", 2);
                }
                object2 = null;
                if (bl3) {
                    try {
                        object = new ObjectInputStream(new FileInputStream(string3));
                        object2 = (Templates)((ObjectInputStream)object).readObject();
                        ((ObjectInputStream)object).close();
                        ((PreparedStyleSheet)object2).setConfiguration(this.config);
                        this.config.setNamePool(((PreparedStyleSheet)object2).getTargetNamePool());
                        NamePool.setDefaultNamePool(((PreparedStyleSheet)object2).getTargetNamePool());
                        if (this.showTime) {
                            long l2 = new Date().getTime();
                            System.err.println("Stylesheet loading time: " + (l2 - l) + " milliseconds");
                            l = l2;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    object2 = this.factory.newTemplates(source);
                    if (this.showTime) {
                        long l3 = new Date().getTime();
                        System.err.println("Stylesheet compilation time: " + (l3 - l) + " milliseconds");
                        l = l3;
                    }
                }
                if (string6 != null) {
                    this.execute(string6, (Templates)object2, file, arrayList, string5);
                    break block77;
                }
                if (bl2) {
                    this.processDirectory((List)object3, (Templates)object2, file, arrayList, string5);
                    break block77;
                }
                this.processFile((Source)object3.get(0), (Templates)object2, file, arrayList, string5);
            }
            catch (TerminationException terminationException) {
                Transform.quit(terminationException.getMessage(), 1);
            }
            catch (TransformerException transformerException) {
                Transform.quit("Transformation failed: " + transformerException.getMessage(), 2);
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                Transform.quit("Transformation failed: " + transformerFactoryConfigurationError.getMessage(), 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Transform.quit("Fatal error during transformation: " + exception.getMessage(), 2);
            }
        }
    }

    public List preprocess(List list) throws TransformerException {
        return list;
    }

    protected static void quit(String string, int n) {
        System.err.println(string);
        System.exit(n);
    }

    public static List loadDocuments(String string, boolean bl, Configuration configuration) throws TransformerException {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        if (bl || string.startsWith("http:") || string.startsWith("file:")) {
            Source source = configuration.getURIResolver().resolve(string, null);
            if (source == null) {
                source = new StandardURIResolver().resolve(string, null);
            }
            arrayList.add(source);
        } else if (string.equals("-")) {
            SAXSource sAXSource = new SAXSource(configuration.getSourceParser(), new InputSource(System.in));
            arrayList.add(sAXSource);
        } else {
            File file = new File(string);
            if (!file.exists()) {
                Transform.quit("Source file " + file + " does not exist", 2);
            }
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file, stringArray[n]);
                    if (!file2.isDirectory()) {
                        InputSource inputSource = new InputSource(file2.toURI().toString());
                        SAXSource sAXSource = new SAXSource(configuration.getSourceParser(), inputSource);
                        arrayList.add(sAXSource);
                    }
                    ++n;
                }
            } else {
                InputSource inputSource = new InputSource(file.toURI().toString());
                SAXSource sAXSource = new SAXSource(configuration.getSourceParser(), inputSource);
                arrayList.add(sAXSource);
            }
        }
        return arrayList;
    }

    public void processDirectoryAssoc(List list, File file, ArrayList arrayList, String string) throws Exception {
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            SAXSource sAXSource = (SAXSource)list.get(n2);
            String string2 = Transform.getLocalFileName(sAXSource);
            try {
                this.processFileAssoc(sAXSource, string2, file, arrayList, string);
            }
            catch (TransformerException transformerException) {
                ++n;
                System.err.println("While processing " + string2 + ": " + transformerException.getMessage() + "\n");
            }
            ++n2;
        }
        if (n > 0) {
            throw new TransformerException(n + " transformation" + (n == 1 ? "" : "s") + " failed");
        }
    }

    private File makeOutputFile(File file, String string, Templates templates) {
        String string2 = templates.getOutputProperties().getProperty("media-type");
        String string3 = ".xml";
        if ("text/html".equals(string2)) {
            string3 = ".html";
        } else if ("text/plain".equals(string2)) {
            string3 = ".txt";
        }
        String string4 = string;
        if (string.endsWith(".xml") || string.endsWith(".XML")) {
            string4 = string.substring(0, string.length() - 4);
        }
        return new File(file, string4 + string3);
    }

    public void processFileAssoc(Source source, String string, File file, ArrayList arrayList, String string2) throws TransformerException {
        File file2;
        if (this.showTime) {
            System.err.println("Processing " + source.getSystemId() + " using associated stylesheet");
        }
        long l = new Date().getTime();
        Source source2 = this.factory.getAssociatedStylesheet(source, null, null, null);
        Templates templates = this.factory.newTemplates(source2);
        if (this.showTime) {
            System.err.println("Prepared associated stylesheet " + source2.getSystemId());
        }
        Transformer transformer = templates.newTransformer();
        this.setParams(transformer, arrayList);
        if (string2 != null) {
            ((Controller)transformer).setInitialMode(string2);
        }
        if ((file2 = file) != null && file2.isDirectory()) {
            file2 = this.makeOutputFile(file2, string, templates);
        }
        StreamResult streamResult = file2 == null ? new StreamResult(System.out) : new StreamResult(file2.toURI().toString());
        try {
            transformer.transform(source, streamResult);
        }
        catch (TerminationException terminationException) {
            throw terminationException;
        }
        catch (TransformerException transformerException) {
            throw new TransformerException("Run-time errors were reported");
        }
        if (this.showTime) {
            long l2 = new Date().getTime();
            System.err.println("Execution time: " + (l2 - l) + " milliseconds");
            l = l2;
        }
    }

    public void processDirectory(List list, Templates templates, File file, ArrayList arrayList, String string) throws TransformerException {
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            SAXSource sAXSource = (SAXSource)list.get(n2);
            String string2 = Transform.getLocalFileName(sAXSource);
            try {
                File file2 = this.makeOutputFile(file, string2, templates);
                this.processFile(sAXSource, templates, file2, arrayList, string);
            }
            catch (TransformerException transformerException) {
                ++n;
                System.err.println("While processing " + string2 + ": " + transformerException.getMessage() + "\n");
            }
            ++n2;
        }
        if (n > 0) {
            throw new TransformerException(n + " transformation" + (n == 1 ? "" : "s") + " failed");
        }
    }

    private static String getLocalFileName(SAXSource sAXSource) {
        try {
            String string = new URI(sAXSource.getSystemId()).getPath();
            while (true) {
                int n;
                if ((n = string.indexOf(47)) < 0) {
                    return string;
                }
                string = string.substring(n + 1);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException.getMessage());
        }
    }

    public void processFile(Source source, Templates templates, File file, ArrayList arrayList, String string) throws TransformerException {
        int n = 0;
        while (n < this.repeat) {
            if (this.showTime) {
                System.err.println("Processing " + source.getSystemId());
            }
            long l = new Date().getTime();
            Transformer transformer = templates.newTransformer();
            this.setParams(transformer, arrayList);
            if (string != null) {
                ((Controller)transformer).setInitialMode(string);
            }
            StreamResult streamResult = file == null ? new StreamResult(System.out) : new StreamResult(file.toURI().toString());
            try {
                transformer.transform(source, streamResult);
            }
            catch (TerminationException terminationException) {
                throw terminationException;
            }
            catch (TransformerException transformerException) {
                throw new TransformerException("Run-time errors were reported");
            }
            if (this.showTime) {
                long l2 = new Date().getTime();
                System.err.println("Execution time: " + (l2 - l) + " milliseconds");
                l = l2;
            }
            ++n;
        }
    }

    public void execute(String string, Templates templates, File file, ArrayList arrayList, String string2) throws TransformerException {
        int n = 0;
        while (n < this.repeat) {
            if (this.showTime) {
                System.err.println("Calling template " + string);
            }
            long l = new Date().getTime();
            Transformer transformer = templates.newTransformer();
            this.setParams(transformer, arrayList);
            if (string2 != null) {
                ((Controller)transformer).setInitialMode(string2);
            }
            ((Controller)transformer).setInitialTemplate(string);
            StreamResult streamResult = file == null ? new StreamResult(System.out) : new StreamResult(file.toURI().toString());
            try {
                transformer.transform(null, streamResult);
            }
            catch (TerminationException terminationException) {
                throw terminationException;
            }
            catch (TransformerException transformerException) {
                throw new TransformerException("Run-time errors were reported");
            }
            if (this.showTime) {
                long l2 = new Date().getTime();
                System.err.println("Execution time: " + (l2 - l) + " milliseconds");
                l = l2;
            }
            ++n;
        }
    }

    private void setParams(Transformer transformer, ArrayList arrayList) throws TransformerException {
        int n = 0;
        while (n < arrayList.size()) {
            int n2;
            String string = (String)arrayList.get(n);
            String string2 = string.substring(0, n2 = string.indexOf("="));
            if (string2.startsWith("!")) {
                transformer.setOutputProperty(string2.substring(1), string.substring(n2 + 1));
            } else if (string2.startsWith("+")) {
                List list = Transform.loadDocuments(string.substring(n2 + 1), this.useURLs, this.config);
                transformer.setParameter(string2.substring(1), list);
            } else {
                transformer.setParameter(string2, new UntypedAtomicValue(string.substring(n2 + 1)));
            }
            ++n;
        }
    }

    protected void badUsage(String string, String string2) {
        if (!"".equals(string2)) {
            System.err.println(string2);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: " + string + " [options] source-doc style-doc {param=value}...");
        System.err.println("Options: ");
        System.err.println("  -a              Use xml-stylesheet PI, not style-doc argument");
        System.err.println("  -c              Indicates that style-doc is a compiled stylesheet");
        System.err.println("  -ds             Use standard tree data structure");
        System.err.println("  -dt             Use tinytree data structure (default)");
        System.err.println("  -im modename    Start transformation in specified mode");
        System.err.println("  -it template    Start transformation by calling named template");
        System.err.println("  -l              Retain line numbers in source document tree");
        System.err.println("  -o filename     Send output to named file or directory");
        System.err.println("  -m classname    Use specified Emitter class for xsl:message output");
        System.err.println("  -r classname    Use specified URIResolver class");
        System.err.println("  -t              Display version and timing information");
        System.err.println("  -T              Set standard TraceListener");
        System.err.println("  -TJ             Trace calls to external Java functions");
        System.err.println("  -TL classname   Set a specific TraceListener");
        System.err.println("  -u              Names are URLs not filenames");
        System.err.println("  -v              Validate source documents using DTD");
        if (this.config.isSchemaAware()) {
            System.err.println("  -val            Validate source documents using schema");
        }
        System.err.println("  -w0             Recover silently from recoverable errors");
        System.err.println("  -w1             Report recoverable errors and continue (default)");
        System.err.println("  -w2             Treat recoverable errors as fatal");
        System.err.println("  -x classname    Use specified SAX parser for source file");
        System.err.println("  -y classname    Use specified SAX parser for stylesheet");
        System.err.println("  -?              Display this message ");
        System.err.println("  param=value     Set stylesheet string parameter");
        System.err.println("  +param=file     Set stylesheet document parameter");
        System.err.println("  !option=value   Set serialization option");
        if ("".equals(string2)) {
            System.exit(0);
        } else {
            System.exit(2);
        }
    }

    public static URIResolver makeURIResolver(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof URIResolver) {
            return (URIResolver)object;
        }
        throw new TransformerException("Class " + string + " is not a URIResolver");
    }

    public static TraceListener makeTraceListener(String string) throws TransformerException {
        Object object = Loader.getInstance(string);
        if (object instanceof TraceListener) {
            return (TraceListener)object;
        }
        throw new TransformerException("Class " + string + " is not a TraceListener");
    }
}

