/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ResultWrapper;
import net.sf.saxon.event.Sender;
import org.xml.sax.SAXParseException;

class IdentityTransformer
extends Controller {
    protected IdentityTransformer(Configuration configuration) {
        super(configuration);
    }

    public void transform(Source source, Result result) throws TransformerException {
        try {
            Receiver receiver = ResultWrapper.getReceiver(result, this.getConfiguration(), this.getOutputProperties(), null);
            NamespaceReducer namespaceReducer = new NamespaceReducer();
            namespaceReducer.setUnderlyingReceiver(receiver);
            new Sender(this.getConfiguration()).send(source, namespaceReducer);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable != null && throwable instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                if ((throwable = sAXParseException.getException()) instanceof RuntimeException) {
                    this.getErrorListener().fatalError(transformerException);
                }
            } else {
                this.getErrorListener().fatalError(transformerException);
            }
            throw transformerException;
        }
    }
}

