/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Loader;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.Version;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaMarker;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationContext;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Configuration
implements Serializable {
    private transient URIResolver resolver;
    private transient ErrorListener listener;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private NamePool targetNamePool = NamePool.getDefaultNamePool();
    private boolean stripsAllWhiteSpace = false;
    private int hostLanguage = 10;
    private HashMap queryLibraryModules = null;
    private boolean schemaValidation = false;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XSLT = 10;
    public static final int XQUERY = 11;

    public String getProductTitle() {
        return "Saxon " + Version.getProductVersion() + " from Saxonica";
    }

    public boolean isSchemaAware() {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public URIResolver getURIResolver() {
        if (this.resolver == null) {
            this.resolver = new StandardURIResolver(this);
        }
        return this.resolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.listener = errorListener;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String string) {
        this.messageEmitterClass = string;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String string) {
        this.sourceParserClass = string;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String string) {
        this.styleParserClass = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean bl) {
        this.allowExternalFunctions = bl;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setTraceExternalFunctions(boolean bl) {
        this.traceExternalFunctions = bl;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean bl) {
        this.validation = bl;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public void setSchemaValidation(boolean bl) {
        if (bl && !this.isSchemaAware()) {
            this.needSchemaAwareVersion();
        }
        this.schemaValidation = bl;
    }

    public NamePool getNamePool() {
        return this.targetNamePool;
    }

    public void setNamePool(NamePool namePool) {
        this.targetNamePool = namePool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsAllWhiteSpace;
    }

    public void setStripsAllWhiteSpace(boolean bl) {
        this.stripsAllWhiteSpace = bl;
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getSourceParserClass() != null) {
            XMLReader xMLReader2 = Configuration.makeParser(this.getSourceParserClass());
            return xMLReader2;
        }
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new TransformerFactoryConfigurationError(exception);
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    public XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getStyleParserClass() != null) {
            xMLReader = Configuration.makeParser(this.getStyleParserClass());
        } else {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (Exception exception) {
                throw new TransformerFactoryConfigurationError(exception);
            }
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerFactoryConfigurationError(sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerFactoryConfigurationError(sAXNotSupportedException);
        }
        return xMLReader;
    }

    public String readSchema(String string, String string2, String string3) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
        return null;
    }

    private void needSchemaAwareVersion() {
        throw new UnsupportedOperationException("You need the schema-aware version of Saxon for this operation");
    }

    public void addSchema(Source source) throws TransformerException {
        this.needSchemaAwareVersion();
    }

    public void addSchema(SchemaMarker schemaMarker) throws TransformerConfigurationException {
        this.needSchemaAwareVersion();
    }

    public SchemaMarker getSchema(String string) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(int n) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int n) {
        return null;
    }

    public SchemaType getSchemaType(int n) {
        if (n < 1023) {
            return BuiltInSchemaFactory.getSchemaType(n);
        }
        return null;
    }

    public Receiver getDocumentValidator(Receiver receiver, String string, NamePool namePool, int n) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, int n, SchemaType schemaType, int n2, ValidationContext validationContext, NamePool namePool) throws TransformerException {
        return receiver;
    }

    public ValidationContext getContainedValidationContext(ValidationContext validationContext, int n, boolean bl) throws XPathException {
        this.needSchemaAwareVersion();
        return null;
    }

    public long validateAttribute(int n, CharSequence charSequence, int n2) throws ValidationException {
        return -1L;
    }

    public SchemaType getAttributeType(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public SchemaType getElementType(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public NodeTest makeSubstitutionGroupTest(SchemaDeclaration schemaDeclaration) {
        this.needSchemaAwareVersion();
        return null;
    }

    public void addQueryLibraryModule(StaticQueryContext staticQueryContext) {
        if (this.queryLibraryModules == null) {
            this.queryLibraryModules = new HashMap();
        }
        this.queryLibraryModules.put(staticQueryContext.getModuleNamespace(), staticQueryContext);
    }

    public StaticQueryContext getQueryLibraryModule(String string) {
        if (this.queryLibraryModules == null) {
            return null;
        }
        return (StaticQueryContext)this.queryLibraryModules.get(string);
    }

    public static XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = Loader.getInstance(string);
        }
        catch (TransformerException transformerException) {
            throw new TransformerFactoryConfigurationError(transformerException);
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }
}

