/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _EXPORT_CODEC_H_
#define _EXPORT_CODEC_H_

#include <QObject>

class QMutex;
class QWidget;
class ProcessingOptions;

#include "RawImageInfo.h"

class ExportCodec : public QObject {
  friend class JobThumbnail;
  Q_OBJECT
  public:
    ExportCodec(const QString& _id, const QString& _name, const QString& _extension);
    virtual ~ExportCodec();
    const QString& id() const;
    const QString& name() const;
    const QString& extension() const;
    /**
     * @return a pointer to the configuration widget.
     */
    QWidget* configurationWidget() const;
    void setConfigurationWidget(QWidget* _widget) const;
    /**
     * Fill processing options with the content of the configuration widget.
     */
    virtual void fillProcessingOptions( ProcessingOptions* _processingOptions ) const = 0;
    virtual void setProcessingOptions( const ProcessingOptions& _processingOptions ) const = 0;
    /**
     * Write the data to the file
     */
    virtual bool writeFile( RawImageInfoSP rawImageInfo, const QString& _fileName, const QByteArray& _data, int width, int height, const ProcessingOptions& processingOptions ) = 0;
  protected:
    static QMutex* exiv2Mutex();
  public:
    static ExportCodec* codec( const QString& _id );
    static QList<QString> codecs();
  signals:
    void optionsChanged();
  private:
    struct Private;
    Private* const d;
};

#define REGISTER_CODEC( _CODEC_ ) \
  class _CODEC_##Registrant { \
    public: \
      _CODEC_##Registrant() { ExportCodec::addCodec( new _CODEC_ ); }\
  }; \
  _CODEC_##Registrant instance##_CODEC_##Registrant;

#endif
