#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs
export DARCS_EDITOR=echo

rm -rf temp1
mkdir temp1

cd temp1
$DARCS init

echo hello world > foo
$DARCS add foo
$DARCS record -a --author=me -m "First patch"
i=1
while test $i -le 100; do
  echo foo $i > foo;
  $DARCS record --ignore-times -a --author=me -m "Patch $i" > bar
  i=`expr $i + 1`
done
$DARCS tag --author=me -m 'silly tag'
i=1000
while test $i -le 1096; do
  echo foo $i > foo;
  $DARCS record --ignore-times -a --author=me -m "Patch $i" > bar
  i=`expr $i + 1`
done

$DARCS --version
$DARCS changes | head

cd ..
# rm -rf temp1
