#!/bin/sh

# This test script, originally written by David Roundy is in the public
# domain.

set -ev

test $DARCS || DARCS=$PWD/../darcs
ACTUAL_DARCS=`which $DARCS`
DARCSPATH=`dirname $ACTUAL_DARCS`
export PATH="$DARCSPATH:$PATH"

rm -rf temp1 temp2

mkdir temp1
cd temp1
echo foo > bar
$DARCS initialize
echo record author me > _darcs/prefs/defaults
$DARCS add bar
$DARCS record -a -m addbar

cd ..
$DARCS get temp1 temp2
cd temp1
date > bar
$DARCS record -a -m datebar

cd ../temp1
echo aack >> bar
$DARCS record -a -m aackbar

cd ../temp2

$DARCS pull -av
$DARCS check

cd ..
rm -rf temp1 temp2
