/*
 * Danpei -- a GTK+ based Image Viewer
 * Copyright (C) 2001-2003 Shinji Moiino
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* typedefs.h */

#ifndef __TYPEDEFS_H__

#define __TYPEDEFS_H__

#include <time.h>
#include <gtk/gtk.h>

/* Constant definitions */
typedef enum EnumAppStatus {
  STATUS_NONE          =  0      ,
  STATUS_SELECTED      =  1      ,
  STATUS_NO_SELECTED   =  1 <<  1,
  STATUS_PREV          =  1 <<  2,
  STATUS_NO_PREV       =  1 <<  3,
  STATUS_NEXT          =  1 <<  4,
  STATUS_NO_NEXT       =  1 <<  5,
  STATUS_CLIPBOARD     =  1 <<  6,
  STATUS_NO_CLIPBOARD  =  1 <<  7,
  STATUS_THUMBNAIL     =  1 <<  8,
  STATUS_NO_THUMBNAIL  =  1 <<  9,
  STATUS_APP_QUIT      =  1 << 10,
  STATUS_TABLE_CREATE  =  1 << 11,
  STATUS_TABLE_REFRESH =  1 << 12,
  STATUS_TABLE_PREV    =  1 << 13,
  STATUS_TABLE_NEXT    =  1 << 14
} AppStatus;

typedef enum EnumIconSize{
  ICON_SMALL  =  64,
  ICON_MIDDLE =  96,
  ICON_LARGE  = 128
} IconSize;

typedef enum EnumSortOrder {
  SORT_FILE_NAME_A =  0,
  SORT_CTIME_A         ,
  SORT_ATIME_A         ,
  SORT_MTIME_A         ,
  SORT_FILE_NAME_D     ,
  SORT_CTIME_D         ,
  SORT_ATIME_D         ,
  SORT_MTIME_D 
} SortOrder;

typedef enum EnumEditOperationType {
  EDIT_NONE  = 0,
  EDIT_CUT      ,
  EDIT_COPY     ,
  EDIT_PASTE
} EditOperationType;

typedef enum EnumClipBoardStatus {
  CLIP_NO_OPERATED = 0,
  CLIP_OVERWRITTEN    ,
  CLIP_PASTED
} ClipBoardStatus;

/* Structure definitions */
typedef struct StructThumbnail {
  GtkWidget              *ev_box;
  GtkWidget              *frame;
  GtkWidget              *vbox;
  GtkWidget              *icon_box;
  GtkWidget              *icon;
  GtkWidget              *entry;
  GdkPixmap              *pixmap;

  gchar                  *path;
  gchar                  *filename;
  time_t                 ctime;
  time_t                 atime;
  time_t                 mtime;
  size_t                 size;
  gint                   icon_width;
  gint                   icon_height;

  gboolean               selected;
  gboolean               disabled;
  gboolean               writable;

  struct StructThumbnail *prev;
  struct StructThumbnail *next;
} Thumbnail;

typedef struct StructFileList {
  time_t                ctime;
  time_t                atime;
  time_t                mtime;
  time_t                key_time;
  size_t                size;
  gchar                 *filename;

  struct StructFileList *next;
} FileList;

typedef struct StructThumbnailTable {
  GtkWidget*  scrolled_window;
  GtkWidget*  ev_box;
  GtkWidget*  table;

  gchar*      dir_name;
  gint        file_num;
  gint        start_pos;
  gint        end_pos;

  gint        total_size;
  gint        selected_thumbnails;

  Thumbnail*  top_thumbnail;
  Thumbnail*  end_thumbnail;
} ThumbnailTable;

typedef struct StructClipBoard {
  gchar                  *path;
  gchar                  *filename;
  ClipBoardStatus        status;
  struct StructClipBoard *next;
} ClipBoard;

typedef struct StructManageClipBorad {
  EditOperationType type;
  ClipBoard         *top;
  gint              num;
} ManageClipBoard;

typedef struct StructCacheList {
  gchar                  *cache_name;   /* Name of cache file. */
  gchar                  *pixmap_name;  /* Original file name(full path). */
  size_t                 size;
  struct StructCacheList *next;
} CacheList;

typedef struct StructManageCache {
  gdouble   using_disk;
  gchar     *cache_dir;

  CacheList *top;
  CacheList *last;
} ManageCache;

typedef enum EnumAppDialogResult {
  APP_RET_OK    ,
  APP_RET_CANCEL,
  APP_RET_SKIP  ,
  APP_RET_OK_ALL
} AppDialogResult;

typedef struct StrcutProgressbarDialog {
  GtkWidget            *dialog;
  GtkWidget            *bar;
  GtkWindow            *window;
  gboolean             is_cancel;
} ProgressbarDialog;

typedef struct StructManageDialog {
  GtkWidget            *dialog;
  GtkWindow            *window;
  AppDialogResult      is_ok;
} ManageDialog;

typedef struct StructManageMenu {
  GtkItemFactory       *item_factory;
  GtkAccelGroup        *accel_group;
} ManageMenu;

typedef struct StructNodeInfo {
  gboolean              is_scan;
  gchar                 *path;
  struct StructNodeInfo *prev;
  struct StructNodeInfo *next;
} NodeInfo;

typedef struct StructDirTree {
  GtkWidget            *scrolled_window;
  GtkWidget            *ctree;

  NodeInfo             *top_nodeinfo;
  NodeInfo             *last_nodeinfo;
} DirTree;

typedef struct StructManageStatusbar {
  GtkWidget            *bar;
  guint                context_id;
  guint                message_id;
} ManageStatusbar;

typedef struct StructFormatSwitch {
  gboolean  jpg_on;
  gboolean  bmp_on;
  gboolean  png_on;
  gboolean  xpm_on;
  gboolean  xbm_on;
  gboolean  tif_on;
  gboolean  gif_on;
  gboolean  pcx_on;
} FormatSwitch;

typedef struct StructImageCache {
  gboolean  cache_on;
  gint      cache_size;
  gchar     *cache_dir;
  gboolean  remain_on;
} ImageCache;

typedef struct StructCommandPath {
  gchar     *viewer;
  gchar     *editor;
  gchar     *printer;
  gchar     *rotate_left;
  gchar     *rotate_right;
} CommandPath;

typedef struct StructDialogSwitch {
  gboolean  dir_remove;
  gboolean  remove;
  gboolean  overwrite;
} DialogSwitch;

typedef struct StructViewerOption {
  gboolean  default_external;
  gint      width;
  gint      height;
} ViewerOption;

typedef struct StructAppOption {
  gchar         *filename;
  FormatSwitch  format;
  ImageCache    image_cache;
  CommandPath   path;
  DialogSwitch  dialog;
  gint          max_num;
  IconSize      icon_size;
  SortOrder     sort;
  gboolean      dot_file;
  gboolean      auto_refresh;
  ViewerOption  viewer;
  gboolean      is_viewer_multi_process;
  gboolean      is_editor_multi_process;
} AppOption;

typedef struct StructDanpeiViewer {
  GtkWidget     *window;
  GtkWidget     *vbox;
  GtkWidget     *hbox1, *hbox2;
  GtkWidget     *image_area;
  GtkWidget     *prev_icon;
  GtkWidget     *next_icon;
  GtkWidget     *prev_button;
  GtkWidget     *next_button;
  GtkWidget     *hscale;
  GtkAdjustment *hscale_adj;

  GdkPixmap     *original_pixmap;
  GdkPixmap     *scaled_pixmap;
  gint          image_width;
  gint          image_height;

  Thumbnail     *thumb, *current_thumb;
  gint          area_x, area_y;
  gint          idle_id;
  gboolean      alive;
  GtkAdjustment adj;
} DanpeiViewer;

typedef struct StructTopLevel {
  GtkWidget            *window;
  GtkWidget            *ev_box;
  GtkWidget            *vbox;
  GtkWidget            *handlebox;
  GtkWidget            *toolbar;
  GtkWidget            *tb_hbox;
  GtkWidget            *tb_label;
  GtkWidget            *tb_entry;
  GtkWidget            *prev_icon;
  GtkWidget            *prev_button;
  GtkWidget            *next_icon;
  GtkWidget            *next_button;
  GtkWidget            *dotfile_icon;
  GtkWidget            *dotfile_button;
  GtkWidget            *refresh_dir_icon;
  GtkWidget            *refresh_dir_button;
  GtkWidget            *home_icon;
  GtkWidget            *home_button;
  GtkWidget            *refresh_icon;
  GtkWidget            *refresh_button;
  GtkWidget            *viewer_icon;
  GtkWidget            *viewer_button;
  GtkWidget            *view_icon;
  GtkWidget            *view_button;
  GtkWidget            *edit_icon;
  GtkWidget            *edit_button;
  GtkWidget            *rotate_left_icon;
  GtkWidget            *rotate_left_button;
  GtkWidget            *rotate_right_icon;
  GtkWidget            *rotate_right_button;
  GtkWidget            *cut_icon;
  GtkWidget            *cut_button;
  GtkWidget            *copy_icon;
  GtkWidget            *copy_button;
  GtkWidget            *paste_icon;
  GtkWidget            *paste_button;
  GtkWidget            *print_icon;
  GtkWidget            *print_button;
  GtkWidget            *remove_icon;
  GtkWidget            *remove_button;
  GtkWidget            *hpaned;
  GtkWidget            *hbox;

  ManageMenu           main_menu;
  ManageMenu           popup_thumbnail;
  ManageMenu           popup_dirtree;
  DirTree              dir_tree;
  ThumbnailTable       thumbnail_table;
  ManageStatusbar      statusbar1;
  ManageStatusbar      statusbar2;
  ProgressbarDialog    progressbar_dialog;
  ManageCache          cache;
  AppOption            app_option;
  ManageClipBoard      clipboard;

  /* For folder pixmaps. */
  GdkPixmap            *opened_folder_pixmap;
  GdkPixmap            *closed_folder_pixmap;
  GdkBitmap            *opened_folder_mask;
  GdkBitmap            *closed_folder_mask;

  /* For Viewer. */
  DanpeiViewer         viewer;

  /* Work area. */
  GdkEventButton       last_ev_button;
  gint                 current_icon_size;
  FormatSwitch         current_format;
  SortOrder            current_sort_order;
  gchar                *save_filename;
  gboolean             dot_file_on;
  gboolean             from_2button;
  Thumbnail            *op_thumb;
  gint                 dnd_selected_row;
  AppStatus            app_status;
  gboolean             all_yes;
  GtkWidget            *focused_entry;
  gint                 columns;
} TopLevel;

#endif  /* __TYPEDEFS_H__ */

