/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: misc.h 2528 2011-09-23 21:54:05Z brachman $
 */

#ifndef _MISC_H_
#define _MISC_H_

#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

extern int load_file(char *path, char **buf, size_t *size);
extern int filterthru(char **argv, char **env, int *read_fd, int *write_fd,
					  int *error_fd, pid_t *pidp);
extern char *make_rfc822_date_string(struct tm *tm, int yyyy, int use_gmt);
extern char *make_utc_date_string(struct tm *tm);
extern char *make_local_date_string(struct tm *tm, int show_zone);
extern char *make_short_local_date_string(struct tm *tm);
extern int utc_date_string_to_secs(time_t *secs, char *date);
extern char *make_datetime(struct tm *tm);
extern char *make_approx_relative_date(time_t rel_secs);
extern struct tm *parse_datetime(char *str, time_t *secs, char **endp);
extern char *tm_get_zone_name(struct tm *xtm);
extern long tm_get_gmtoff(struct tm *xtm);
extern char *escape_xml_attribute(char *str, int quote_char);

#ifdef __cplusplus
}
#endif

#endif
