/*
 * Copyright (c) 2003-2011
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 *
 * $Id: email.h 2528 2011-09-23 21:54:05Z brachman $
 */

#ifndef _EMAIL_H_
#define _EMAIL_H_

typedef enum {
  CANON_SIMPLE  = 0,
  CANON_RELAXED = 1,
  CANON_NONE    = 2,
  CANON_DEFAULT = CANON_SIMPLE
} Canon_alg;

typedef struct Email_command_arg {
  int nfields;
  Dsvec *fields;
} Email_command_arg;

/*
 * A specification of how a mailer (MTA) is to be invoked.
 */
typedef struct Email_mailer {
  char *prog;
  Dsvec *argv;
  Dsvec *command_args;
  Dsvec *env;
} Email_mailer;

typedef struct Email_header {
  char *name;
  char *value;
} Email_header;

typedef struct Email_dkim {
  Canon_alg canon_alg;
  Ds *canon_headers;
  Ds *canon_body;
  Ds *canon_mesg;
  char *dkim_signature_header_value;	/* DKIM-Signature */
  Dsvec *headers;
} Email_dkim;

typedef struct Email_message {
  Email_mailer *mailer;
  Dsvec *headers;			/* Vector of (Email_header *) */
  Ds *body;
  Ds *mesg;					/* The ready-to-send message */
  Email_dkim *dkim;
  int finalized;
} Email_message;

#ifdef __cplusplus
extern "C" {
#endif

extern Email_message *email_create(char *mailer, Dsvec *mailer_args,
								   Dsvec *headers, Ds *body,
								   Email_dkim *dkim);
extern Email_message *email_init(char *prog_path);
extern Email_command_arg *email_add_mailer_arg(Email_message *em,
											   unsigned int nfields, ...);
extern Dsvec *email_add_header(Email_message *em, Email_header *eh);
extern Email_header *email_new_header(char *name, char *value);
extern Email_header *email_dup_header(Email_header *old_eh);
extern char *email_add_env(Email_message *em, char *name, char *value);
extern int email_append_to_body(Email_message *em, char *str,
								int do_transform, Kwv *kwv);
extern int email_finalize(Email_message *em, Email_dkim *dkim);
extern int email_send(Email_message *em);
extern int email_show(FILE *fp, Email_message *em);
extern Email_header *email_lookup_header(Email_message *em, char *name);
extern char *email_make_boundary(char *spec, size_t len);
extern Email_message *email_create_transformed(char *mailer,
											   Dsvec *mailer_args,
											   Dsvec *headers,
											   char *content_type,
											   char *template_file,
											   Kwv *kwv, Email_dkim *dkim);

#ifdef __cplusplus
}
#endif

#endif
