__all__ = ['base', 'blas', 'lapack', 'amd', 'umfpack', 'cholmod', 'solvers',
    'modeling', 'printing', 'info']


import base, printing
base.matrix_str    = printing.matrix_str_default
base.matrix_repr   = printing.matrix_repr_default
base.spmatrix_str  = printing.spmatrix_str_default
base.spmatrix_repr = printing.spmatrix_repr_default

def normal(nrows, ncols=1, mean=0.0, std=1.0):
    '''
    Randomly generates a matrix with normally distributed entries.

    normal(nrows, ncols=1, mean=0, std=1)
  
    PURPOSE
    Returns a matrix with typecode 'd' and size nrows by ncols, with
    its entries randomly generated from a normal distribution with mean
    m and standard deviation std.

    ARGUMENTS
    nrows     number of rows

    ncols     number of columns

    mean      approximate mean of the distribution
    std       standard deviation of the distribution
    '''

    try:    
        from cvxopt import gsl
    except:
        from cvxopt.base import matrix
        from random import gauss
        return matrix([gauss(mean, std) for k in xrange(nrows*ncols)],
                      (nrows,ncols) )
        
    return gsl.normal(nrows, ncols, mean, std)

def uniform(nrows, ncols=1, a=0, b=1):
    '''
    Randomly generates a matrix with uniformly distributed entries.
    
    uniform(nrows, ncols=1, a=0, b=1)

    PURPOSE
    Returns a matrix with typecode 'd' and size nrows by ncols, with
    its entries randomly generated from a uniform distribution on the
    interval (a,b).

    ARGUMENTS
    nrows     number of rows

    ncols     number of columns

    a         lower bound

    b         upper bound
    '''

    try:    
        from cvxopt import gsl
    except:
        from cvxopt.base import matrix
        from random import uniform
        return matrix([uniform(a, b) for k in xrange(nrows*ncols)],
                      (nrows,ncols) )

    return gsl.uniform(nrows, ncols, a, b)

def setseed(val = 0):
    ''' 
    Sets the seed value for the random number generator.

    setseed(val = 0)
    
    ARGUMENTS
    value     integer seed.  If the value is 0, the current system time  
              is used. 
    '''    

    try:    
        from cvxopt import gsl
        gsl.setseed(val)
    except:
        from random import seed
        if val is 0: val = None
        seed(val)
        
 
def getseed():
    '''
    Returns the seed value for the random number generator.
    
    getseed()
    '''

    try:    
        from cvxopt import gsl
        return gsl.getseed()
    except:
        raise NotImplementedError, "getseed() not installed (requires GSL) "
    

base.normal = normal
base.uniform = uniform
base.setseed = setseed
base.getseed = getseed
