; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=TortoiseCVS
AppVerName=TortoiseCVS {#TORTOISEVERSION}
AppPublisherURL=http://www.tortoisecvs.org
AppSupportURL=http://www.tortoisecvs.org/support.shtml
AppUpdatesURL=http://www.tortoisecvs.org/download.shtml
DefaultDirName={pf}\TortoiseCVS
DefaultGroupName=TortoiseCVS
OutputDir=.
OutputBaseFilename=TortoiseCVS
PrivilegesRequired=admin
AppVersion={#TORTOISEVERSION}
AppID=TortoiseCVS
AlwaysRestart=yes
VersionInfoVersion={#TORTOISEVERSIONNUMERIC}

; Compression settings
Compression=lzma/ultra
InternalCompressLevel=ultra
SolidCompression=yes

; Some settings to avoid silly questions

; Perhaps enable this later
DirExistsWarning=no
DisableProgramGroupPage=yes
DisableReadyPage=true
DisableStartupPrompt=true
AlwaysShowComponentsList=false

UninstallDisplayIcon={app}\TortoiseAct.exe
WizardImageFile=charlie.bmp

[Languages]
Name: "en_GB"; MessagesFile: "compiler:en_GB.isl"

[Components]
Name: "main"; Description: _("Main Files"); Types: full compact custom; Flags: fixed
Name: "icons"; Description: _("Custom Icons"); Types: full
Name: "icons\barracuda"; Description: "Barracuda"; Types: full
Name: "icons\bertels"; Description: "Stefan Bertels"; Types: full
Name: "icons\nikolai"; Description: "Nikolai Devereaux"; Types: full
Name: "icons\tbf"; Description: "Mathias Hasselmann"; Types: full
Name: "icons\timo"; Description: "Timo Kauppinen"; Types: full
Name: "icons\cosmin"; Description: "Cosmin Smeu"; Types: full
Name: "icons\gregsearle"; Description: "Greg Searle"; Types: full
Name: "icons\PierreOssman"; Description: "Pierre Ossman"; Types: full
Name: "icons\NG"; Description: "Nikolai Giraldo"; Types: full
Name: "icons\TomasLehuta"; Description: "Tomas Lehuta"; Types: full
Name: "icons\XPStyleRounded"; Description: _("XP-style rounded"); Types: full
Name: "icons\Classic"; Description: _("Classic TortoiseCVS"); Types: full
Name: "language"; Description: _("Translations"); Types: full
;Name: "language\ca_01"; Description: _("Catalan"); Types: full
;Name: "language\da_DK"; Description: _("Danish"); Types: full
Name: "language\nl_NL"; Description: _("Dutch"); Types: full
Name: "language\de_DE"; Description: _("German"); Types: full
Name: "language\fr_FR"; Description: _("French"); Types: full
Name: "language\it_IT"; Description: _("Italian"); Types: full
Name: "language\ko_KR"; Description: _("Korean"); Types: full
Name: "language\pl_PL"; Description: _("Polish"); Types: full
Name: "language\pt_BR"; Description: _("Portuguese"); Types: full
Name: "language\ru_RU"; Description: _("Russian"); Types: full
;Name: "language\zh_CN"; Description: _("Simplified Chinese [GBK]"); Types: full
Name: "language\zh_TW"; Description: _("Traditional Chinese [Big5]"); Types: full


[Files]
; These are in the build directory
Source: TortoiseCVS.Filetypes; DestDir: {app}; Flags: restartreplace uninsrestartdelete
Source: TortoiseCVSError.wav; DestDir: {app}; Flags: restartreplace uninsrestartdelete
Source: TortoiseMenus.config; DestDir: {app}; Flags: restartreplace uninsrestartdelete

; CVSNT binaries
Source: ..\src\Cvsnt\ca.pem; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\charset.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\cvs.exe; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\cvslock.exe; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\cvs95.exe; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\cvsagent.exe; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\cvslock.exe; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
#ifdef DEBUG_BUILD
Source: ..\src\Cvsnt\dbghelp.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
#endif
Source: ..\src\Cvsnt\expat.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\ext_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\fork_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\gserver_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\gssapi32.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\iconv.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\krb5_32.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\libeay32_vc71.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\ntserver_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\plink.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\pserver_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\server_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\sserver_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\ssh_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\ssleay32_vc71.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: ..\src\Cvsnt\sspi_protocol.dll; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion

; PUTTY binaries
Source: ..\src\putty\puttygen.exe; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion

; Shared DLLs
Source: ..\src\SharedDlls\msvcp71.dll; DestDir: {sys}; Flags: sharedfile restartreplace
Source: ..\src\SharedDlls\msvcr71.dll; DestDir: {sys}; Flags: sharedfile restartreplace

; Standard icons
Source: ..\src\icons\TortoiseCVS\TortoiseChanged.ico; DestDir: {app}\icons\TortoiseCVS;
Source: ..\src\icons\TortoiseCVS\TortoiseConflict.ico; DestDir: {app}\icons\TortoiseCVS;
Source: ..\src\icons\TortoiseCVS\TortoiseInCVS.ico; DestDir: {app}\icons\TortoiseCVS;
Source: ..\src\icons\TortoiseCVS\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\TortoiseCVS;
Source: ..\src\icons\TortoiseCVS\TortoiseNotInCVS.ico; DestDir: {app}\icons\TortoiseCVS;
Source: ..\src\icons\TortoiseCVS\TortoiseIgnored.ico; DestDir: {app}\icons\TortoiseCVS;
Source: ..\src\icons\TortoiseCVS\TortoiseAdded.ico; DestDir: {app}\icons\TortoiseCVS;

; Icons by Barracuda
Source: ..\src\icons\Barracuda\TortoiseChanged.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"
Source: ..\src\icons\Barracuda\TortoiseConflict.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"
Source: ..\src\icons\Barracuda\TortoiseInCVS.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"
Source: ..\src\icons\Barracuda\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"
Source: ..\src\icons\Barracuda\TortoiseNotInCVS.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"
Source: ..\src\icons\Barracuda\TortoiseIgnored.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"
Source: ..\src\icons\Barracuda\TortoiseAdded.ico; DestDir: {app}\icons\Barracuda; Components: "icons\barracuda"

; Icons by Stefan Bertels
Source: ..\src\icons\Bertels\TortoiseChanged.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"
Source: ..\src\icons\Bertels\TortoiseConflict.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"
Source: ..\src\icons\Bertels\TortoiseInCVS.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"
Source: ..\src\icons\Bertels\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"
Source: ..\src\icons\Bertels\TortoiseNotInCVS.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"
Source: ..\src\icons\Bertels\TortoiseIgnored.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"
Source: ..\src\icons\Bertels\TortoiseAdded.ico; DestDir: {app}\icons\Bertels; Components: "icons\bertels"

; Icons by Cosmin Smeu
Source: ..\src\icons\Cosmin\TortoiseChanged.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"
Source: ..\src\icons\Cosmin\TortoiseConflict.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"
Source: ..\src\icons\Cosmin\TortoiseInCVS.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"
Source: ..\src\icons\Cosmin\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"
Source: ..\src\icons\Cosmin\TortoiseNotInCVS.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"
Source: ..\src\icons\Cosmin\TortoiseIgnored.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"
Source: ..\src\icons\Cosmin\TortoiseAdded.ico; DestDir: {app}\icons\Cosmin; Components: "icons\cosmin"

; Icons by Nikolai Devereaux
Source: ..\src\icons\Nikolai\TortoiseChanged.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"
Source: ..\src\icons\Nikolai\TortoiseConflict.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"
Source: ..\src\icons\Nikolai\TortoiseInCVS.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"
Source: ..\src\icons\Nikolai\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"
Source: ..\src\icons\Nikolai\TortoiseNotInCVS.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"
Source: ..\src\icons\Nikolai\TortoiseIgnored.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"
Source: ..\src\icons\Nikolai\TortoiseAdded.ico; DestDir: {app}\icons\Nikolai; Components: "icons\nikolai"

; Icons by Mathias Hasselmann
Source: ..\src\icons\Tbf\TortoiseChanged.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"
Source: ..\src\icons\Tbf\TortoiseConflict.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"
Source: ..\src\icons\Tbf\TortoiseInCVS.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"
Source: ..\src\icons\Tbf\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"
Source: ..\src\icons\Tbf\TortoiseNotInCVS.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"
Source: ..\src\icons\Tbf\TortoiseIgnored.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"
Source: ..\src\icons\Tbf\TortoiseAdded.ico; DestDir: {app}\icons\Tbf; Components: "icons\tbf"

; Icons by Timo Kauppinen
Source: ..\src\icons\Timo\TortoiseChanged.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"
Source: ..\src\icons\Timo\TortoiseConflict.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"
Source: ..\src\icons\Timo\TortoiseInCVS.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"
Source: ..\src\icons\Timo\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"
Source: ..\src\icons\Timo\TortoiseNotInCVS.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"
Source: ..\src\icons\Timo\TortoiseIgnored.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"
Source: ..\src\icons\Timo\TortoiseAdded.ico; DestDir: {app}\icons\Timo; Components: "icons\timo"

; Icons by Greg Searle
Source: ..\src\icons\GregSearle\TortoiseChanged.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"
Source: ..\src\icons\GregSearle\TortoiseConflict.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"
Source: ..\src\icons\GregSearle\TortoiseInCVS.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"
Source: ..\src\icons\GregSearle\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"
Source: ..\src\icons\GregSearle\TortoiseNotInCVS.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"
Source: ..\src\icons\GregSearle\TortoiseIgnored.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"
Source: ..\src\icons\GregSearle\TortoiseAdded.ico; DestDir: {app}\icons\GregSearle; Components: "icons\gregsearle"

Source: ..\src\icons\PierreOssman\TortoiseChanged.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"
Source: ..\src\icons\PierreOssman\TortoiseConflict.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"
Source: ..\src\icons\PierreOssman\TortoiseInCVS.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"
Source: ..\src\icons\PierreOssman\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"
Source: ..\src\icons\PierreOssman\TortoiseNotInCVS.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"
Source: ..\src\icons\PierreOssman\TortoiseIgnored.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"
Source: ..\src\icons\PierreOssman\TortoiseAdded.ico; DestDir: {app}\icons\PierreOssman; Components: "icons\PierreOssman"

Source: ..\src\icons\NG\TortoiseChanged.ico; DestDir: {app}\icons\NG; Components: "icons\NG"
Source: ..\src\icons\NG\TortoiseConflict.ico; DestDir: {app}\icons\NG; Components: "icons\NG"
Source: ..\src\icons\NG\TortoiseInCVS.ico; DestDir: {app}\icons\NG; Components: "icons\NG"
Source: ..\src\icons\NG\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\NG; Components: "icons\NG"
Source: ..\src\icons\NG\TortoiseNotInCVS.ico; DestDir: {app}\icons\NG; Components: "icons\NG"
Source: ..\src\icons\NG\TortoiseIgnored.ico; DestDir: {app}\icons\NG; Components: "icons\NG"
Source: ..\src\icons\NG\TortoiseAdded.ico; DestDir: {app}\icons\NG; Components: "icons\NG"

Source: ..\src\icons\XPStyleRounded\TortoiseChanged.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"
Source: ..\src\icons\XPStyleRounded\TortoiseConflict.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"
Source: ..\src\icons\XPStyleRounded\TortoiseInCVS.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"
Source: ..\src\icons\XPStyleRounded\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"
Source: ..\src\icons\XPStyleRounded\TortoiseNotInCVS.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"
Source: ..\src\icons\XPStyleRounded\TortoiseIgnored.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"
Source: ..\src\icons\XPStyleRounded\TortoiseAdded.ico; DestDir: {app}\icons\XPStyleRounded; Components: "icons\XPStyleRounded"

Source: ..\src\icons\Classic\TortoiseChanged.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"
Source: ..\src\icons\Classic\TortoiseConflict.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"
Source: ..\src\icons\Classic\TortoiseInCVS.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"
Source: ..\src\icons\Classic\TortoiseInCVSReadOnly.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"
Source: ..\src\icons\Classic\TortoiseNotInCVS.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"
Source: ..\src\icons\Classic\TortoiseIgnored.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"
Source: ..\src\icons\Classic\TortoiseAdded.ico; DestDir: {app}\icons\Classic; Components: "icons\Classic"

; HTML etc.
Source: ..\web\ChangeLog.txt; DestDir: {app};
Source: ..\web\GPL.html; DestDir: {app};
Source: ..\web\Help.html; DestDir: {app};
Source: ..\web\astronlicense.html; DestDir: {app};
Source: ..\web\charlie.jpeg; DestDir: {app};
Source: ..\web\faq.html; DestDir: {app};
Source: ..\web\legal.html; DestDir: {app};
Source: ..\web\philosophical-gnu-sm.jpg; DestDir: {app};
Source: ..\web\style.css; DestDir: {app};

; Compiled executables
Source: {#POSTINST_PATH}; DestDir: {app}; Flags: ignoreversion
Source: {#TORTOISEACT_PATH}; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: {#TORTOISEPLINK_PATH}; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion
Source: {#TORTOISESHELL_PATH}; DestDir: {app}; Flags: restartreplace uninsrestartdelete ignoreversion

; Localization
Source: ..\..\po\TortoiseCVS\en_GB.mo; DestDir: {app}\locale\en_GB; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete
;Source: ..\..\po\TortoiseCVS\ca_01.mo; DestDir: {app}\locale\ca_01; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\ca_01"
;Source: ..\..\po\TortoiseCVS\da_DK.mo; DestDir: {app}\locale\da_DK; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\da_DK"
Source: ..\..\po\TortoiseCVS\de_DE.mo; DestDir: {app}\locale\de_DE; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\de_DE"
Source: ..\..\po\TortoiseCVS\fr_FR.mo; DestDir: {app}\locale\fr_FR; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\fr_FR"
Source: ..\..\po\TortoiseCVS\it_IT.mo; DestDir: {app}\locale\it_IT; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\it_IT"
Source: ..\..\po\TortoiseCVS\ko_KR.mo; DestDir: {app}\locale\ko_KR; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\ko_KR"
Source: ..\..\po\TortoiseCVS\nl_NL.mo; DestDir: {app}\locale\nl_NL; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\nl_NL"
Source: ..\..\po\TortoiseCVS\pt_BR.mo; DestDir: {app}\locale\pt_BR; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\pt_BR"
Source: ..\..\po\TortoiseCVS\ru_RU.mo; DestDir: {app}\locale\ru_RU; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\ru_RU"
;Source: ..\..\po\TortoiseCVS\zh_CN.mo; DestDir: {app}\locale\zh_CN; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\zh_CN"
Source: ..\..\po\TortoiseCVS\zh_TW.mo; DestDir: {app}\locale\zh_TW; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\zh_TW"
Source: ..\..\po\TortoiseCVS\pl_PL.mo; DestDir: {app}\locale\pl_PL; DestName: TortoiseCVS.mo; Flags: restartreplace uninsrestartdelete; Components: "language\pl_PL"

; User Guide
Source: ..\docs\UserGuide_en.chm; DestDir: {app}; Flags: restartreplace uninsrestartdelete
Source: ..\docs\UserGuide_fr.chm; DestDir: {app}; Flags: restartreplace uninsrestartdelete

[Registry]
; Icon handler COM controls
Root: HKCR; Subkey: CLSID\{{5d1cb710-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb710-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb710-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb710-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

Root: HKCR; Subkey: CLSID\{{5d1cb711-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb711-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb711-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb711-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

Root: HKCR; Subkey: CLSID\{{5d1cb712-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb712-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb712-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb712-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

Root: HKCR; Subkey: CLSID\{{5d1cb713-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb713-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb713-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb713-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

Root: HKCR; Subkey: CLSID\{{5d1cb714-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb714-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb714-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb714-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

Root: HKCR; Subkey: CLSID\{{5d1cb715-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb715-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb715-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb715-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

Root: HKCR; Subkey: CLSID\{{5d1cb716-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: CLSID\{{5d1cb716-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: TortoiseCVS
Root: HKCR; Subkey: CLSID\{{5d1cb716-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ; ValueData: {app}\TrtseShl.dll
Root: HKCR; Subkey: CLSID\{{5d1cb716-1c4b-11d4-bed5-005004b1f42f}\InProcServer32; ValueType: string; ValueName: ThreadingModel; ValueData: Apartment

; The actual icon overlay handlers for Explorer
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS0; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS0; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS1; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS1; ValueType: string; ValueName: ; ValueData: {{5d1cb711-1c4b-11d4-bed5-005004b1f42f}
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS2; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS2; ValueType: string; ValueName: ; ValueData: {{5d1cb712-1c4b-11d4-bed5-005004b1f42f}
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS3; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS3; ValueType: string; ValueName: ; ValueData: {{5d1cb713-1c4b-11d4-bed5-005004b1f42f}
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS4; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS4; ValueType: string; ValueName: ; ValueData: {{5d1cb714-1c4b-11d4-bed5-005004b1f42f}
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS5; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS5; ValueType: string; ValueName: ; ValueData: {{5d1cb715-1c4b-11d4-bed5-005004b1f42f}
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS6; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Explorer\ShellIconOverlayIdentifiers\TortoiseCVS6; ValueType: string; ValueName: ; ValueData: {{5d1cb716-1c4b-11d4-bed5-005004b1f42f}

; Make them approved by administrator
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb711-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb712-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb713-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb714-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb715-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved; ValueType: string; ValueName: {{5d1cb716-1c4b-11d4-bed5-005004b1f42f}; ValueData: Tortoise CVS; Flags: uninsdeletevalue

; Context menu handlers
Root: HKCR; Subkey: Directory\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: Directory\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

Root: HKCR; Subkey: Directory\Background\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: Directory\Background\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

Root: HKCR; Subkey: Drive\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: Drive\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

Root: HKCR; Subkey: Folder\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: Folder\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

Root: HKCR; Subkey: *\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: *\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

Root: HKCR; Subkey: InternetShortcut\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: InternetShortcut\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

Root: HKCR; Subkey: lnkfile\shellex\ContextMenuHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: lnkfile\shellex\ContextMenuHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

; Property page handler
Root: HKCR; Subkey: *\shellex\PropertySheetHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: *\shellex\PropertySheetHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

; Property page handler for Folders
Root: HKCR; Subkey: Folder\shellex\PropertySheetHandlers\TortoiseCVS; Flags: uninsdeletekey
Root: HKCR; Subkey: Folder\shellex\PropertySheetHandlers\TortoiseCVS; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

; Info tip handler
;Root: HKCR; Subkey: *\shellex\{{00021500-0000-0000-c000-000000000046}; Flags: uninsdeletekey
;Root: HKCR; Subkey: *\shellex\{{00021500-0000-0000-c000-000000000046}; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

; Info tip handler for Folders
;Root: HKCR; Subkey: Folder\\shellex\{{00021500-0000-0000-c000-000000000046}; Flags: uninsdeletekey
;Root: HKCR; Subkey: Folder\\shellex\{{00021500-0000-0000-c000-000000000046}; ValueType: string; ValueName: ; ValueData: {{5d1cb710-1c4b-11d4-bed5-005004b1f42f}

; Column provider
Root: HKCR; Subkey: Folder\shellex\ColumnHandlers\{{5d1cb710-1c4b-11d4-bed5-005004b1f42f}; Flags: uninsdeletekey
Root: HKCR; Subkey: Folder\shellex\ColumnHandlers\{{5d1cb710-1c4b-11d4-bed5-005004b1f42f}; ValueType: string; ValueName: ; ValueData: Tortoise CVS

; Application sound scheme
Root: HKCU; Subkey: AppEvents\EventLabels\TCVS_Error; ValueType: string; ValueName: ; ValueData: _("Error"); Flags: uninsdeletekey
Root: HKCU; Subkey: AppEvents\Schemes\Apps\TortoiseAct; ValueType: string; ValueName: ; ValueData: "TortoiseCVS"; Flags: uninsdeletekey

; Support for cvs: URLs (e.g. cvs://:pserver:anonymous@cvs.tortoisecvs.sourceforge.net:/cvsroot/tortoisecvs#tortoisecvs-1-0-4)
Root: HKCR; Subkey: CVS; ValueType: string; ValueName: ; ValueData: "URL:CVS Protocol"
Root: HKCR; Subkey: CVS; ValueType: string; ValueName: "URL Protocol"; ValueData: ""
Root: HKCR; Subkey: CVS\DefaultIcon; ValueType: string; ValueName: ; ValueData: "{app}\TortoiseAct.exe"
Root: HKCR; Subkey: CVS\shell\open\command; ValueType: string; ValueName: ; ValueData: """{app}\TortoiseAct.exe"" -u ""%1"""

; Set network compression to none
Root: HKCU; Subkey: Software\TortoiseCVS; ValueType: dword; ValueName: Compression Level; ValueData: 0; Flags: uninsdeletevalue createvalueifdoesntexist

; Set installation path
Root: HKLM; Subkey: Software\TortoiseCVS; ValueType: string; ValueName: "RootDir"; ValueData: "{app}\"

; Use standard icons by default
Root: HKCU; Subkey: Software\TortoiseCVS; ValueType: string; ValueName: Icons; ValueData: "TortoiseCVS"; Flags: uninsdeletevalue createvalueifdoesntexist

; Set cvsignored update interval to 100 seconds
Root: HKCU; Subkey: Software\TortoiseCVS; ValueType: dword; ValueName: "IgnoredList update interval"; ValueData: 100; Flags: uninsdeletevalue createvalueifdoesntexist

; Set external diff and merge tool to "?" 
Root: HKCU; Subkey: Software\TortoiseCVS; ValueType: string; ValueName: "External Merge Application"; ValueData: "?"; Flags: uninsdeletevalue createvalueifdoesntexist
Root: HKCU; Subkey: Software\TortoiseCVS; ValueType: string; ValueName: "External Diff Application"; ValueData: "?"; Flags: uninsdeletevalue createvalueifdoesntexist

; Set language to setup language
Root: HKCU; Subkey: Software\TortoiseCVS; ValueType: string; ValueName: "LanguageIso"; ValueData: "{language}"; Flags: uninsdeletevalue

; Icon set paths
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "TortoiseCVS"; ValueData: "TortoiseCVS";
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Barracuda"; ValueData: "Barracuda"; Components: "icons\barracuda"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Stefan Bertels"; ValueData: "Bertels"; Components: "icons\bertels"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Nikolai Devereaux"; ValueData: "Nikolai"; Components: "icons\nikolai"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Mathias Hasselmann"; ValueData: "Tbf"; Components: "icons\tbf"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Timo Kauppinen"; ValueData: "Timo"; Components: "icons\timo"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Cosmin Smeu"; ValueData: "Cosmin"; Components: "icons\cosmin"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Greg Searle"; ValueData: "GregSearle"; Components: "icons\gregsearle"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Pierre Ossman"; ValueData: "PierreOssman"; Components: "icons\PierreOssman"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Nikolai Giraldo"; ValueData: "NG"; Components: "icons\NG"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: TCVS_PO("XP-style rounded"); ValueData: "XPStyleRounded"; Components: "icons\XPStyleRounded"
Root: HKLM; Subkey: Software\TortoiseCVS\CustomIcons; ValueType: string; ValueName: "Classic TortoiseCVS"; ValueData: "Classic"; Components: "icons\Classic"

; Languages
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "en_GB"; ValueData: "1"
;Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "ca_01"; ValueData: "1"; Components: "language\ca_01"
;Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "da_DK"; ValueData: "1"; Components: "language\da_DK"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "de_DE"; ValueData: "1"; Components: "language\de_DE"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "fr_FR"; ValueData: "1"; Components: "language\fr_FR"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "it_IT"; ValueData: "1"; Components: "language\it_IT"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "ko_KR"; ValueData: "1"; Components: "language\ko_KR"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "nl_NL"; ValueData: "1"; Components: "language\nl_NL"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "pt_BR"; ValueData: "1"; Components: "language\pt_BR"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "ru_RU"; ValueData: "1"; Components: "language\ru_RU"
;Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "zh_CN"; ValueData: "1"; Components: "language\zh_CN"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "zh_TW"; ValueData: "1"; Components: "language\zh_TW"
Root: HKLM; Subkey: Software\TortoiseCVS\Languages; ValueType: dword; ValueName: "pl_PL"; ValueData: "1"; Components: "language\pl_PL"


; Create here so they can be removed on uninstall
Root: HKCU; Subkey: Software\TortoiseCVS; Flags: uninsdeletekey
Root: HKLM; Subkey: Software\TortoiseCVS; Flags: uninsdeletekey


[Icons]
Name: {group}\_("Help"); Filename: {app}\Help.html; WorkingDir: {app}; IconIndex: 0
Name: {group}\_("User Guide (English)"); Filename: {app}\UserGuide_en.chm; WorkingDir: {app}; IconIndex: 0
Name: {group}\_("User Guide (French)"); Filename: {app}\UserGuide_fr.chm; WorkingDir: {app}; IconIndex: 0
Name: {group}\_("Preferences"); Filename: {app}\TortoiseAct.exe; Parameters: CVSPrefs; IconIndex: 0
Name: {group}\_("About"); Filename: {app}\TortoiseAct.exe; Parameters: CVSAbout; IconIndex: 0

[Run]
Filename: {app}\PostInst.exe; WorkingDir: {app}; StatusMsg: Migrating CVS data ...

[InstallDelete]
Type: Files; Name: {app}\TortoisePlinkSSH2.bat
Type: Files; Name: {app}\TortoisePlinkWithPassword.bat
Type: Files; Name: {app}\TortoisePlinkWithPort.bat

[UninstallDelete]
Type: Files; Name: {app}\TrtseShl.dll

[Code]
var
  bNeedRestart: Boolean;

procedure DeleteMsvcDlls;
var
  slFiles: TStringList;
  i: Integer;
begin
  slFiles := TStringList.Create;
  slFiles.Add('{app}\msvcrt.dll');
  slFiles.Add('{app}\msvcp60.dll');
  slFiles.Add('{app}\msvcr70.dll');
  slFiles.Add('{app}\msvcp70.dll');

  for i := 0 to slFiles.Count - 1 do
  begin
    slFiles.Strings[i] := ExpandConstant(slFiles.Strings[i]);
    if FileExists(slFiles.Strings[i]) then
    begin
      if not DeleteFile(slFiles.Strings[i]) then
      begin
        RestartReplace(slFiles.Strings[i], '');
        bNeedRestart := True;
      end;
    end;
  end;
  
  slFiles.Free;
end;


function InitializeSetup: Boolean;
begin
  bNeedRestart := False;
  Result := True;
end;


procedure CurStepChanged(CurStep: Integer);
begin
  if CurStep = csFinished then
  begin
    DeleteMsvcDlls
  end;
end;


function NeedRestart: Boolean;
begin
  Result := bNeedRestart;
end;

