/***************************************************************************
                          cuyointl.cpp  -  description
                             -------------------
    begin                : Sun Nov 9 2008
    copyright            : (C) 2008 by Mark Weyer
    email                : cuyo-devel@nongnu.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <config.h>
#include "cuyointl.h"

#ifdef ENABLE_NLS

  #include <locale.h>
  #include <string.h>

  char* our_gettext(const char* to_translate) {
    if (*to_translate)
      return gettext(to_translate);
    else return "";
  }

  void init_NLS() {

    /* PACKAGE comes from config.h.
       LOCALEDIR is given on the command line, but also originates from
       the configure run. */

    setlocale (LC_ALL, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);
    bind_textdomain_codeset (PACKAGE, "ISO-8859-1");
  }

#else

  void init_NLS() {}

#endif




