# smooth.rb : A simple averageing filter
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

module SciYAG

  # A filter that sorts data according to their X values.
  class XsortFilter < Filter
    include Dobjects

    describe "sort", "Sort", "Sorts the points according to the X values"

    def initialize
    end

    # There you go: a simple averageing filter.
    def apply(f)
      a = Function.new(f.x.dup, f.y.dup)
      a.sort
      return a
    end

    def apply!(f)
      f.sort
    end
  end
end
