#include <ChordSpace.hpp>
#include <iostream>

int main(int argc, const char **argv)
{
	std::cout << "C H O R D S P A C E   U N I T   T E S T S" << std::endl << std::endl;
	std::cout << "EPSILON: " << csound::EPSILON() << std::endl;
	std::cout << "epsilonFactor: " << csound::epsilonFactor() << std::endl;
	std::cout << "EPSILON * epsilonFactor: " << csound::EPSILON() * csound::epsilonFactor() << std::endl;
	std::cout << "csound::eq_epsilon(0.15, 0.15): " << csound::eq_epsilon(0.15, 0.15) << std::endl;
	std::cout << "csound::eq_epsilon(0.1500001, 0.15): " << csound::eq_epsilon(0.1500001, 0.15) << std::endl;
	std::cout << "csound::gt_epsilon(14.0, 12.0): " << csound::gt_epsilon(14.0, 12.0) << std::endl;
	std::cout << "csound::ge_epsilon(14.0, 12.0): " << csound::ge_epsilon(14.0, 12.0) << std::endl;
	csound::Chord chord;
	std::cout << "Default chord: " << chord.toString() << std::endl;
	std::cout << "chord.count(0.0): " << chord.count(0.0) << std::endl;
	csound::Chord other;
	other.setPitch(1, 2);
	std::cout << "Other chord: " << other.toString() << std::endl;
	std::cout << "other.count(0.0): " << other.count(0.0) << std::endl;
	std::cout << "(chord == other): " << (chord == other) << std::endl;
	std::cout << "other.contains(2.0): " << other.contains(2.0) << std::endl;
	std::cout << "other.contains(2.00000001): " << other.contains(2.00000001) << std::endl;
	std::vector<double> result = other.min();
	std::cout << "other.min(): " << result[0] << ", " << result[1] << ", " << result.size() << std::endl;
	std::cout << "other.minimumInterval(): " << other.minimumInterval() << std::endl;
	std::cout << "other.maximumInterval(): " << other.maximumInterval() << std::endl;
	csound::Chord clone = other;
	std::cout << "clone = other: " << clone.toString() << std::endl;
	clone.setPitch(1, .5);
	std::cout << "clone: " << clone.toString() << std::endl;
	csound::Chord floor = clone.floor();
	std::cout << "floor: " << floor.toString() << std::endl;
	csound::Chord ceiling = clone.ceiling();
	std::cout << "ceiling: " << ceiling.toString() << std::endl;
	chord.setPitch(0, 1);
	chord.setPitch(1, 1);
	std::cout << "chord: " << chord.toString() << std::endl;
	std::cout << "chord.distanceToOrigin(): " << chord.distanceToOrigin() << std::endl;
	std::cout << "chord.distanceToUnisonDiagonal(): " << chord.distanceToUnisonDiagonal() << std::endl;
	std::cout << "chord.maximallyEven(): " << chord.maximallyEven().toString() << std::endl;
	std::cout << "chord.T(3): " << chord.T(3).toString() << std::endl;
	std::cout << "chord.I(): " << chord.I().toString() << std::endl;
	std::cout << "csound::epc(13.2): " << csound::epc(13.2) << std::endl;
	std::cout << "chord.isepcs(): " << chord.isepcs() << std::endl;
	chord.setPitch(2, 14);
	std::cout << "chord: " << chord.toString() << std::endl;
	std::cout << "chord.isepcs(): " << chord.isepcs() << std::endl;
	csound::Chord epcs = chord.epcs();
	std::cout << "chord.epcs(): " << epcs.toString() << std::endl;
	std::cout << "csound::epc(14.0): " << csound::epc(14.0) << std::endl;
	csound::Chord transposed = chord.T(5.0);
	std::cout << "chord::T(5.0): " << transposed.toString() << std::endl;
	std::cout << "transposed.iset(): " << transposed.iset() << std::endl;
	csound::Chord et = transposed.et();
	std::cout << "et = transposed.et(): " << et.toString() << std::endl;
	std::cout << "transposed.iseO(): " << transposed.iseO() << std::endl;
	csound::Chord eO = transposed.eO();
	std::cout << "transposed.eO(): " << eO.toString() << std::endl;
	std::cout << "eO.iseO(): " << eO.iseO() << std::endl;
	std::cout << "eO.iseP(): " << eO.iseP() << std::endl;
    csound::Chord eP = eO.eP();
	std::cout << "eP = eO.eP(): " << eP.toString() << std::endl;
	std::cout << "eP.iseT(): " << eP.iseT() << std::endl;
	csound::Chord eT= eP.eT();
	std::cout << "eT = eP.eT(): " << eT.toString() << std::endl;
	std::cout << "eT.iseT(): " << eT.iseT() << std::endl;
	csound::Chord eTT= eP.eTT();
	std::cout << "eTT = eP.eTT(): " << eTT.toString() << std::endl;
	std::cout << "eTT.iseT(): " << eTT.iseTT() << std::endl;
	std::cout << "eT.iseTT(): " << eT.iseTT() << std::endl;
	std::cout << "eTT: " << eTT.toString() << std::endl;
    csound::Chord inverse = eTT.I();
    std::cout << "csound::Chord inverse = eTT.I(): " << inverse.toString() << std::endl;
    csound::Chord inverseOfInverse = inverse.I();
    std::cout << "csound::Chord inverseOfInverse = inverse.I(): " << inverseOfInverse.toString() << std::endl;
    std::cout << "inverse.iseI(): " << inverse.iseI() << std::endl;
    csound::Chord eI = eTT.eI();
    std::cout << "csound::Chord eI = eTT.eI(): " << eI.toString() << std::endl;
    std::cout << "eI.iseI(): " << eI.iseI() << std::endl;    
    std::cout << "eTT.iseI(): " << eTT.iseI() << std::endl;    
    std::cout << "(inverse < eTT): " << (inverse < eTT) << std::endl;
    std::cout << "(eTT < inverse): " << (eTT < inverse) << std::endl;    
    std::cout << "chord: " << chord.toString() << std::endl;
    std::cout << "chord.cycle(): " << chord.cycle().toString() << std::endl;
    std::cout << "chord.cycle(2): " << chord.cycle(2).toString() << std::endl;
    std::cout << "chord.cycle().cycle(): " << chord.cycle().cycle().toString() << std::endl;
    std::cout << "eI: " << eI.toString() << std::endl;
    std::cout << "eI.cycle(-1): " << eI.cycle(-1).toString() << std::endl;
    std::vector<csound::Chord> permutations = chord.permutations();
    std::cout << "Permutations, iseV, eV:" << std::endl;
    for (size_t i = 0; i < permutations.size(); i++)
    {
        const csound::Chord permutation = permutations[i];
        const csound::Chord &eV = permutation.eV();
        std::cout << i << " " << permutation.toString() << "  iseV: " << permutation.iseV() << "  eV: " << eV.toString() << std::endl;
    }
    std::vector<csound::Chord> voicings = chord.voicings();
    std::cout << "voicing, iseV, eV:" << std::endl;
    for (size_t i = 0; i < voicings.size(); i++)
    {
        const csound::Chord voicing = voicings[i];
        const csound::Chord &eV = voicing.eV();
        std::cout << i << " " << voicing.toString() << "  iseV: " << voicing.iseV() << "  eV: " << eV.toString() << std::endl;
    }
    return 0;
}
