<CsoundSynthesizer>
<CsOptions>
; Select audio/midi flags here according to platform
; Audio out   Audio in    No messages
-odac           -iadc     -d     ;;;RT audio I/O
; For Non-realtime ouput leave only the line below:
; -o sndwarpst.wav -W ;;; for file output any platform
</CsOptions>
<CsInstruments>

; Initialize the global variables.

sr = 44100
kr = 4410
ksmps = 10
nchnls = 2


instr 1
  kamp init 10000
  ; Start at 1 second and end at 3.5 seconds.
  ktimewarp line 1, p3, 1.5
  ; Playback at the normal speed.
  kresample init 4
  ; Use the audio file defined in Table #1.
  ifn1 = 1
  ibeg = 0
  iwsize = 4410
  irandw = 100
  ioverlap = 15
  ; Use Table #2 for the windowing function.
  ifn2 = 2
  ; Use the ktimewarp parameter as a "time" pointer.
  itimemode = 1

  a1, a2 sndwarp kamp, ktimewarp, kresample, ifn1, ibeg, iwsize, irandw, ioverlap, ifn2, itimemode
  outs a1, a2
  
endin


</CsInstruments>
<CsScore>
; Table #1: an audio file.
f 1 0 65536 1 "kickroll.wav" 0 0 0
; Table #2: half of a sine wave.
f 2 0 16384 9 0.5 1 0

i 1 0 10
e

</CsScore>
</CsoundSynthesizer>