# By Andres Cabrera - mantaraya36@gmail.com
# Under GPL licence

# This script compares the two opcode lists to generate
# a new list with the differences called "removed_opcodesXO.txt"
# This list is used in quickref.py to exclude removed opcodes
import sys

outputname = ""

if len(sys.argv) == 1:
  input1name = "opcode_list.txt"
  input2name = "opcode_listXO.txt"
  outputname = "removed_opcodesXO.txt"
else:
  input1name = sys.argv[1]
  input2name = sys.argv[2]


infile1 = open(input1name,"r")
infile2 = open(input2name,"r")

opcodelist = []
opcodelistXO = []
excludedopcodes = []
missingopcodes = []

opcodelist = infile1.read().split()
opcodelistXO = infile2.read().split()

print "File", input1name, "has", len(opcodelist),"opcodes"
print "File", input2name, "has", len(opcodelistXO),"opcodes"

for opcode in opcodelist:
  if opcodelistXO.count(opcode) == 0:
    excludedopcodes.append(opcode)

for opcode in opcodelistXO:
  if opcodelist.count(opcode) == 0:
    missingopcodes.append(opcode)

infile1.close()
infile2.close()

print len(excludedopcodes), "excluded opcodes"

outtext = ""

for opcodenum in range(len(excludedopcodes)):
  outtext += excludedopcodes[opcodenum]
  if opcodenum%4  == 3:
    outtext += "\n"
  else:
    outtext += " "


if outputname != "":
  outfile = open(outputname,"w")
  outfile.write(outtext)
  outfile.close()


print outtext
print len(missingopcodes), "missing opcodes"

outtext = ""

for opcodenum in range(len(missingopcodes)):
  outtext += missingopcodes[opcodenum]
  if opcodenum%4  == 3:
    outtext += "\n"
  else:
    outtext += " "

print outtext