#!/bin/sh

cursorstoflop="left_ptr
copy
hand
link
move
pencil
right_ptr
sb_right_arrow"


if [ $# -ne 1 ];
 then
  echo "usage: $0 color"
  echo "example: $0 blue   will make a left-handed version of the blue theme"
 exit 1
fi



function flopcursors () {
 debug=1
 for i in `find . -name '*.png'`; do
     convert $i -flop $i
     test -n $debug && echo Converting: $i
 done
 
 for i in `find . -name '*.conf'`; do
     test -n $debug && echo Adjusting: $i
     cat $i | \
         (
         rm -f $i.flopcursorstmp
         while read ln; do
             size=`echo $ln | cut -f 1 -d " "`
             xhot=`echo $ln | cut -f 2 -d " "`
             yhot=`echo $ln | cut -f 3 -d " "`
             filename=`echo $ln | cut -f 4 -d " "`
             delay=`echo $ln | cut -f 5 -d " "`
             file=`dirname $i`/$filename
             if test -r "$file"; then
                 width=`identify -format %w $file`
             else
                 file=`dirname $i`/`basename $filename`
                 width=`identify -format %w $file`
             fi
             echo $size $((width-xhot-1)) $yhot $filename $delay >>$i.flopcursorstmp
         done
         mv -f $i.flopcursorstmp $i
         )
 done
}

#make the directory of the new theme
mkdir $1'_src_left'/$f

#copy all the cursors to be flipped into the $1'_src_left' dir
for f in $cursorstoflop; do
 cp  $1'_src'/$f'.png' $1'_src_left'/$f'.png'
 if test -e $1'_src'/$f'_32.png'; then
  cp  $1'_src'/$f'_32.png' $1'_src_left'/$f'_32.png'
 fi 
cp  $1'_src'/$f'.conf' $1'_src_left'/$f'.conf'
done

#copy all the nonanim, classic and left_ptr_watch
cp -r $1'_src/nonanim' $1'_src_left/nonanim'
cp -r $1'_src/classic' $1'_src_left/classic'
cp -r $1'_src/left_ptr_watch' $1'_src_left/left_ptr_watch'
mkdir $1'_src_left/watch'
cp  $1'_src/watch/watch12.png' $1'_src_left/watch/watch12.png'
cp  $1'_src/question_arrow.conf' $1'_src_left/question_arrow.conf'

#copy the proper question_arrow, that can't be simply autogenerated
cp left-handed_templates/$1question_arrow.png $1"_src_left"/question_arrow.png
cp left-handed_templates/$1question_arrow_32.png $1"_src_left"/question_arrow_32.png

#mirror all the cursors of the new theme
cd $1"_src_left"
flopcursors

#ops, the left_ptr_watch12.png was flipped two times :-)
convert left_ptr_watch/left_ptr_watch12.png -flop left_ptr_watch/left_ptr_watch12.png

#re-copy the same question_arrow, i know, it's HORRID :-)
cp ../left-handed_templates/$1question_arrow.png question_arrow.png
cp ../left-handed_templates/$1question_arrow_32.png question_arrow_32.png

#generate a new makefile with the proper theme name
sed "s/blue/$1left/g" ../left-handed_templates/Makefile > Makefile


#copy the proper theme file
cp ../left-handed_templates/$1index.theme index.theme


#generate a new makefile with the proper theme name
cd nonanim
sed "s/$1/$1left/g" Makefile > Make2
mv Make2 Makefile

#copy the proper theme file
cp ../../left-handed_templates/$1nonanimindex.theme index.theme

#generate the new makefile if classic, if exists
if test -d "../classic"; then
 cd ../classic
 sed "s/$1/$1left/g" Makefile > Make2
 mv Make2 Makefile
 cp ../../left-handed_templates/$1classicindex.theme index.theme
fi

#copy the proper conf file to left_ptr_watch, otherwise the clock would spin in the wrong direction :-)
cd ../left_ptr_watch
cp ../../left-handed_templates/left_ptr_watch.conf left_ptr_watch.conf


