/*
 *  declarations for loopback-device utilities for cryptmount
 *  $Revision: 161 $, $Date: 2007-05-05 22:53:24 +0100 (Sat, 05 May 2007) $
 *  Copyright 2005-2007, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _LOOPUTILS_H
#define _LOOPUTILS_H

#include <stdlib.h>
#include <sys/types.h>

int loop_findfree(char *buff, size_t buffsz);
int loop_setup(const char *dev, const char *file, int flags);
int loop_ident(unsigned maj, unsigned min, char *buff, size_t buffsz);
int loop_destroy(const char *dev);
int loop_dellist(unsigned devcnt, const dev_t *devids);


#endif  /* _LOOPUTILS_H */

/*
 *  (C)Copyright 2005-2007, RW Penney
 */
