#! /bin/sh
#
### BEGIN INIT INFO
# Provides: crossfire.real-time.com
# Required-Start: $local_fs $network $remote_fs
# Required-Stop: $local_fs $network $remote_fs
# Default-Start:  2 3 4 5
# Default-Stop: 0 1 6
# Short-Description: multiplayer RPG
# Description: Networked graphical RPG/adventure game
### END INIT INFO

PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/crossfire-server
DAEMON_OPTS="-detach -log /var/log/crossfire/logfile"

test -f $DAEMON || exit 0

# Include crossfire defaults if available
if [ -f /etc/default/crossfire ] ; then
	. /etc/default/crossfire
fi

umask 002

case "$1" in
  restart|force-reload)
    start-stop-daemon --stop --retry 5 --verbose --exec $DAEMON
    start-stop-daemon --start --chuid games:games --verbose --exec $DAEMON -- $DAEMON_OPTS
    ;;
  start)
    start-stop-daemon --start --chuid games:games --verbose --exec $DAEMON -- $DAEMON_OPTS
    ;;
  stop)
    start-stop-daemon --stop --retry 5 --verbose --exec $DAEMON
    ;;
  *)
    echo "Usage: /etc/init.d/crossfire-server {start|stop|restart|force-reload}"
    exit 1
    ;;
esac

exit 0
