# cpushare tap
# Copyright (C) 2005-2007  Andrea Arcangeli <andrea@cpushare.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# only version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from twisted.python.usage import Options
from cpushare import client

class Options(Options):
	optParameters = [
		[ 'cpushare_hostname', None, 'cpushare.cpushare.com', ],
		[ 'cpushare_port', None, 4782, ],
		[ 'cpushare_cert', None, 'keys/cpushare_cert.pem', ],

		[ 'order', None, 'order.cpu', ],
		[ 'seccomp_loader', None, 'seccomp-loader', ],
		[ 'cache_dir', None, 'cache', ],
		]

	optFlags = [
#		[ 'verbose', 'v', ],
		]

def makeService(config):
	return client.make_service(config)

from twisted.application import service
s = service.MultiService()
application = service.Application('cpushare')
s.setServiceParent(service.IServiceCollection(application))
