# CEXT_ENABLE_DEBUG(debug=no)
#----------------------------
AC_DEFUN([CEXT_ENABLE_DEBUG],
[
    AC_REQUIRE([AC_PROG_CC])

    ESO_ENABLE_DEBUG([$1])

    if test x"$eso_cv_enable_debug" != xno; then
        CX_DEBUG_FLAGS="-DCX_ENABLE_DEBUG"
    else
        CX_DEBUG_FLAGS="-DCX_DISABLE_ASSERT"
    fi

    AC_SUBST(CX_DEBUG_FLAGS)
])


# CEXT_CHECK_CHAR_BIT
#--------------------
# Check number of bits used per char.
AC_DEFUN([CEXT_CHECK_CHAR_BIT],
[
    cext_have_char_bit=no
    cext_have_char_8_bits=no

    AC_MSG_CHECKING([for bits per char])

    AC_CACHE_VAL(cext_cv_have_char_8_bits,
    [
        AC_LANG_PUSH(C)

        cext_cppflags_save="$CPPFLAGS"
        cext_cflags_save="$CFLAGS"
        cext_ld_flags_save="$LDFLAGS"
        cext_libs_save="$LIBS"

        if test "$GCC" = "yes"; then
            CFLAGS="$CFLAGS -pedantic-errors"
            CPPFLAGS="$CPPFLAGS $CFLAGS"
        fi

        AC_TRY_COMPILE([#include <limits.h>],
                       [int i = CHAR_BIT;],
                       cext_have_char_bit=yes, cext_have_char_bit=no)

        if test "x$cext_have_char_bit" = "xyes"; then
            AC_TRY_RUN(
            [
                #include <limits.h>

                int main() {

                  if (CHAR_BIT != 8)
                    return 1;

                  return 0;
                }
            ], cext_have_char_8_bits=yes, cext_have_char_8_bits=no)
        else
            AC_TRY_RUN(
            [
                #include <limits.h>

                int main() {

                  char c = 1;
                  int i = 0;

                  while (c) {
                    c <<= 1;
                    i++;
                  }

                  if (i != 8)
                    return 1;

                  return 0;
                }
            ], cext_have_char_8_bits=yes, cext_have_char_8_bits=no)
        fi

        CPPFLAGS="$cext_cppflags_save"
        CFLAGS="$cext_cflags_save"
        LDFLAGS="$cext_ldflags_save"
        LIBS="$cext_libs_save"

        AC_LANG_POP

        cext_cv_have_char_8_bits="cext_have_char_bit=$cext_have_char_bit \
        cext_have_char_8_bits=$cext_have_char_8_bits"

    ])

    eval "$cext_cv_have_char_8_bits"

    if test "$cext_have_char_8_bits" = "no"; then
        AC_MSG_ERROR([C type char is not 8 bits wide!])
    else
        if test "$cext_have_char_bit" = "no"; then
            AC_DEFINE(CHAR_BIT, 8, [Width of type 'char'])
        else
            AC_DEFINE(HAVE_CHAR_BIT, 1,
                      [Define if CHAR_BIT is defined in limits.h and equals 8])
        fi
        AC_MSG_RESULT([8])
    fi
])


#
# CEXT_SET_PATHS
#---------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([CEXT_SET_PATHS],
[

    if test -z "$htmldir"; then
        htmldir='${datadir}/doc/${PACKAGE}/html'
    fi

    AC_SUBST(htmldir)
])


# CEXT_CREATE_CXTYPES
#--------------------
# Create the source for cxtypes.h in cext
AC_DEFUN([CEXT_CREATE_CXTYPES],
[
    AC_CONFIG_COMMANDS(cxtypes.h.in,
                       [cfgfile="cext/cxtypes.h.in"
                        tcfgfile="$cfgfile-tmp"
                        echo creating $cfgfile
                        cat > $tcfgfile << _CEXTEOF

_CEXTEOF

                        if test x$cext_have_limits_h = xyes; then
                            echo '#include <limits.h>' >> $tcfgfile
                        fi

                        if test x$cext_have_float_h = xyes; then
                            echo '#include <float.h>' >> $tcfgfile
                        fi

                        if test x$cext_have_values_h = xyes; then
                            echo '#include <values.h>' >> $tcfgfile
                        fi

                        cat >> $tcfgfile << _CEXTEOF

#include <cxmacros.h>

CX_BEGIN_DECLS

/*
 * Some mathematical constants. Some strict ISO C implementations
 * don't provide them as symbols.
 */

/* Deprecated, use constants from cpl_math_const.h instead. */

#define CX_PI    3.14159265358979323846e0

/*
 * Limits for numerical data types
 */

#define CX_MINSHORT  $cext_cxshort_min
#define CX_MAXSHORT  $cext_cxshort_max
#define CX_MAXUSHORT $cext_cxushort_max
#define CX_MININT    $cext_cxint_min
#define CX_MAXINT    $cext_cxint_max
#define CX_MAXUINT   $cext_cxuint_max
#define CX_MINLONG   $cext_cxlong_min
#define CX_MAXLONG   $cext_cxlong_max
#define CX_MAXULONG  $cext_cxulong_max

#define CX_MINFLOAT  $cext_cxfloat_min
#define CX_MAXFLOAT  $cext_cxfloat_max
#define CX_MINDOUBLE $cext_cxdouble_min
#define CX_MAXDOUBLE $cext_cxdouble_max

_CEXTEOF

                        if test -n "$cxint64"; then
                            cat >> $tcfgfile << _CEXTEOF

#define CX_MININT64  ((cxint64)  0x8000000000000000)
#define CX_MAXINT64  ((cxint64)  0x7fffffffffffffff)
#define CX_MAXUINT64 ((cxuint64) 0xffffffffffffffff)

_CEXTEOF

                        fi

                        cat >> $tcfgfile << _CEXTEOF

/*
 * Sized types
 */

typedef signed char cxint8;
typedef unsigned char cxuint8;
_CEXTEOF
                        if test -n "$cxint16"; then
                            cat >> $tcfgfile << _CEXTEOF
typedef signed $cxint16 cxint16;
typedef unsigned $cxint16 cxuint16;
_CEXTEOF
                        fi

                        if test -n "$cxint32"; then
                            cat >> $tcfgfile << _CEXTEOF
typedef signed $cxint32 cxint32;
typedef unsigned $cxint32 cxuint32;

_CEXTEOF
                        fi

                        if test -n "$cxint64"; then
                            cat >> $tcfgfile << _CEXTEOF

CX_GNUC_EXTENSION typedef signed $cxint64 cxint64;
CX_GNUC_EXTENSION typedef unsigned $cxint64 cxuint64;
_CEXTEOF
                        fi

                        echo "" >> $tcfgfile

                        case x$cext_size_t in
                        x2)
                            echo "typedef cxint16 cxssize;" >> $tcfgfile
                            echo "typedef cxuint16 cxsize;" >> $tcfgfile
                            ;;

                        x4)
                            echo "typedef cxint32 cxssize;" >> $tcfgfile
                            echo "typedef cxuint32 cxsize;" >> $tcfgfile
                            ;;

                        x8)
                            echo "typedef cxint64 cxssize;" >> $tcfgfile
                            echo "typedef cxuint64 cxsize;" >> $tcfgfile
                            ;;
                        *)
                            echo "#error size of size_t is unknown" >> \
                                 $tcfgfile
                            ;;
                        esac

                        echo "" >> $tcfgfile

                        if test -f $cfgfile; then
                            if cmp -s $tcfgfile $cfgfile; then
                                echo $cfgfile is unchanged
                                rm -f $tcfgfile
                            else
                                mv $tcfgfile $cfgfile
                            fi
                        else
                            mv $tcfgfile $cfgfile
                        fi
                       ],
                       [
                        # 16 bit integers
                        case 2 in
                        $ac_cv_sizeof_short)
                            cxint16=short
                            ;;
                        $ac_cv_sizeof_int)
                            cxint16=int
                            ;;
                        esac

                        # 32 bit integers
                        case 4 in
                        $ac_cv_sizeof_short)
                            cxint32=short
                            ;;
                        $ac_cv_sizeof_int)
                            cxint32=int
                            ;;
                        $ac_cv_sizeof_long)
                            cxint32=long
                            ;;
                        esac

                        # 64 bit integers
                        case 8 in
                        $ac_cv_sizeof_int)
                            cxint64=int
                            ;;
                        $ac_cv_sizeof_long)
                            cxint64=long
                            ;;
                        $ac_cv_sizeof_long_long)
                            cxint64='long long'
                            ;;
                        esac

                        # size types
                        cext_size_t="$ac_cv_sizeof_size_t"

                        # type limits
                        case xyes in
                        x$ac_cv_header_limits_h)
                            cext_have_limits_h=yes
                            cext_cxshort_min=SHRT_MIN
                            cext_cxshort_max=SHRT_MAX
                            cext_cxushort_max=USHRT_MAX
                            cext_cxint_min=INT_MIN
                            cext_cxint_max=INT_MAX
                            cext_cxuint_max=UINT_MAX
                            cext_cxlong_min=LONG_MIN
                            cext_cxlong_max=LONG_MAX
                            cext_cxulong_max=ULONG_MAX
                            ;;
                        x$ac_cv_header_values_h)
                            cext_have_values_h=yes
                            cext_cxshort_min=MINSHORT
                            cext_cxshort_max=MAXSHORT
                            cext_cxushort_max="(((cxushort)CX_MAXSHORT)*2+1)"
                            cext_cxint_min=MININT
                            cext_cxint_max=MAXINT
                            cext_cxuint_max="(((cxuint)CX_MAXINT)*2+1)"
                            cext_cxlong_min=MINLONG
                            cext_cxlong_max=MAXLONG
                            cext_cxulong_max="(((cxulong)CX_MAXLONG)*2+1)"
                            ;;
                        esac

                        case xyes in
                        x$ac_cv_header_float_h)
                            cext_have_float_h=yes
                            cext_cxfloat_min=FLT_MIN
                            cext_cxfloat_max=FLT_MAX
                            cext_cxdouble_min=DBL_MIN
                            cext_cxdouble_max=DBL_MAX
                            ;;
                        x$ac_cv_header_values_h)
                            cext_have_values_h=yes
                            cext_cxfloat_min=MINFLOAT
                            cext_cxfloat_max=MAXFLOAT
                            cext_cxdouble_min=MINDOUBLE
                            cext_cxdouble_max=MAXDOUBLE
                            ;;
                        esac
                       ])
])
